from unittest import makeSuite

from base import SquishdotBase

from Products.Squishdot.Utility import addFile, createUploadable

class SquishfileTests(SquishdotBase):

    def _fileAssertions(self,Posting):
        theFile = Posting.file
        assert theFile.meta_type=="Squishdot File"
        assert theFile.file_name()=="test.txt"
        assert theFile.file_bytes()==1952
        assert theFile.getContentType()=='text/plain'
        assert hasattr(Posting,'test.txt')
        

    def testAddFile(self):
        "test the Utility.addFile method"
        Posting = self._getPosting()
        addFile(Posting,'tests/test.txt')
        self._fileAssertions(Posting)

    def testAddArticleWithAttachment(self):
        "test adding an Article with an attachment"
        self._addPosting(title    = 'testAddPostingWithAttachment',
                         author   = 'tester',
                         summary  = 'body',
                         encoding = 'Plain',
                         filepath = 'test.txt',
                         subject  = 'test subject')
        Posting = self._getPosting(title='testAddPostingWithAttachment')
        self._fileAssertions(Posting)
        return Posting
        
    def testAddCommentWithAttachment(self):
        "test adding a Comment with an attachment"
        parent = self._getPosting()
        self._addPosting(object=parent,
                         title    = 'testAddPostingWithAttachment',
                         author   = 'tester',
                         body     = 'body',
                         encoding = 'Plain',
                         filepath = 'test.txt')
        Posting = self._getPosting(title='testAddPostingWithAttachment')
        self._fileAssertions(Posting)
        return Posting
        
    def testEditCommentWithAttachment(self):
        "Check the Comment edit method leaves file attachments alone"
        Posting = self.testAddCommentWithAttachment()
        REQUEST = {}
        REQUEST['title']   ='testEditComment'
        REQUEST['author']  ='tester edit'
        REQUEST['body']    ='body edit'
        REQUEST['email']   ='email edit'
        REQUEST['notify']  =0
        REQUEST['encoding']='HTML'
        Posting.edit(REQUEST=REQUEST)
        
        self._fileAssertions(Posting)

    def testEditArticleWithAttachment(self):
        "Check the Article edit method leaves file attachments alone"
        Posting = self.testAddArticleWithAttachment()

        REQUEST={}
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'
        Posting.edit(REQUEST=REQUEST)
        
        self._fileAssertions(Posting)

    def testDeleteArticleAttachment(self):
        "Check deletion of Article attachments"
        Posting = self.testAddArticleWithAttachment()
        
        REQUEST={}
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'
        Posting.edit(REQUEST=REQUEST,delete_attachment='yes')

        theFile = Posting.file
        assert theFile==""
        assert not hasattr(theFile,'test.txt')
        
    def testDeleteCommentAttachment(self):
        "Check deletion of Comment attachments"
        Posting = self.testAddCommentWithAttachment()
        REQUEST = {}
        REQUEST['title']   ='testEditComment'
        REQUEST['author']  ='tester edit'
        REQUEST['body']    ='body edit'
        REQUEST['email']   ='email edit'
        REQUEST['notify']  =0
        REQUEST['encoding']='HTML'
        Posting.edit(REQUEST=REQUEST,delete_attachment='yes')
        
        theFile = Posting.file
        assert theFile==""
        assert not hasattr(theFile,'test.txt')

    def testReplaceArticleAttachment(self):
        "Check deletion of Article attachments"
        Posting = self.testAddArticleWithAttachment()
        
        REQUEST={}
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'

        file = createUploadable('../demo/messages/images.zip')

        Posting.edit(REQUEST=REQUEST,new_attachment=file)

        theFile = Posting.file
        assert theFile.meta_type=="Squishdot File"
        assert theFile.file_name()=="images.zip"
        assert theFile.file_bytes()==17291
        assert theFile.getContentType()=='application/zip'
        assert hasattr(Posting,'images.zip')
        assert not hasattr(theFile,'test.txt')
        
    def testReplaceCommentAttachment(self):
        "Check deletion of Comment attachments"
        Posting = self.testAddCommentWithAttachment()
        REQUEST = {}
        REQUEST['title']   ='testEditComment'
        REQUEST['author']  ='tester edit'
        REQUEST['body']    ='body edit'
        REQUEST['email']   ='email edit'
        REQUEST['notify']  =0
        REQUEST['encoding']='HTML'
        
        file = createUploadable('../demo/messages/images.zip')

        Posting.edit(REQUEST=REQUEST,new_attachment=file)
        
        theFile = Posting.file
        assert theFile.meta_type=="Squishdot File"
        assert theFile.file_name()=="images.zip"
        assert theFile.file_bytes()==17291
        assert theFile.getContentType()=='application/zip'
        assert hasattr(Posting,'images.zip')
        assert not hasattr(theFile,'test.txt')

def test_suite():
    return makeSuite(SquishfileTests)

def debug():
   test_suite().debug()
    
