# Copyright (c) 2001 Chris Withers
#
# This Software is released under the MIT License:
# http://www.opensource.org/licenses/mit-license.html
# See license.txt for more details.
#
# $Id: testStripogram.py,v 1.5 2001/08/20 09:27:31 fresh Exp $

# we need to import ourselves, so add the folder above
# into the module search path
import sys
sys.path.insert(0,'..')

from unittest import makeSuite, TestCase

from stripogram import html2safehtml

valid_tags=['b', 'a', 'i', 'br', 'p','ul','li']
valid_tags2=['b','i','br']

def test(function,input,expected):
    output=''
    output = apply(function,input)
    assert output==expected, "\nInput   : '%s'\nExpected: '%s'\n     Got: '%s'\n" % (input[0],expected,output)

class stripogramTests(TestCase):

    def test_html2safehtml1(self):
        "test correct HTML is left alone 1"
        test(html2safehtml,('<b>x<br>y</b>z<p>a',),'<b>x<br>y</b>z<p>a')

    def test_html2safehtml2(self):
        "test correct HTML is left alone 2"
        test(html2safehtml,('<b>x<br>y<i>z</b>a</i>b<p>',),'<b>x<br>y<i>za</i>b<p></b>')

    def test_html2safehtml3(self):
        "test overlapping tags are closed in the correct order 1"
        test(html2safehtml,('<b><p>x</p>y<p>z</p>a</b>',),'<b><p>x</p>y<p>z</p>a</b>')
        
    def test_html2safehtml4(self):
        "test overlapping tags are closed in the correct order 2"
        test(html2safehtml,('<p>x<i>y</p>z</i>a<p>b</p>',),'<p>x<i>yz</i>a<p>b</p>')
        
    def test_html2safehtml5(self):
        "test optionally closed tags that are correct are left alone"
        test(html2safehtml,('<ul><li>x<li>y<li>z</ul>',valid_tags),'<ul><li>x<li>y<li>z</ul>')
        
    def test_html2safehtml6(self):
        "test that XML-ish unclosed tags are handled sensibly"
        test(html2safehtml,('Roses <b>are</B> red,<br/>violets <i>are</i> blue',valid_tags2),
                            'Roses <b>are</b> red,<br>violets <i>are</i> blue')
        
    def test_html2safehtml7(self):
        "check that unfinished start tags at the end of input are ignored"
        test(html2safehtml,('Roses <b>are</B> red,<br/QUACK',valid_tags2),
                            'Roses <b>are</b> red,')
        
    def test_html2safehtml8(self):
        "check that unfinished end tags at the end of input are ignored"
        test(html2safehtml,('Roses <b>are</B> red,<br/</blink>QUACK<//blink> violets <i>are</i> blue',valid_tags2),
                            'Roses <b>are</b> red,QUACK violets <i>are</i> blue')
        
    def test_html2safehtml9(self):
        "test for bug reported by J M Cerqueira Esteves <jmce@artenumerica.com>"
        test(html2safehtml,('Roses <b>are</B> red,QUACK<//blink',valid_tags2),
                            'Roses <b>are</b> red,QUACK')
        
    def test_html2safehtml10(self):
        "test for non-bug reported by on Squishdot's Bug Tracker"
        test(html2safehtml,('a<form>b<input name="test" type="text">c</form>d',valid_tags),'abcd')
        
    def test_html2safehtml11(self):
        "test that entity refs are handled nicely"
        test(html2safehtml,('&lt;squishdot@yahoo.com&gt;',),'&lt;squishdot@yahoo.com&gt;')

    def test_html2safehtml12(self):
        "test that ampersands aren't buggered about with"
        test(html2safehtml,('one & two & three &three; &blagh ;',),'one &amp; two &amp; three &amp;three; &amp;blagh ;')
        
def test_suite():
    return makeSuite(stripogramTests)

def debug():
   test_suite().debug()
    
                                
