package Templates::Caution;

use SmallPigVars qw($config);
use Templates::Default;

use strict;
use vars qw(@ISA $template $lang);

@ISA = qw(Templates::Default);

sub new{
  my ($class, $spcgi, $spdb, $btitle, $bmsg, $uri, $refresh) = @_;

  $template = Templates::Default->new($spcgi, $spdb, "index");

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  $template->{'pagetype'} = "caution";

  $template->{'title'} = "";

  $lang = $template->{'lang'};
  
  $template->{'btitle'}   = $btitle || $lang->{'cant_proceed'};
  $template->{'bmsg'}     = $bmsg;
  $template->{'uri'}      = $uri || $ENV{'SCRIPT_NAME'};
  $template->{'refresh'}  = $config->{'refresh'} || $refresh || 2 if $refresh != -1; 
  $template->{'cookie'};

  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'caution'} = "caution.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'caution'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  $template->SUPER::print_standard_index();
  print_caution_msg();
}

sub print_caution_msg{
  my ($STATE, $spdb, $btitle, $bmsg) = 
      map{ $template->{$_} } qw(STATE spdb btitle bmsg);
  my $DBH = $spdb->{'dbh'};

  my $back =  qq|<a href="$template->{'uri'}">&lt</a> <a href="$template->{'uri'}">back</a>| if !$btitle;
  
  $btitle ||= $template->{'btitle'};
  $bmsg ||= $template->{'bmsg'};
  
  $template->SUPER::print_block_start("","", $btitle);

  print qq|
      <TR><TD>
	  <TABLE border=0 cellpadding=10><TR><TD>
	      $bmsg<br>$back

		  </TD></TR></TABLE>
		      </TD></TR>|;
  
  $template->SUPER::print_block_end();
}

return 1;




