package Templates::Admin::SmallPig;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(@EXPORT_OK);
@EXPORT_OK = qw();

use SmallPigVars qw($config);

use CGI qw(:standard :cgi-lib);
use strict;

use SPDB;
my $spdb ||= SPDB->new;
my $DBH = $spdb->{'dbh'};

sub add_br{
  my $body = shift;
  my @body = split('\n', $body);
  return join('<BR>', @body);
}

sub filter_quote{
  my $str = shift;
  $str =~ s/\"/&quot;/g;
  return $str;
}

sub filter_html{
  my $str = shift;
  $str =~ s/</&lt;/g;
  $str =~ s/>/&gt;/g;
  $str = filter_quote($str);
  return $str;
}

sub recover_quote{
  my $str = shift;
  $str =~ s/&quot;/\"/g;
  return $str;
}

sub recover_html{
  my $str = shift;
  $str =~ s/&lt;/</g;
  $str =~ s/&gt;/>/g;
  $str =~ s/&quot;/\"/g;
  return $str;
}

sub format_markup{
    my ($str) = @_;
    # --- format email address
    $str =~ s/\[email\](.+?)\[\/email\]/<A HREF=mailto:$1>$1<\/A>/gsi;
    # --- format url 
    $str =~ s/\[url\](.+?)\[\/url\]/<A HREF=$1>$1<\/A>/gsi;
    # --- format image
    $str =~ s/\[img\](.+?)\[\/img\]/<IMG SRC=$1 BORDER=0>/gsi;
    # --- format i
    $str =~ s/\[i\](.+?)\[\/i\]/<i>$1<\/i>/gsi;
    # --- format b
    $str =~ s/\[b\](.+?)\[\/b\]/<b>$1<\/b>/gsi;
    return $str;
}

sub recover_markup{
    my ($str) = @_;
    # --- format email address
    $str =~ s/\[email\](.+?)\[\/email\]/$1/gsi;
    # --- format url 
    $str =~ s/\[url\](.+?)\[\/url\]/$1/gsi;
    # --- format image
    $str =~ s/\[img\](.+?)\[\/img\]//gsi;
    # --- format i
    $str =~ s/\[i\](.+?)\[\/i\]/$1/gsi;
    # --- format b
    $str =~ s/\[b\](.+?)\[\/b\]/$1/gsi;
    return $str;
}

sub url_encode{
  my $words = shift;
  $words =~ s/([^a-zA-Z0-9_.-])/"%".sprintf("%1X", ord($1))/eg;
  return $words;
}

sub thread_has_attachment{
  my ($sid, $cid) = @_;
  my $sidq = $DBH->quote($sid);
  return ($spdb->db_count("FileAttach", "sid=$sidq AND cid=$cid") > 0);
}

sub check_all_script{
  my ($name) = @_;
  my $ret = qq|
<script language="JavaScript">
<!--
function CheckX()
{
  document.$name.selectedthreads1.checked = !document.$name.selectedthreads1.checked;
  CheckAll();
}
function CheckAll()
{
  for (var i=0;i<document.$name.elements.length;i++){
    var e=document.$name.elements[i];
    if (e.name != 'selectedthreads1')
      e.checked=document.$name.selectedthreads1.checked;
  }
}
//-->
</script>
|;
}

sub get_board_status{
  my $level = shift;
  my $status = "public" unless 63^$level;
  $status = "public protected" unless 62^$level;
  $status = "user public" unless 60^$level;
  $status = "user private" unless 56^$level;
  $status = "user private protected" unless 48^$level;
  $status = "group private" unless 32^$level;
  return $status;
}

sub db_quote{
    return $spdb->{'dbh'}->quote($_);
}

sub select_forums_w_cats{
    my ($ssid, $userstatus, $tuserstatus, $lang) = @_;
    my $ret = "<SELECT NAME=\"catandboard\"><FONT SIZE=-1>";
    my ($cats) = $spdb->db_select_many(1, "catid, cattitle", "Cats", "", 
				       "ORDER BY catorder");
    foreach (@$cats){
	my ($catid, $cattitle) = @$_;
	$ret .= "<OPTION SELECTED VALUE=\"$catid\">$cattitle"; 

	my $catidq = $DBH->quote($catid);
	my ($boards) = 
	    $spdb->db_select_many(1, "B.sid, B.title, B.level", 
				  "Boards AS B, BoardBelongToCat AS BC",
				  "catid=$catidq AND B.sid=BC.sid", 
				  "ORDER BY sorder");
	
	# --- sid from mod userstatus --> ptr to arr
	my $sfmus = $tuserstatus->{mod};
	my $sfgmus = $tuserstatus->{gmem};

	foreach (@$boards){
	    my ($sid, $title, $level) = @$_;
	    my $bstatus = get_board_status($level);
	    $ret .= "<OPTION SELECTED VALUE=\"$sid\">- $title" 
		if($sid ne $ssid && 
   ($userstatus eq "admin" || 
    ($bstatus =~ /group/ && ($sfmus && grep { $_ eq $sid } @$sfmus)) ||
     ($bstatus eq "group private" && ($sfgmus && grep { $_ eq $sid } @$sfgmus)) ||
     $bstatus =~ /public/ || $bstatus =~ /user private/)
     ); 
	}
    }
    $ret .= "</FONT></SELECT>";
    return $ret;
    
}

sub select_categories{
  my ($sid, $op) = @_;
  my ($ret, $cat, $where);
  
  $ret = "<SELECT NAME=\"category\">";
  my ($scat, $ssorder);
  if($sid){
    my $sidq = $DBH->quote($sid);
    my $cattitle;
    ($cattitle, $scat, $ssorder) = 
      $spdb->db_select_cols("cattitle, C.catid, sorder", 
			   "BoardBelongToCat AS BC, Cats AS C", 
			   "BC.sid=$sidq AND 
                            BC.catid=C.catid");
    $ret .= "<OPTION SELECTED VALUE=\"$scat|$ssorder\" SELECTED>$cattitle - $ssorder" 
      if $cattitle && $ssorder;
  }
  
  my ($cata) = $spdb->db_select_many(1, "catid, cattitle", "Cats");
    
  foreach (@$cata){
    my ($cat1, $cattitle) = @$_;

    # --- find the number of boards
    my $catidq = $DBH->quote($cat1);
    my $cnt = $spdb->db_count("BoardBelongToCat", "catid=$catidq");
    my $tmp = {}; $cnt++ if $op ne "ChooseBoard" || ($sid && $scat ne $cat1);
    for(my $i=1; $i<=$cnt; $i++){ 
      if($scat eq $cat1 && $ssorder == $i){ next; }
      $ret .= "<OPTION VALUE=\"$cat1|$i\">$cattitle - $i";
    }
  }
  
  $ret .= "</SELECT>";
  return $ret;
}

sub select_option{
  my ($opts, $name, $sel) = @_;
  my $ret = "<SELECT NAME=\"$name\"><FONT SIZE=-1>";
  foreach (keys(%$opts)){
    my $value = $opts->{$_};
    $ret .= "
<OPTION ".(($value eq $sel)?"SELECTED":"")." VALUE=\"$value\">$_";
  }
  $ret .= "</FONT></SELECT>";
  return $ret;
}

sub select_comment{
  my ($cid, $lang) = @_;
  my ($subject, $bodytext, $hits, $ip, $time,  
      $closed, $sid, $uid) = 
	$spdb->db_select_cols("subject, bodytext, hits, ip, 
                          date_format(date, \"$config->{date_format}\"),
                          closed, sid, uid",
			     "Posts", "cid=$cid");
  my ($name, $email, $privlev);
  if($uid != 0){
      ($name, $email, $privlev) = 
	  $spdb->db_select_cols("nickname, fakeemail, privlev",
				"Users", "uid=$uid");
  }
  else{
      ($name, $email) = 
	  $spdb->db_select_cols("anon, email", "AnonPosts", "cid=$cid");
  }
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild", 
				   "childid=$cid");
  
  my $mpid = Templates::Admin::SmallPig::select_the_most_parent($cid);
  my ($lastmod, $replies) =
    $spdb->db_select_cols("date_format(lastmod, \"$config->{date_format}\"),
                          replies",
			 "MostParents",
			 "cid=$mpid");

  # --- lang support
  $time =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
  $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

  return ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
	  $name, $email, $pid, $lastmod, $replies, $privlev);
}

sub get_thread_info{
  my ($STATE, $cid, $cnt, $lang) = @_;

  my ($display, $page, $view, $postsper, $curr_cid, $mode, $nps) = 
    map{ $STATE->{$_} } qw(display page view postsper cid mode nps);  

  my ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
      $name, $email, $pid, $lastmod, $replies, $privlev) = 
	Templates::Admin::SmallPig::select_comment($cid);

  my ($subject_info, $user_info, $images);

  if($uid == 0){
      $user_info = ($name)?"$name(anon)":"anon"; 
      if($email && $name){
	  $user_info = CGI::a({-href=>"mailto:$email"}, $user_info); 
      }
  }
  else{ 
      if(!$privlev){
	  $user_info = CGI::a({-href=>"$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=$postsper"}, $name);
      }
      else{
	  $user_info = CGI::a({-href=>"mailto:$email"}, $name);
      }
  }

  $subject = Templates::Admin::SmallPig::filter_html($subject);
  if(length($subject) > $config->{'sublen'}){
    ($subject) = unpack "a$config->{'sublen'}", $subject;
    $subject .= "...";
  }
  if($cid == $curr_cid){ 
    $subject_info = "<B>$subject</B>"; 
  }
  else{
    $sid = url_encode($sid);
    $subject_info = CGI::a({-href=>"$config->{'cgidir'}/comments.cgi?op=threadlist&page=$page&sid=$sid&cid=$cid&view=$view&display=$display&mode=$mode"}, $subject);
  }

  unless($cnt){ 

    my ($cnt1, $children, $newpost) = (0, []);

    # --- get the children of this thread
  Templates::Admin::SmallPig::select_children($cid, $children);
    
    foreach (@$children){
	my $child = $_;
	$cnt1 += grep { $child eq $_ } split(/\, /, $nps->{$sid});
    }
    
    if($STATE->{'userstatus'} ne "anon"){    
	$newpost = "<b><FONT class=\"caution\">($cnt1 $lang->{'new'})</FONT></B>" 
	    if($cnt1);
    }

    # --- if no child
    if(@$children == 0){
	for(my $i=0; $i<1; $i++){
	    $images .= CGI::img({src=>"$config->{'imagesdir'}/$config->{'empty_image'}", border=>0});
	}
    }
    else{
	# --- all read
	my $timg;
	if($cnt1){
	    $timg = $config->{'threadsomeread_image'};
	}
	else{
	    $timg = $config->{'threadallread_image'};
	}
	$images = CGI::img({src=>"$config->{'imagesdir'}/$timg", border=>0});
#      $images .= CGI::img({src=>"$config->{'imagesdir'}/$config->{'plus_image'}", border=>0});
    }
        
#    $images .= CGI::img({src=>"$config->{'imagesdir'}/$config->{'minus_image'}", border=>0}); 
    my $timg;
    if(Templates::Admin::SmallPig::thread_has_attachment($sid, $cid)){
	$timg = $config->{'threadwattachment_image'};
    }
    elsif($nps->{$sid} =~ /$cid/){ $timg = $config->{'unreadthread_image'}; }
    else{ $timg = $config->{'readthread_image'}; }
    $images .= CGI::img({src=>"$config->{'imagesdir'}/$timg", border=>0}); 
  }
  else{
    for(my $i=0; $i<=$cnt; $i++){
      $images .= CGI::img({src=>"$config->{'imagesdir'}/$config->{'empty_image'}", border=>0});
    }
    my $timg;
    if(Templates::Admin::SmallPig::thread_has_attachment($sid, $cid)){
	$timg = $config->{'threadwattachment_image'};
    }
    elsif($nps->{$sid} =~ /$cid/){ $timg = $config->{'unreadthread_image'}; }
    else{ $timg = $config->{'readthread_image'}; }
    $images .= CGI::img({src=>"$config->{'imagesdir'}/$timg", border=>0});
  }
  my $ret;
  if($mode eq "printable"){
        $ret = qq!
	    <LI>$subject_info by $user_info on $time
		!;
    }
  else{
      $ret = qq!
	  <TR>
	      <TD>$images&nbsp;$subject_info</TD>
		  <TD WIDTH=$config->{'cuser_w'}>$user_info</TD>
		      <TD WIDTH=$config->{'edate_w'}>$time</TD></TR>
			  !;
  }
  return $ret;
};

sub get_subthreads_info{
  my ($STATE, $cid, $ret, $ref, $cnt) = @_;

  my $sidq =  $DBH->quote($STATE->{'sid'});

  my ($tmp) = 
    $spdb->db_select_many(1, "childid", 
			 "ParentAndChild, Posts", 
			 "parentid=$cid AND childid=cid AND sid=$sidq
                          AND approved=1");
  if(!$tmp){
    return;
  }
  else{
    foreach (@$tmp){
      my ($childid) = @$_;
      $$ret .= &{$ref}($STATE, $childid, $cnt);
      get_subthreads_info($STATE, $childid, $ret, $ref, $cnt+1);
    }
  }
}

sub select_the_most_parent{
  my ($cid) = @_;
  # --- find out its parentid
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild",
				   "childid=$cid");
  if(!$pid){
    return $cid;
  }
  else{
    select_the_most_parent($pid);
  }
}

sub select_children{
  my ($cid, $children) = @_;
  my ($tmp) = $spdb->db_select_many(1, "childid", "ParentAndChild", 
				   "parentid=$cid");
  if(!$tmp){
    return $children;
  }
  else{
    foreach (@$tmp){
      my ($childid) = @$_;
      unshift @$children, $childid;
      select_children($childid, $children);
    }
  }
}

return 1;


