-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Command_Line;
with E_Strings;

--# inherit Command_Line,
--#         E_Strings,
--#         SPARK.Ada.Strings.Unbounded,
--#         SPARK_IO;

package Victor_Wrapper is

   --  This procedure does two things:
   --
   --  1. It first checks that the environment is OK, i.e. all
   --  relevant binaries, libraries and vcg/siv files are present.
   --
   --  2. It then assembles the argument list to vct and spawns.
   procedure Execute (CL    : in     Command_Line.Command_Line_Data_T;
                      Ok    :    out Boolean;
                      Error :    out E_Strings.T);
   --# global in out SPARK_IO.File_Sys;

end Victor_Wrapper;
