-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Text_IO;

--# inherit SPARK.Ada.Text_IO;

package SPARK_Ada_Integer_Text_IO is

   -- Default_Width := SPARK.Ada.Text_IO.Field := Integer'Width;
   function Default_Width return  SPARK.Ada.Text_IO.Field;

   -- procedure Get
   --   (File  : File_Type;
   --    Item  : out Integer;
   --    Width : Field := 0);
   procedure Get_File (File  : in out SPARK.Ada.Text_IO.File_Type;
                       Item  :    out Integer;
                       Width : in     SPARK.Ada.Text_IO.Field);
   --# derives File,
   --#         Item from File,
   --#                   Width;

   -- procedure Put
   --   (File  : File_Type;
   --    Item  : Integer;
   --    Width : Field := Default_Width;
   --    Base  : Number_Base := Default_Base);
   procedure Put_File
     (File  : in out SPARK.Ada.Text_IO.File_Type;
      Item  : in     Integer;
      Width : in     SPARK.Ada.Text_IO.Field;
      Base  : in     SPARK.Ada.Text_IO.Number_Base);
   --# derives File from *,
   --#                   Base,
   --#                   Item,
   --#                   Width;

   -- procedure Put
   --   (File  : File_Type   := Standard_Output;
   --    Item  : Integer;
   --    Width : Field       := Default_Width;
   --    Base  : Number_Base := Default_Base);
   procedure Put_Output (Item  : in Integer;
                         Width : in SPARK.Ada.Text_IO.Field;
                         Base  : in SPARK.Ada.Text_IO.Number_Base);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Base,
   --#                                                    Item,
   --#                                                    Width;

end SPARK_Ada_Integer_Text_IO;
