-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Text_IO.Unbounded_String                                        --
--                                                                           --
-- Description                                                               --
--   This is a binding to package Ada.Text_IO                                --
--                                                                           --
-- Language                                                                  --
--   Specification : SPARK                                                   --
--   Private Part  : Ada                                                     --
--   Body          : Ada                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   Full Ada Runtime                                                        --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   Functions and Look_Ahead_* procedures may raise exceptions at present.  --
--   The intention is to add preconditions in future to guard against these. --
--   For details of the exceptions that can be raised please refer to        --
--   Ada.Text_IO.                                                            --
--                                                                           --
--   Exceptions raised in procedures are caught and returned via the File    --
--   parameter, which must be tested for exception status by calling the     --
--   appropriate Get_Last_Exception_* function. The exception can be         --
--   reraised by calling the appropriate Raise_Last_Exception_* procedure.   --
--                                                                           --
--   IMPORTANT NOTE. When adding a new procedure to this package the         --
--   procedure body must re-raise the exception if Get_Exception_T returns   --
--   No_Exception, otherwise unexpected exceptions will be silently ignored. --
--   The existing procedure bodies provide examples of this.                 --
--                                                                           --
-------------------------------------------------------------------------------

with SPARK.Ada.Strings.Unbounded;

--# inherit SPARK.Ada.Strings.Unbounded,
--#         SPARK.Ada.Text_IO;

package SPARK.Ada.Text_IO.Unbounded_String is

   --  procedure Create
   --    (File : in out File_Type;
   --     Mode : in     File_Mode := Out_File;
   --     Name : in     String    := "";
   --     Form : in     String    := "");
   procedure Create
     (File :    out Text_IO.File_Type;
      Mode : in     Text_IO.File_Mode;
      Name : in     Strings.Unbounded.Unbounded_String;
      Form : in     Strings.Unbounded.Unbounded_String);
   --# derives File from Form,
   --#                   Mode,
   --#                   Name;
   --# declare delay;

   --  procedure Open
   --    (File : in out File_Type;
   --     Mode : in     File_Mode;
   --     Name : in     String;
   --     Form : in     String := "");
   procedure Open
     (File :    out Text_IO.File_Type;
      Mode : in     Text_IO.File_Mode;
      Name : in     Strings.Unbounded.Unbounded_String;
      Form : in     Strings.Unbounded.Unbounded_String);
   --# derives File from Form,
   --#                   Mode,
   --#                   Name;
   --# declare delay;

   function Name
     (File : Text_IO.File_Type) return Strings.Unbounded.Unbounded_String;

   function Form
     (File : Text_IO.File_Type) return Strings.Unbounded.Unbounded_String;

   --  procedure Put (File : in File_Type;
   --                 Item : in String);
   procedure Put_File
     (File : in out Text_IO.File_Type;
      Item : in     Strings.Unbounded.Unbounded_String);
   --# derives File from *,
   --#                   Item;
   --# declare delay;

   --  procedure Put (File : in File_Type := Standard_Output;
   --                 Item : in String);
   procedure Put_Output
     (Item : in Strings.Unbounded.Unbounded_String);
   --# global in out Text_IO.The_Standard_Output;
   --# derives Text_IO.The_Standard_Output from *,
   --#                                          Item;
   --# declare delay;

   --  procedure Put (File : in File_Type := Standard_Error;
   --                 Item : in String);
   procedure Put_Error
     (Item : in Strings.Unbounded.Unbounded_String);
   --# global in out Text_IO.The_Standard_Error;
   --# derives Text_IO.The_Standard_Error from *,
   --#                                         Item;
   --# declare delay;

   --  procedure Get_Line
   --    (File : in     File_Type;
   --     Item :    out String;
   --     Last :    out Natural);
   procedure Procedure_Get_Line_File
     (File     : in out Text_IO.File_Type;
      Item     :    out Strings.Unbounded.Unbounded_String;
      Arg_Last :    out Natural);
   --# derives Arg_Last,
   --#         File,
   --#         Item     from File;
   --# declare delay;

   --  procedure Get_Line
   --    (File : in     File_Type := Standard_Input;
   --     Item :    out String;
   --     Last :    out Natural);
   procedure Procedure_Get_Line_Input
     (Item     : out Strings.Unbounded.Unbounded_String;
      Arg_Last : out Natural);
   --# global in out Text_IO.The_Standard_Input;
   --# derives Arg_Last,
   --#         Item,
   --#         Text_IO.The_Standard_Input from Text_IO.The_Standard_Input;
   --# declare delay;

   --  function Get_Line (File : File_Type) return String;
   function Function_Get_Line_File
     (File : Text_IO.File_Type) return Strings.Unbounded.Unbounded_String;

   --  function Get_Line (File : File_Type := Standard_Input) return String;
   function Function_Get_Line_Input
     return Strings.Unbounded.Unbounded_String;

   --  procedure Put_Line
   --    (File : in File_Type;
   --     Item : in String);
   procedure Put_Line_File (File : in out Text_IO.File_Type;
                            Item : in     Strings.Unbounded.Unbounded_String);
   --# derives File from *,
   --#                   Item;
   --# declare delay;

   --  procedure Put_Line
   --    (File : in File_Type := Standard_Output;
   --     Item : in String);
   procedure Put_Line_Output (Item : in Strings.Unbounded.Unbounded_String);
   --# global in out Text_IO.The_Standard_Output;
   --# derives Text_IO.The_Standard_Output from *,
   --#                                          Item;
   --# declare delay;

   --  procedure Put_Line
   --    (File : in File_Type := Standard_Error;
   --     Item : in String);
   procedure Put_Line_Error (Item : in Strings.Unbounded.Unbounded_String);
   --# global in out Text_IO.The_Standard_Error;
   --# derives Text_IO.The_Standard_Error from *,
   --#                                         Item;
   --# declare delay;

end SPARK.Ada.Text_IO.Unbounded_String;
