separate (ErrorHandler.Conversions.ToString.StabilityError)
procedure StabilityErrorExpl (E_Str   : in out E_Strings.T)

is
begin
   case Stab_Typ is
      when ErrorHandler.Stable_Exit_Cond =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "In these cases the (loop) exit condition occurs in an iteration scheme," &
              " an exit statement, or an if-statement whose (unique) sequence of" &
              " statements ends with an unconditional exit statement - see the SPARK" &
              " Definition. The concept of loop stability is explained in Section" &
              " 4.4 of Appendix A. A loop exit condition which is stable of index 0" &
              " takes the same value at every iteration around the loop, and with a" &
              " stability index of 1, it always takes the same value after the first" &
              " iteration. Stability with indices greater" &
              " than 0 does not necessarily indicate a program error, but the" &
              " conditions for loop termination require careful consideration");
      when ErrorHandler.Stable_Fork_Cond =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "The expression, occurring within a loop, is either a case expression" &
              " or a condition (Boolean-valued expression) associated with an" &
              " if-statement, whose value determines the path taken through the body" &
              " of the loop, but does not (directly) cause loop termination." &
              " Information flow analysis shows that the expression does not vary" &
              " as the loop is executed, so the same branch of the case or if statement will" &
              " be taken on every loop iteration. An Index of 0 means that the expression is" &
              " immediately stable, 1 means it becomes stable after the first pass through the loop and so on." &
              " The stability index is given with reference to the loop most" &
              " closely-containing the expression.  Stable conditionals are not necessarily" &
              " an error but do require careful evaluation; they can often be removed by lifting them" &
              " outside the loop.");
   end case;
end StabilityErrorExpl;
