-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;
with StringList;

--# inherit CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         E_Strings,
--#         LexTokenManager,
--#         SparkLex,
--#         SparkMakeDebug,
--#         SparkMakeErrors,
--#         SPARK_IO,
--#         SP_Symbols,
--#         StringList,
--#         TokenManager;

package Unit is

   type Kind is (
                 Package_Specification_Unit,
                 Public_Child_Package_Specification_Unit,
                 Private_Child_Package_Specification_Unit,
                 Main_Program_Unit,
                 Package_Body_Unit,
                 Separate_Body_Unit);

   subtype Specification_Unit is Kind range Package_Specification_Unit .. Private_Child_Package_Specification_Unit;

   subtype Child_Specification_Unit is Kind range
     Public_Child_Package_Specification_Unit .. Private_Child_Package_Specification_Unit;

   type Id is record
      The_Name : E_Strings.T;
      The_Kind : Kind;
   end record;

   Null_Id : constant Id := Id'(The_Name => E_Strings.Empty_String,
                                The_Kind => Kind'First);

   type Object is record
      The_Id              : Id;
      The_File            : E_Strings.T;
      The_Withed_Units    : StringList.Object;
      The_Inherited_Units : StringList.Object;
   end record;

   Null_Object : constant Object :=
     Object'
     (The_Id              => Null_Id,
      The_File            => E_Strings.Empty_String,
      The_Withed_Units    => StringList.Null_Object,
      The_Inherited_Units => StringList.Null_Object);

   -----------------------------------------------------------------------------

   function Kind_To_String (The_Unit : Kind) return E_Strings.T;

   -----------------------------------------------------------------------------

   function Are_Equal (L, R : Id) return Boolean;

   -----------------------------------------------------------------------------

   function Less_Than (L, R : Id) return Boolean;

   -----------------------------------------------------------------------------

   function Prefix (E_Str : E_Strings.T) return E_Strings.T;

   -----------------------------------------------------------------------------

   function Construct_Spec_Unit_Id (The_Name   : E_Strings.T;
                                    Is_Private : Boolean) return Id;

   -----------------------------------------------------------------------------

   procedure Get_Unit (In_File  : in     E_Strings.T;
                       The_Unit :    out Object);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#           out SparkLex.Curr_Line;
   --# derives ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         SparkLex.Curr_Line,
   --#         SPARK_IO.File_Sys,
   --#         The_Unit                   from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         In_File,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys;
   --
   -- Extracts the Unit information from the given file.

   -----------------------------------------------------------------------------

   procedure Output_Object (The_Unit : in Object);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                The_Unit;
   --
   -- For debug only

   procedure Output_Id (The_Unit : in Id);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                The_Unit;
   --
   -- For debug only

end Unit;
