
#include "optionsrequester.h"
#include "options.h"
#include "config.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qstringlist.h>

#include <klocale.h>
#include <kpushbutton.h>
#include <kiconloader.h>


OptionsRequester::OptionsRequester( Config* config, QStringList list, QWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    setCaption( i18n("Choose output options") );

    files = list;
    int row = 1;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    QGridLayout *grid = new QGridLayout( this, 2, 1, 11, 6 );

    options = new Options( config, i18n("Click on \"Ok\" to add the files to the list in the main window!"), this, "options" );
    grid->addWidget( options, 0, 0 );

    QStringList::Iterator it = files.begin();
    while( it != files.end() )
    {
        QString sFormat = *it;
        int i = sFormat.findRev( '.' );
        sFormat.remove( 0, i + 1 );
        sFormat.lower();

        if( sFormat == "wav" ) // FIXME use mime types
        {
            QHBoxLayout *warningBox = new QHBoxLayout();
            grid->addLayout( warningBox, 1, 0 );
            QLabel* lWarning = new QLabel( i18n("Warning: If you select \"wav\" as output format, your wav files will not be added to the list."), this, "lWarning" );
            warningBox->addWidget( lWarning );
            row++;
            break;
        }
        it++;
    }

    QHBoxLayout* buttonBox = new QHBoxLayout();
    grid->addLayout( buttonBox, row, 0 );

    buttonBox->addStretch();

    pCancel = new KPushButton( iconLoader->loadIcon("exit",KIcon::Small), i18n("Cancel"), this, "pCancel" );
    buttonBox->addWidget( pCancel );

    pOk = new KPushButton( iconLoader->loadIcon("apply",KIcon::Small), i18n("Ok"), this, "pOk" );
    buttonBox->addWidget( pOk );

    connect( pCancel, SIGNAL(clicked()),
               this, SLOT(reject())
             );
    connect( pOk, SIGNAL(clicked()),
               this, SLOT(okClicked())
             );

    // delete the icon loader object
    delete iconLoader;
}

OptionsRequester::~OptionsRequester()
{}

void OptionsRequester::okClicked()
{
    emit setCurrentOptions( options->getCurrentOptions() );
    emit addFiles( files );
    accept();
}

void OptionsRequester::setProfile( const QString& profile )
{
    options->setProfile( profile );
}

void OptionsRequester::setFormat( const QString& format )
{
    options->setFormat( format );
}

void OptionsRequester::setOutputDirectory( const QString& directory )
{
    options->setOutputDirectory( directory );
}


