<?php
/**
 * $Horde: passwd/lib/Driver/vpopmail.php,v 1.4.2.5 2005/02/01 21:45:31 ericr Exp $
 *
 * The vpopmail class attempts to change a user's password for vpopmail
 * based servers.  It is very similar to the more generic sql driver, and
 * the two should probably be merged into one driver if possible.
 *
 * @author   Anton Nekhoroshikh <anton@valuehost.ru>
 * @author   Mike Cochrane <mike@graftonhall.co.nz>
 * @author   Ilya Krel <mail@krel.org>
 * @author   Tjeerd van der Zee <admin@xar.nl>
 * @author   Mattias Webjrn Eriksson <mattias@webjorn.org>
 * @author   Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 * @package  passwd
 */

class Passwd_Driver_vpopmail extends Passwd_Driver {

    /** Pointer to the sql connection. */
    var $_db;

    /** Boolean which contains state of sql connection */
    var $_connected = false;

    /** Hash containing connection parameters. */
    var $_params = array();

    /**
     * Constructs a new sql Passwd_Driver object.
     *
     * @param array  $params    A hash containing connection parameters.
     */
    function Passwd_Driver_vpopmail($params = array())
    {
        global $conf;

        if (array_key_exists('phptype', $params)) {
            $this->_params['phptype'] = $params['phptype'];
        } else {
            return PEAR::raiseError(_("Required 'phptype' not specified in SQL configuration."));
        }

        /* Get sql defaults from Horde if available.  In future, use:
         * $defaults = Horde::getDriverConfig('', 'sql');
         */
 
        if (array_key_exists('sql', $conf)) {
           $defaults = array_merge($conf['sql'], $this->_params);
        } else {
           $defaults = array();
        }

        $this->_params['hostspec']   = array_key_exists('hostspec', $params)   ? $params['hostspec'] : $defaults['hostspec'];
        $this->_params['protocol']   = @array_key_exists('protocol', $params)   ? $params['protocol'] : $defaults['protocol'];
        $this->_params['username']   = @array_key_exists('username', $params)   ? $params['username'] : $defaults['username'];
        $this->_params['password']   = @array_key_exists('password', $params)   ? $params['password'] : $defaults['password'];
        $this->_params['database']   = @array_key_exists('database', $params)   ? $params['database'] : $defaults['database'];

        /* Defaults to match Auth::sql default */
        $this->_params['table']      = array_key_exists('table', $params)      ? $params['table'] : 'horde_users';
        $this->_params['encryption'] = array_key_exists('encryption', $params) ? $params['encryption'] : 'crypt';
        $this->_params['name']       = array_key_exists('name', $params)       ? $params['name'] : 'pw_name';
        $this->_params['domain']     = array_key_exists('domain', $params)     ? $params['domain'] : 'pw_domain';
        $this->_params['passwd']     = array_key_exists('passwd', $params)     ? $params['passwd'] : 'pw_passwd';
        $this->_params['clear_passwd'] = array_key_exists('clear_passwd', $params)     ? $params['clear_passwd'] : 'pw_clear_passwd';
        $this->_params['use_clear_passwd'] = array_key_exists('use_clear_passwd', $params)     ? $params['use_clear_passwd'] : false;
    }

    /**
     * Connect to the database
     *
     * @return   boolean   True on success or PEAR_Error on failure.
     *
     */
    function _connect()
    {
        if (!$this->_connected) {
            // Connect to the SQL server using the supplied parameters.
            include_once 'DB.php';
            $this->_db = &DB::connect($this->_params, true);
            if (DB::isError($this->_db)) {
                return PEAR::raiseError(_("Unable to connect to SQL server."));
            }

            // Enable the "portability" option.
            $this->_db->setOption('optimize', 'portability');
            $this->_connected = true;
        }

        return true;
    }

    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return boolean true on success, false on failure.
     */
    function _disconnect()
    {
        if ($this->_connected) {
            $this->_connected = false;
            return $this->_db->disconnect();
        }
       return true;

    }

    /**
     * Find out if a username and password is valid.
     *
     * @param string  $userID      The userID to check.
     * @param string  $oldPassword  An old password to check.
     *
     * @return boolean True on valid or PEAR_Error on invalid.
     */
    function _lookup($user, $oldPassword)
    {
        // Connect to the database
        $res = $this->_connect();
        if (PEAR::isError($res)) {
            return $res;
        }

        list($name,$domain)=explode("@",$user);

        // Build the SQL query.
        $query  = 'SELECT ' . $this->_params['passwd'] . ' FROM ' . $this->_params['table'];
        $query .= ' WHERE ' . $this->_params['name'] . ' = ' . $this->_db->quote($name);
        $query .= ' AND ' . $this->_params['domain'] . ' = ' . $this->_db->quote($domain);

        // Execute the query.
        $result = $this->_db->query($query);
        if (!DB::isError($result)) {
            $row = $result->fetchRow(DB_GETMODE_ASSOC);
            $result->free();
            if (is_array($row)) {
                // Get the password from the database
                $currentPassword = $row[$this->_params['passwd']];

                // Check the passwords match
                return $this->comparePasswords($currentPassword, $oldPassword);
            }
        }
        return new PEAR_Error(_("User not found"));
    }

    /**
     * Modify (update) a mysql password record for a user.
     *
     * @param   $user         The user whose record we will udpate.
     * @param   $newPassword  The new password value to set.
     *
     * @return  boolean    True or False based on success of the modify.
     */
    function _modify($user, $newPassword) {

        // Connect to the database
        $res = $this->_connect();
        if (PEAR::isError($res)) {
            return $res;
        }

        list($name,$domain)=explode("@",$user);

        // Encrypt the password
        $clearPassword = $newPassword;
        $newPassword = $this->encryptPassword($newPassword);

        // Build the SQL query.
        $query = 'UPDATE ' . $this->_params['table'];
        $query .= ' SET ' . $this->_params['passwd'] . ' = ' . $this->_db->quote($newPassword);
    if($this->_params['use_clear_passwd']) {
     $query.= ' , ' . $this->_params['clear_passwd'] . ' = ' . $this->_db->quote($clearPassword);
    }
        $query .= ' WHERE ' . $this->_params['name'] . ' = ' . $this->_db->quote($name);
        $query .= ' AND ' . $this->_params['domain'] . ' = ' . $this->_db->quote($domain);

        // Execute the query.
        $result = $this->_db->query($query);

        if (DB::isError($result)) {
            return $result;
        }

        return true;
    }

    /**
     * Change the user's password.
     *
     * @param   $username    The user for which to change the password.
     * @param   $oldpassword  The old (current) user password.
     * @param   $newpassword  The new user password to set.
     *
     * @return  boolean    True or false based on success of the change.
     */
    function change_password($username,  $oldpassword, $newpassword) {

        // Check the current password
        $res = $this->_lookup($username, $oldpassword);
        if (PEAR::isError($res))  {
            return $res;
        }

        $res = $this->_modify($username, $newpassword);

        $this->_disconnect();

        if (!PEAR::isError($res)) {
            $this->reset_credentials($username, $oldpassword, $newpassword);
        }

        return $res;
    }

}
