<?php
/**
 * $Horde: forwards/lib/Driver/sql.php,v 1.2.2.3 2003/01/20 05:17:57 ericr Exp $
 *
 * Copyright 2001-2003 Ilya Krel and Mike Cochrane
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 *
 * Forwards_Driver_sql:: implements the Forwards_Driver API for SQL servers.
 *
 * @author  Ilya Krel <mail@krel.org.org>
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.2.2.3 $
 * @since   Forwards 2.1
 * @package forwards
 */

class Forwards_Driver_sql extends Forwards_Driver {

	/** file pointer to the sql connection. */
	var $db;

	/** error string returned to user if an eror occurs. */
	var $err_str;

	/** boolean which contains state of sql connection */
	var $connected=false;

	var $params;

	/**
	 * Constructs a new sql Forwards_Driver object.
	 *
	 * @param array  $params	A hash containing connection parameters.
	 */
	function Forwards_Driver_sql($params = array())
	{

		$this->params = $params;

	}


	/**
	 * Do an sql connect and login as user with privilege to change passwd.
	 *
	 * @return   boolean   True or False based on success of connect
	 *
	 */

	function _connect()
	{

		if (!$this->connected) {
			if (!is_array($this->params)) {
				Horde::fatal(new PEAR_Error(
				_("No configuration information specified for SQL authentication.")),
				__FILE__, __LINE__);
			}
			if (!isset($this->params['phptype'])) {
				Horde::fatal(new PEAR_Error(
				_("Required 'phptype' not specified in authentication configuration.")),
				__FILE__, __LINE__);
			}
			if (!isset($this->params['hostspec'])) {
				Horde::fatal(new PEAR_Error(
				_("Required 'hostspec' not specified in authentication configuration.")),
				__FILE__, __LINE__);
			}
			if (!isset($this->params['username'])) {
				Horde::fatal(new PEAR_Error(
				_("Required 'username' not specified in authentication configuration.")),
				__FILE__, __LINE__);
			}
			if (!isset($this->params['password'])) {
				Horde::fatal(new PEAR_Error(
				_("Required 'password' not specified in authentication configuration.")),
				__FILE__, __LINE__);
			}
			if (!isset($this->params['database'])) {
				Horde::fatal(new PEAR_Error(
				_("Required 'database' not specified in authentication configuration.")),
				__FILE__, __LINE__);
			}
			if (!isset($this->params['table'])) {
				Horde::fatal(new PEAR_Error(
				_("Required 'table' not specified in authentication configuration.")),
				__FILE__, __LINE__);
			}

			/* Connect to the SQL server using the supplied parameters. */
			include_once 'DB.php';
			$this->db = &DB::connect($this->params, true);
			if (DB::isError($this->db)) {
				Horde::fatal(new PEAR_Error(_("Unable to connect to SQL server.")), __FILE__, __LINE__);
			}

			/* Enable the "portability" option. */
			$this->db->setOption('optimize', 'portability');
			$this->connected = true;
		}

		return true;
	}

  /**
	 * Disconnect from the SQL server and clean up the connection.
	 *
	 * @return boolean true on success, false on failure.
	 */
	function _disconnect()
	{

		if ($this->connected) {
			$this->connected = false;
			return $this->db->disconnect();
		}

		return true;

	}


	/**
	 * Begins forwarding of mail for a user.
	 *
	 * @param string	$user	   The username to enable forwarding for.
	 * @param string	$realm	  The realm of the user.
	 * @param string	$pass	   The password of the user.
	 *
	 * @param string	$target	 The email address that mail should be forwarded to.
	 *
	 * @param optional boolean $keeplocal A flag that if true causes a copy of
	 *									forwarded email to be kept in the
	 *									local mailbox.
	 *
	 * @return boolean  Returns true on success, false on error.
	 */
	function enableForwarding($user, $realm, $password, $target, $keeplocal)
	{

		// set forwarding flag
		/* _connect() will die with Horde::fatal() upon failure. */
		$this->_connect();
		$local_target=$user . '@' . $realm;

		/* Build the SQL query. */
		$query = 'UPDATE ' . $this->params['table'];
		$query .= ' set ' . $this->params['forward'] . ' = ' . $this->db->quote("y");
		$query .= ' WHERE ' . $this->params['user_col'] . ' = ' . $this->db->quote($user);
		$query .= ' and ' . $this->params['pass_col'] . ' = ' . $this->db->quote(md5($password));

		$query1 = 'UPDATE ' . $this->params['table'];
		if ($keeplocal === 'on') {
			if(!strstr($target,$local_target)) {
				$query1 .= ' set ' . $this->params['altemail'] . ' = ' . $this->db->quote($target . ',' .
				$local_target);
			}
		} else {
			$query1 .= ' set ' . $this->params['altemail'] . ' = ' . $this->db->quote($target);
		}
		$query1 .= ' WHERE ' . $this->params['user_col'] . ' = ' . $this->db->quote($user);
		$query1 .= ' and ' . $this->params['pass_col'] . ' = ' . $this->db->quote(md5($password));

		/* Execute the query. */
		$result = $this->db->query($query);
		$result1 = $this->db->query($query1);

		if (!DB::isError($result) && !DB::isError($result1)) {
			if ($result === DB_OK && $result1 === DB_OK) {
				$this->_disconnect();
				return true;
			} else {
				$this->_disconnect();
				return false;
			}
		} else {
			$this->_disconnect();
			return false;
		}
		$this->_disconnect();
		return false;

	}

	/**
	 * Stops forwarding of mail for a user.
	 *
	 * @param string	$user	   The username of the user.
	 * @param string	$realm	  The realm of the user.
	 * @param string	$pass	   The password of the user.
	 *
	 * @return boolean  Returns true on success, false on error.
	 */
	function disableForwarding($user, $realm, $password)
	{

		// set forwarding flag
		/* _connect() will die with Horde::fatal() upon failure. */
		$this->_connect();

		/* Build the SQL query. */
		$query = 'UPDATE ' . $this->params['table'];
		$query .= ' set ' . $this->params['forward'] . ' = ' . $this->db->quote("n");
		$query .= ' ,  ' . $this->params['altemail'] . ' = ' . $this->db->quote("");
		$query .= ' WHERE ' . $this->params['user_col'] . ' = ' . $this->db->quote($user);
		$query .= ' and ' . $this->params['pass_col'] . ' = ' . $this->db->quote(md5($password));

		/* Execute the query. */
		$result = $this->db->query($query);

		if (!DB::isError($result)) {
			if ($result === DB_OK) {
				$this->_disconnect();
				return true;
			} else {
				$this->_disconnect();
				return false;
			}
		} else {
				$this->_disconnect();
				return false;
		}
		$this->_disconnect();
		return false;

	}

	/**
	 * Retrieves status of mail redirection for a user
	 *
	 * @param string	$user	   The username of the user to check.
	 *
	 * @param string	$realm	  The realm of the user to check.
	 *
	 * @return boolean	Returns true if forwarding is enabled for the user or false if
	 *				  forwarding is currently disabled.
	 */
	function isEnabledForwarding($user, $realm, $password)
	{

		// get current details
		$current_details = $this->_getUserDetails($user, $realm, $password);
		if ($current_details === false) {
		   //$this->err_str = _("Not able to retrieve current details.");
		   return false;
		}

		// check forwarding flag
		if ( $current_details[$this->params['forward']] === 'y' ||
			$current_details[$this->params['forward']] === 'Y') {
			 return true;
		 } else { return false; }

	}

	/**
	 * Returns true if a local copy of forwarded messages is being kept
	 *
	 * @param string	$user	   The username of the user to check.
	 *
	 * @param string	$realm	  The realm of the user to check.
	 *
	 * @return boolean	Returns true if retain local copy is enabled else false.
	 *
	 */
	function isKeepLocal($user, $realm, $password)
	{

		// get current details
		$current_details = $this->_getUserDetails($user, $realm, $password);
		if ($current_details === false) {
		   //$this->err_str = _("Not able to retrieve current details.");
		   return false;
		}

		// check retain copy flag
		if ( substr_count($current_details[$this->params['altemail']], $user . '@' . $realm)) {
			 return true;
		 } else {
			 return false;
		 }

	}

	/**
	 * Retrieves current target of mail redirection
	 *
	 * @param string	$user	   The username of the user.
	 * @param string	$realm	  The realm of the user.
	 *
	 * @return string   A string of current forwarding mail address or false.
	 */
	function currentTarget($user, $realm, $password)
	{

		$searchString = ",$user@$realm";
		$current_details = $this->_getUserDetails($user, $realm, $password);

		// check current forwarding mail address
		$targets = $current_details[$this->params['altemail']];
		return str_replace($searchString,"",$current_details[$this->params['altemail']]);

	}

	/**
	 * Retreive relevant line from sql server
	 *
	 * @param   $user		 The username for which to retrieve detals..
	 * @param   $realm		The realm (domain) for the user.
	 * @param   $password	 The password for user.
	 *
	 * @return  Mixed		 Mysql result resource or (boolean) False
	 */
	function _getUserDetails($user, $realm, $password)
	{

		/* _connect() will die with Horde::fatal() upon failure. */
		$this->_connect();

		/* Build the SQL query. */
		$query = 'SELECT * FROM ' . $this->params['table'];
		$query .= ' WHERE ' . $this->params['user_col'] . ' = ' . $this->db->quote($user);
		$query .= ' AND password = ' . $this->db->quote(md5($password));

		/* Execute the query. */
		$result = $this->db->query($query);

		if (!DB::isError($result)) {
			$row = $result->fetchRow(DB_FETCHMODE_ASSOC);

		if (is_array($row)) {
				$this->_disconnect();
				return $row;
			} else {
				$this->_disconnect();
				$result->free();
				return false;
			}
		}
			$this->_disconnect();
			return false;

	}

}
