<?php

require_once dirname(__FILE__) . '/forwards.php';

/**
 * Forwards_Driver_qmail:: implements the Forwards_Driver API for FTP driven
 * Qmail mail servers.
 *
 * $Horde: forwards/lib/Driver/qmail.php,v 1.17.2.4 2009/01/06 15:22:46 jan Exp $
 *
 * Copyright 2001-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSDL). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @author  Jan Schneider <jan@horde.org>
 * @since   Forwards 2.2
 * @package Forwards
 */
class Forwards_Driver_qmail extends Forwards_Driver_forwards {

    /**
     * The name of the forwards file.
     *
     * @var string
     */
    var $_forwardsFile = '.qmail';

    /**
     * Checks if user is keeping a local copy of forwarded mail.
     *
     * @todo Implement this method.
     *
     * @param string $password  The password of the user.
     *
     * @return boolean  True if user is keeping a local copy of mail,
     *                  otherwise false.
     */
    function isKeepLocal($password)
    {
        return false;
    }

    /**
     * Creates the main forwards file.
     *
     * @param string $target      The email address that mail should be
     *                            forwarded to.
     * @param boolean $keeplocal  Keep a copy of forwarded mail in the local
     *                            mailbox.
     */
    function _createForwardsFile($target, $keeplocal = false)
    {
        // Create the forwarding information.
        $address = '&' . $target;
        if ($keeplocal == 'on') {
            $address .= "\n./Maildir/";
        }

        // Set the forward.
        $status = $this->_vfs->writeData('', '.qmail', $address);
        if (is_a($status, 'PEAR_Error')) {
            return $status;
        }

        // Try to change the permissions, but ignore any errors.
        $this->_vfs->changePermissions('', '.qmail', '0600');
    }

    /**
     * Parses the target information out of the forwards file content.
     *
     * @param string $content  The file content.
     *
     * @return string  The forwards target.
     */
    function _parseForwardsFile($content)
    {
        return preg_replace('/&(.*)(\n.*)?/', '$1', $content);
    }

}
