/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef SONICMAIL_VARS_H_INCLUDED
#define SONICMAIL_VARS_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include <applet-widget.h>
#include <libgnome/gnome-config.h>

typedef struct SonicmailVars_ SonicmailVars;
typedef struct SonicmailPixmaps_ SonicmailPixmaps;
typedef struct SonicmailProperties_ SonicmailProperties;

enum SonicmailState {Sonicmail_Offline, Sonicmail_Empty, Sonicmail_Full};

struct SonicmailProperties_
{   
   GtkWidget *property_box;
   GtkWidget *server_table, *images_table, *audio_table;

   GtkWidget *server_entry, *user_entry, *passwd_entry, *min_spin, *sec_spin;
   GtkObject *min_adj, *sec_adj;
   GtkWidget *freq_box;

   GtkWidget *pmempty_entry, *pmfull_entry, *pmoffline_entry, *transp_color_picker;

   GtkWidget *audio_check, *audio_repeat_check, *wavfile_entry;
}; 

struct SonicmailPixmaps_
{
   GtkWidget *display_pixmap;
   GdkPixmap *offline_pixmap;
   GdkPixmap *empty_pixmap;
   GdkPixmap *full_pixmap;
};

struct SonicmailVars_
{  
   GtkWidget *applet;
   GtkWidget *box;
   GtkTooltips *tooltips;
   
   enum SonicmailState state;
   
   int prev_num_mails;
   int curr_num_mails;
   
   pthread_mutex_t mut;
   pid_t mailcheck_thread_pid;
   
   SonicmailPixmaps pixmaps;
   SonicmailProperties properties;
   
   gchar *servername;
   gchar *username;
   gchar *pword;
   gint mins, secs;
   
   gchar *empty_pm_filename;
   gchar *full_pm_filename;
   gchar *offline_pm_filename;
   GdkColor transp_col;
   
   gboolean audio_on;
   gboolean audio_repeat_on;
   gchar *wavfile_filename;
   
};

void sonicmail_vars_init(SonicmailVars **vars);





#endif
