/* 
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SIP_HCLASSES_H
/** Defined when <sofia-sip/sip_hclasses.h> has been included. */
#define SIP_HCLASSES_H

/**@file sofia-sip/sip_hclasses.h
 * @brief Declarations of SIP header classes.
 * 
 * This file is automatically generated from <sip.h> by msg_parser.awk.
 * 
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 *
 * @date Created: Thu Jan 23 19:26:31 2003 ppessi
 */

#ifndef MSG_TYPES_H
#include <sofia-sip/msg_types.h>
#endif

SOFIA_BEGIN_DECLS


enum { 
  /**@ingroup sip_request @internal 
   *
   * Hash of @ref sip_request "request line".
   *
   */
  sip_request_hash = -1 
};

/**Header class for @ref sip_request "request line".
 * 
 * The header class sip_request_class defines how a SIP
 * @ref sip_request "request line" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_request_t header structure.
 *
 * @ingroup sip_request
 *
 */
SIP_DLL extern msg_hclass_t sip_request_class[];



enum { 
  /**@ingroup sip_status @internal 
   *
   * Hash of @ref sip_status "status line".
   *
   */
  sip_status_hash = -2 
};

/**Header class for @ref sip_status "status line".
 * 
 * The header class sip_status_class defines how a SIP
 * @ref sip_status "status line" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_status_t header structure.
 *
 * @ingroup sip_status
 *
 */
SIP_DLL extern msg_hclass_t sip_status_class[];



enum { 
  /**@ingroup sip_via @internal 
   *
   * Hash of @ref sip_via "Via header".
   *
   */
  sip_via_hash = 46244 
};

/**Header class for @ref sip_via "Via header".
 * 
 * The header class sip_via_class defines how a SIP
 * @ref sip_via "Via header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_via_t header structure.
 *
 * @ingroup sip_via
 *
 */
SIP_DLL extern msg_hclass_t sip_via_class[];



enum { 
  /**@ingroup sip_route @internal 
   *
   * Hash of @ref sip_route "Route header".
   *
   */
  sip_route_hash = 28359 
};

/**Header class for @ref sip_route "Route header".
 * 
 * The header class sip_route_class defines how a SIP
 * @ref sip_route "Route header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_route_t header structure.
 *
 * @ingroup sip_route
 *
 */
SIP_DLL extern msg_hclass_t sip_route_class[];



enum { 
  /**@ingroup sip_record_route @internal 
   *
   * Hash of @ref sip_record_route "Record-Route header".
   *
   */
  sip_record_route_hash = 33211 
};

/**Header class for @ref sip_record_route "Record-Route header".
 * 
 * The header class sip_record_route_class defines how a SIP
 * @ref sip_record_route "Record-Route header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_record_route_t header structure.
 *
 * @ingroup sip_record_route
 *
 */
SIP_DLL extern msg_hclass_t sip_record_route_class[];



enum { 
  /**@ingroup sip_max_forwards @internal 
   *
   * Hash of @ref sip_max_forwards "Max-Forwards header".
   *
   */
  sip_max_forwards_hash = 27231 
};

/**Header class for @ref sip_max_forwards "Max-Forwards header".
 * 
 * The header class sip_max_forwards_class defines how a SIP
 * @ref sip_max_forwards "Max-Forwards header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_max_forwards_t header structure.
 *
 * @ingroup sip_max_forwards
 *
 */
SIP_DLL extern msg_hclass_t sip_max_forwards_class[];



enum { 
  /**@ingroup sip_proxy_require @internal 
   *
   * Hash of @ref sip_proxy_require "Proxy-Require header".
   *
   */
  sip_proxy_require_hash = 11704 
};

/**Header class for @ref sip_proxy_require "Proxy-Require header".
 * 
 * The header class sip_proxy_require_class defines how a SIP
 * @ref sip_proxy_require "Proxy-Require header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_proxy_require_t header structure.
 *
 * @ingroup sip_proxy_require
 *
 */
SIP_DLL extern msg_hclass_t sip_proxy_require_class[];



enum { 
  /**@ingroup sip_from @internal 
   *
   * Hash of @ref sip_from "From header".
   *
   */
  sip_from_hash = 15368 
};

/**Header class for @ref sip_from "From header".
 * 
 * The header class sip_from_class defines how a SIP
 * @ref sip_from "From header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_from_t header structure.
 *
 * @ingroup sip_from
 *
 */
SIP_DLL extern msg_hclass_t sip_from_class[];



enum { 
  /**@ingroup sip_to @internal 
   *
   * Hash of @ref sip_to "To header".
   *
   */
  sip_to_hash = 62495 
};

/**Header class for @ref sip_to "To header".
 * 
 * The header class sip_to_class defines how a SIP
 * @ref sip_to "To header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_to_t header structure.
 *
 * @ingroup sip_to
 *
 */
SIP_DLL extern msg_hclass_t sip_to_class[];



enum { 
  /**@ingroup sip_call_id @internal 
   *
   * Hash of @ref sip_call_id "Call-ID header".
   *
   */
  sip_call_id_hash = 38022 
};

/**Header class for @ref sip_call_id "Call-ID header".
 * 
 * The header class sip_call_id_class defines how a SIP
 * @ref sip_call_id "Call-ID header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_call_id_t header structure.
 *
 * @ingroup sip_call_id
 *
 */
SIP_DLL extern msg_hclass_t sip_call_id_class[];



enum { 
  /**@ingroup sip_cseq @internal 
   *
   * Hash of @ref sip_cseq "CSeq header".
   *
   */
  sip_cseq_hash = 12268 
};

/**Header class for @ref sip_cseq "CSeq header".
 * 
 * The header class sip_cseq_class defines how a SIP
 * @ref sip_cseq "CSeq header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_cseq_t header structure.
 *
 * @ingroup sip_cseq
 *
 */
SIP_DLL extern msg_hclass_t sip_cseq_class[];



enum { 
  /**@ingroup sip_contact @internal 
   *
   * Hash of @ref sip_contact "Contact header".
   *
   */
  sip_contact_hash = 25428 
};

/**Header class for @ref sip_contact "Contact header".
 * 
 * The header class sip_contact_class defines how a SIP
 * @ref sip_contact "Contact header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_contact_t header structure.
 *
 * @ingroup sip_contact
 *
 */
SIP_DLL extern msg_hclass_t sip_contact_class[];



enum { 
  /**@ingroup sip_rseq @internal 
   *
   * Hash of @ref sip_rseq "RSeq header".
   *
   */
  sip_rseq_hash = 16651 
};

/**Header class for @ref sip_rseq "RSeq header".
 * 
 * The header class sip_rseq_class defines how a SIP
 * @ref sip_rseq "RSeq header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_rseq_t header structure.
 *
 * @ingroup sip_rseq
 *
 */
SIP_DLL extern msg_hclass_t sip_rseq_class[];



enum { 
  /**@ingroup sip_rack @internal 
   *
   * Hash of @ref sip_rack "RAck header".
   *
   */
  sip_rack_hash = 46065 
};

/**Header class for @ref sip_rack "RAck header".
 * 
 * The header class sip_rack_class defines how a SIP
 * @ref sip_rack "RAck header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_rack_t header structure.
 *
 * @ingroup sip_rack
 *
 */
SIP_DLL extern msg_hclass_t sip_rack_class[];



enum { 
  /**@ingroup sip_request_disposition @internal 
   *
   * Hash of @ref sip_request_disposition "Request-Disposition header".
   *
   */
  sip_request_disposition_hash = 61507 
};

/**Header class for @ref sip_request_disposition "Request-Disposition header".
 * 
 * The header class sip_request_disposition_class defines how a SIP
 * @ref sip_request_disposition "Request-Disposition header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_request_disposition_t header structure.
 *
 * @ingroup sip_request_disposition
 *
 */
SIP_DLL extern msg_hclass_t sip_request_disposition_class[];



enum { 
  /**@ingroup sip_accept_contact @internal 
   *
   * Hash of @ref sip_accept_contact "Accept-Contact header".
   *
   */
  sip_accept_contact_hash = 30081 
};

/**Header class for @ref sip_accept_contact "Accept-Contact header".
 * 
 * The header class sip_accept_contact_class defines how a SIP
 * @ref sip_accept_contact "Accept-Contact header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_accept_contact_t header structure.
 *
 * @ingroup sip_accept_contact
 *
 */
SIP_DLL extern msg_hclass_t sip_accept_contact_class[];



enum { 
  /**@ingroup sip_reject_contact @internal 
   *
   * Hash of @ref sip_reject_contact "Reject-Contact header".
   *
   */
  sip_reject_contact_hash = 34934 
};

/**Header class for @ref sip_reject_contact "Reject-Contact header".
 * 
 * The header class sip_reject_contact_class defines how a SIP
 * @ref sip_reject_contact "Reject-Contact header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_reject_contact_t header structure.
 *
 * @ingroup sip_reject_contact
 *
 */
SIP_DLL extern msg_hclass_t sip_reject_contact_class[];



enum { 
  /**@ingroup sip_expires @internal 
   *
   * Hash of @ref sip_expires "Expires header".
   *
   */
  sip_expires_hash = 28680 
};

/**Header class for @ref sip_expires "Expires header".
 * 
 * The header class sip_expires_class defines how a SIP
 * @ref sip_expires "Expires header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_expires_t header structure.
 *
 * @ingroup sip_expires
 *
 */
SIP_DLL extern msg_hclass_t sip_expires_class[];



enum { 
  /**@ingroup sip_date @internal 
   *
   * Hash of @ref sip_date "Date header".
   *
   */
  sip_date_hash = 43982 
};

/**Header class for @ref sip_date "Date header".
 * 
 * The header class sip_date_class defines how a SIP
 * @ref sip_date "Date header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_date_t header structure.
 *
 * @ingroup sip_date
 *
 */
SIP_DLL extern msg_hclass_t sip_date_class[];



enum { 
  /**@ingroup sip_retry_after @internal 
   *
   * Hash of @ref sip_retry_after "Retry-After header".
   *
   */
  sip_retry_after_hash = 30349 
};

/**Header class for @ref sip_retry_after "Retry-After header".
 * 
 * The header class sip_retry_after_class defines how a SIP
 * @ref sip_retry_after "Retry-After header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_retry_after_t header structure.
 *
 * @ingroup sip_retry_after
 *
 */
SIP_DLL extern msg_hclass_t sip_retry_after_class[];



enum { 
  /**@ingroup sip_timestamp @internal 
   *
   * Hash of @ref sip_timestamp "Timestamp header".
   *
   */
  sip_timestamp_hash = 12632 
};

/**Header class for @ref sip_timestamp "Timestamp header".
 * 
 * The header class sip_timestamp_class defines how a SIP
 * @ref sip_timestamp "Timestamp header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_timestamp_t header structure.
 *
 * @ingroup sip_timestamp
 *
 */
SIP_DLL extern msg_hclass_t sip_timestamp_class[];



enum { 
  /**@ingroup sip_min_expires @internal 
   *
   * Hash of @ref sip_min_expires "Min-Expires header".
   *
   */
  sip_min_expires_hash = 21461 
};

/**Header class for @ref sip_min_expires "Min-Expires header".
 * 
 * The header class sip_min_expires_class defines how a SIP
 * @ref sip_min_expires "Min-Expires header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_min_expires_t header structure.
 *
 * @ingroup sip_min_expires
 *
 */
SIP_DLL extern msg_hclass_t sip_min_expires_class[];



enum { 
  /**@ingroup sip_subject @internal 
   *
   * Hash of @ref sip_subject "Subject header".
   *
   */
  sip_subject_hash = 16360 
};

/**Header class for @ref sip_subject "Subject header".
 * 
 * The header class sip_subject_class defines how a SIP
 * @ref sip_subject "Subject header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_subject_t header structure.
 *
 * @ingroup sip_subject
 *
 */
SIP_DLL extern msg_hclass_t sip_subject_class[];



enum { 
  /**@ingroup sip_priority @internal 
   *
   * Hash of @ref sip_priority "Priority header".
   *
   */
  sip_priority_hash = 8846 
};

/**Header class for @ref sip_priority "Priority header".
 * 
 * The header class sip_priority_class defines how a SIP
 * @ref sip_priority "Priority header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_priority_t header structure.
 *
 * @ingroup sip_priority
 *
 */
SIP_DLL extern msg_hclass_t sip_priority_class[];



enum { 
  /**@ingroup sip_call_info @internal 
   *
   * Hash of @ref sip_call_info "Call-Info header".
   *
   */
  sip_call_info_hash = 57337 
};

/**Header class for @ref sip_call_info "Call-Info header".
 * 
 * The header class sip_call_info_class defines how a SIP
 * @ref sip_call_info "Call-Info header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_call_info_t header structure.
 *
 * @ingroup sip_call_info
 *
 */
SIP_DLL extern msg_hclass_t sip_call_info_class[];



enum { 
  /**@ingroup sip_organization @internal 
   *
   * Hash of @ref sip_organization "Organization header".
   *
   */
  sip_organization_hash = 6389 
};

/**Header class for @ref sip_organization "Organization header".
 * 
 * The header class sip_organization_class defines how a SIP
 * @ref sip_organization "Organization header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_organization_t header structure.
 *
 * @ingroup sip_organization
 *
 */
SIP_DLL extern msg_hclass_t sip_organization_class[];



enum { 
  /**@ingroup sip_server @internal 
   *
   * Hash of @ref sip_server "Server header".
   *
   */
  sip_server_hash = 31323 
};

/**Header class for @ref sip_server "Server header".
 * 
 * The header class sip_server_class defines how a SIP
 * @ref sip_server "Server header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_server_t header structure.
 *
 * @ingroup sip_server
 *
 */
SIP_DLL extern msg_hclass_t sip_server_class[];



enum { 
  /**@ingroup sip_user_agent @internal 
   *
   * Hash of @ref sip_user_agent "User-Agent header".
   *
   */
  sip_user_agent_hash = 40911 
};

/**Header class for @ref sip_user_agent "User-Agent header".
 * 
 * The header class sip_user_agent_class defines how a SIP
 * @ref sip_user_agent "User-Agent header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_user_agent_t header structure.
 *
 * @ingroup sip_user_agent
 *
 */
SIP_DLL extern msg_hclass_t sip_user_agent_class[];



enum { 
  /**@ingroup sip_in_reply_to @internal 
   *
   * Hash of @ref sip_in_reply_to "In-Reply-To header".
   *
   */
  sip_in_reply_to_hash = 19812 
};

/**Header class for @ref sip_in_reply_to "In-Reply-To header".
 * 
 * The header class sip_in_reply_to_class defines how a SIP
 * @ref sip_in_reply_to "In-Reply-To header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_in_reply_to_t header structure.
 *
 * @ingroup sip_in_reply_to
 *
 */
SIP_DLL extern msg_hclass_t sip_in_reply_to_class[];



enum { 
  /**@ingroup sip_accept @internal 
   *
   * Hash of @ref sip_accept "Accept header".
   *
   */
  sip_accept_hash = 29344 
};

/**Header class for @ref sip_accept "Accept header".
 * 
 * The header class sip_accept_class defines how a SIP
 * @ref sip_accept "Accept header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_accept_t header structure.
 *
 * @ingroup sip_accept
 *
 */
SIP_DLL extern msg_hclass_t sip_accept_class[];



enum { 
  /**@ingroup sip_accept_encoding @internal 
   *
   * Hash of @ref sip_accept_encoding "Accept-Encoding header".
   *
   */
  sip_accept_encoding_hash = 35932 
};

/**Header class for @ref sip_accept_encoding "Accept-Encoding header".
 * 
 * The header class sip_accept_encoding_class defines how a SIP
 * @ref sip_accept_encoding "Accept-Encoding header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_accept_encoding_t header structure.
 *
 * @ingroup sip_accept_encoding
 *
 */
SIP_DLL extern msg_hclass_t sip_accept_encoding_class[];



enum { 
  /**@ingroup sip_accept_language @internal 
   *
   * Hash of @ref sip_accept_language "Accept-Language header".
   *
   */
  sip_accept_language_hash = 23797 
};

/**Header class for @ref sip_accept_language "Accept-Language header".
 * 
 * The header class sip_accept_language_class defines how a SIP
 * @ref sip_accept_language "Accept-Language header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_accept_language_t header structure.
 *
 * @ingroup sip_accept_language
 *
 */
SIP_DLL extern msg_hclass_t sip_accept_language_class[];



enum { 
  /**@ingroup sip_allow @internal 
   *
   * Hash of @ref sip_allow "Allow header".
   *
   */
  sip_allow_hash = 44519 
};

/**Header class for @ref sip_allow "Allow header".
 * 
 * The header class sip_allow_class defines how a SIP
 * @ref sip_allow "Allow header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_allow_t header structure.
 *
 * @ingroup sip_allow
 *
 */
SIP_DLL extern msg_hclass_t sip_allow_class[];



enum { 
  /**@ingroup sip_require @internal 
   *
   * Hash of @ref sip_require "Require header".
   *
   */
  sip_require_hash = 32097 
};

/**Header class for @ref sip_require "Require header".
 * 
 * The header class sip_require_class defines how a SIP
 * @ref sip_require "Require header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_require_t header structure.
 *
 * @ingroup sip_require
 *
 */
SIP_DLL extern msg_hclass_t sip_require_class[];



enum { 
  /**@ingroup sip_supported @internal 
   *
   * Hash of @ref sip_supported "Supported header".
   *
   */
  sip_supported_hash = 28310 
};

/**Header class for @ref sip_supported "Supported header".
 * 
 * The header class sip_supported_class defines how a SIP
 * @ref sip_supported "Supported header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_supported_t header structure.
 *
 * @ingroup sip_supported
 *
 */
SIP_DLL extern msg_hclass_t sip_supported_class[];



enum { 
  /**@ingroup sip_unsupported @internal 
   *
   * Hash of @ref sip_unsupported "Unsupported header".
   *
   */
  sip_unsupported_hash = 37557 
};

/**Header class for @ref sip_unsupported "Unsupported header".
 * 
 * The header class sip_unsupported_class defines how a SIP
 * @ref sip_unsupported "Unsupported header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_unsupported_t header structure.
 *
 * @ingroup sip_unsupported
 *
 */
SIP_DLL extern msg_hclass_t sip_unsupported_class[];



enum { 
  /**@ingroup sip_event @internal 
   *
   * Hash of @ref sip_event "Event header".
   *
   */
  sip_event_hash = 8274 
};

/**Header class for @ref sip_event "Event header".
 * 
 * The header class sip_event_class defines how a SIP
 * @ref sip_event "Event header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_event_t header structure.
 *
 * @ingroup sip_event
 *
 */
SIP_DLL extern msg_hclass_t sip_event_class[];



enum { 
  /**@ingroup sip_allow_events @internal 
   *
   * Hash of @ref sip_allow_events "Allow-Events header".
   *
   */
  sip_allow_events_hash = 31165 
};

/**Header class for @ref sip_allow_events "Allow-Events header".
 * 
 * The header class sip_allow_events_class defines how a SIP
 * @ref sip_allow_events "Allow-Events header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_allow_events_t header structure.
 *
 * @ingroup sip_allow_events
 *
 */
SIP_DLL extern msg_hclass_t sip_allow_events_class[];



enum { 
  /**@ingroup sip_subscription_state @internal 
   *
   * Hash of @ref sip_subscription_state "Subscription-State header".
   *
   */
  sip_subscription_state_hash = 30595 
};

/**Header class for @ref sip_subscription_state "Subscription-State header".
 * 
 * The header class sip_subscription_state_class defines how a SIP
 * @ref sip_subscription_state "Subscription-State header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_subscription_state_t header structure.
 *
 * @ingroup sip_subscription_state
 *
 */
SIP_DLL extern msg_hclass_t sip_subscription_state_class[];



enum { 
  /**@ingroup sip_proxy_authenticate @internal 
   *
   * Hash of @ref sip_proxy_authenticate "Proxy-Authenticate header".
   *
   */
  sip_proxy_authenticate_hash = 57658 
};

/**Header class for @ref sip_proxy_authenticate "Proxy-Authenticate header".
 * 
 * The header class sip_proxy_authenticate_class defines how a SIP
 * @ref sip_proxy_authenticate "Proxy-Authenticate header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_proxy_authenticate_t header structure.
 *
 * @ingroup sip_proxy_authenticate
 *
 */
SIP_DLL extern msg_hclass_t sip_proxy_authenticate_class[];



enum { 
  /**@ingroup sip_proxy_authentication_info @internal 
   *
   * Hash of @ref sip_proxy_authentication_info "Proxy-Authentication-Info header".
   *
   */
  sip_proxy_authentication_info_hash = 52344 
};

/**Header class for @ref sip_proxy_authentication_info "Proxy-Authentication-Info header".
 * 
 * The header class sip_proxy_authentication_info_class defines how a SIP
 * @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_proxy_authentication_info_t header structure.
 *
 * @ingroup sip_proxy_authentication_info
 *
 */
SIP_DLL extern msg_hclass_t sip_proxy_authentication_info_class[];



enum { 
  /**@ingroup sip_proxy_authorization @internal 
   *
   * Hash of @ref sip_proxy_authorization "Proxy-Authorization header".
   *
   */
  sip_proxy_authorization_hash = 21244 
};

/**Header class for @ref sip_proxy_authorization "Proxy-Authorization header".
 * 
 * The header class sip_proxy_authorization_class defines how a SIP
 * @ref sip_proxy_authorization "Proxy-Authorization header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_proxy_authorization_t header structure.
 *
 * @ingroup sip_proxy_authorization
 *
 */
SIP_DLL extern msg_hclass_t sip_proxy_authorization_class[];



enum { 
  /**@ingroup sip_authorization @internal 
   *
   * Hash of @ref sip_authorization "Authorization header".
   *
   */
  sip_authorization_hash = 36397 
};

/**Header class for @ref sip_authorization "Authorization header".
 * 
 * The header class sip_authorization_class defines how a SIP
 * @ref sip_authorization "Authorization header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_authorization_t header structure.
 *
 * @ingroup sip_authorization
 *
 */
SIP_DLL extern msg_hclass_t sip_authorization_class[];



enum { 
  /**@ingroup sip_www_authenticate @internal 
   *
   * Hash of @ref sip_www_authenticate "WWW-Authenticate header".
   *
   */
  sip_www_authenticate_hash = 16217 
};

/**Header class for @ref sip_www_authenticate "WWW-Authenticate header".
 * 
 * The header class sip_www_authenticate_class defines how a SIP
 * @ref sip_www_authenticate "WWW-Authenticate header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_www_authenticate_t header structure.
 *
 * @ingroup sip_www_authenticate
 *
 */
SIP_DLL extern msg_hclass_t sip_www_authenticate_class[];



enum { 
  /**@ingroup sip_authentication_info @internal 
   *
   * Hash of @ref sip_authentication_info "Authentication-Info header".
   *
   */
  sip_authentication_info_hash = 20849 
};

/**Header class for @ref sip_authentication_info "Authentication-Info header".
 * 
 * The header class sip_authentication_info_class defines how a SIP
 * @ref sip_authentication_info "Authentication-Info header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_authentication_info_t header structure.
 *
 * @ingroup sip_authentication_info
 *
 */
SIP_DLL extern msg_hclass_t sip_authentication_info_class[];



enum { 
  /**@ingroup sip_error_info @internal 
   *
   * Hash of @ref sip_error_info "Error-Info header".
   *
   */
  sip_error_info_hash = 5263 
};

/**Header class for @ref sip_error_info "Error-Info header".
 * 
 * The header class sip_error_info_class defines how a SIP
 * @ref sip_error_info "Error-Info header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_error_info_t header structure.
 *
 * @ingroup sip_error_info
 *
 */
SIP_DLL extern msg_hclass_t sip_error_info_class[];



enum { 
  /**@ingroup sip_warning @internal 
   *
   * Hash of @ref sip_warning "Warning header".
   *
   */
  sip_warning_hash = 4130 
};

/**Header class for @ref sip_warning "Warning header".
 * 
 * The header class sip_warning_class defines how a SIP
 * @ref sip_warning "Warning header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_warning_t header structure.
 *
 * @ingroup sip_warning
 *
 */
SIP_DLL extern msg_hclass_t sip_warning_class[];



enum { 
  /**@ingroup sip_refer_to @internal 
   *
   * Hash of @ref sip_refer_to "Refer-To header".
   *
   */
  sip_refer_to_hash = 52604 
};

/**Header class for @ref sip_refer_to "Refer-To header".
 * 
 * The header class sip_refer_to_class defines how a SIP
 * @ref sip_refer_to "Refer-To header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_refer_to_t header structure.
 *
 * @ingroup sip_refer_to
 *
 */
SIP_DLL extern msg_hclass_t sip_refer_to_class[];



enum { 
  /**@ingroup sip_referred_by @internal 
   *
   * Hash of @ref sip_referred_by "Referred-By header".
   *
   */
  sip_referred_by_hash = 11403 
};

/**Header class for @ref sip_referred_by "Referred-By header".
 * 
 * The header class sip_referred_by_class defines how a SIP
 * @ref sip_referred_by "Referred-By header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_referred_by_t header structure.
 *
 * @ingroup sip_referred_by
 *
 */
SIP_DLL extern msg_hclass_t sip_referred_by_class[];



enum { 
  /**@ingroup sip_replaces @internal 
   *
   * Hash of @ref sip_replaces "Replaces header".
   *
   */
  sip_replaces_hash = 58083 
};

/**Header class for @ref sip_replaces "Replaces header".
 * 
 * The header class sip_replaces_class defines how a SIP
 * @ref sip_replaces "Replaces header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_replaces_t header structure.
 *
 * @ingroup sip_replaces
 *
 */
SIP_DLL extern msg_hclass_t sip_replaces_class[];



enum { 
  /**@ingroup sip_session_expires @internal 
   *
   * Hash of @ref sip_session_expires "Session-Expires header".
   *
   */
  sip_session_expires_hash = 61197 
};

/**Header class for @ref sip_session_expires "Session-Expires header".
 * 
 * The header class sip_session_expires_class defines how a SIP
 * @ref sip_session_expires "Session-Expires header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_session_expires_t header structure.
 *
 * @ingroup sip_session_expires
 *
 */
SIP_DLL extern msg_hclass_t sip_session_expires_class[];



enum { 
  /**@ingroup sip_min_se @internal 
   *
   * Hash of @ref sip_min_se "Min-SE header".
   *
   */
  sip_min_se_hash = 11565 
};

/**Header class for @ref sip_min_se "Min-SE header".
 * 
 * The header class sip_min_se_class defines how a SIP
 * @ref sip_min_se "Min-SE header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_min_se_t header structure.
 *
 * @ingroup sip_min_se
 *
 */
SIP_DLL extern msg_hclass_t sip_min_se_class[];



enum { 
  /**@ingroup sip_path @internal 
   *
   * Hash of @ref sip_path "Path header".
   *
   */
  sip_path_hash = 5705 
};

/**Header class for @ref sip_path "Path header".
 * 
 * The header class sip_path_class defines how a SIP
 * @ref sip_path "Path header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_path_t header structure.
 *
 * @ingroup sip_path
 *
 */
SIP_DLL extern msg_hclass_t sip_path_class[];



enum { 
  /**@ingroup sip_service_route @internal 
   *
   * Hash of @ref sip_service_route "Service-Route header".
   *
   */
  sip_service_route_hash = 21825 
};

/**Header class for @ref sip_service_route "Service-Route header".
 * 
 * The header class sip_service_route_class defines how a SIP
 * @ref sip_service_route "Service-Route header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_service_route_t header structure.
 *
 * @ingroup sip_service_route
 *
 */
SIP_DLL extern msg_hclass_t sip_service_route_class[];



enum { 
  /**@ingroup sip_reason @internal 
   *
   * Hash of @ref sip_reason "Reason header".
   *
   */
  sip_reason_hash = 13856 
};

/**Header class for @ref sip_reason "Reason header".
 * 
 * The header class sip_reason_class defines how a SIP
 * @ref sip_reason "Reason header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_reason_t header structure.
 *
 * @ingroup sip_reason
 *
 */
SIP_DLL extern msg_hclass_t sip_reason_class[];



enum { 
  /**@ingroup sip_security_client @internal 
   *
   * Hash of @ref sip_security_client "Security-Client header".
   *
   */
  sip_security_client_hash = 572 
};

/**Header class for @ref sip_security_client "Security-Client header".
 * 
 * The header class sip_security_client_class defines how a SIP
 * @ref sip_security_client "Security-Client header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_security_client_t header structure.
 *
 * @ingroup sip_security_client
 *
 */
SIP_DLL extern msg_hclass_t sip_security_client_class[];



enum { 
  /**@ingroup sip_security_server @internal 
   *
   * Hash of @ref sip_security_server "Security-Server header".
   *
   */
  sip_security_server_hash = 20148 
};

/**Header class for @ref sip_security_server "Security-Server header".
 * 
 * The header class sip_security_server_class defines how a SIP
 * @ref sip_security_server "Security-Server header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_security_server_t header structure.
 *
 * @ingroup sip_security_server
 *
 */
SIP_DLL extern msg_hclass_t sip_security_server_class[];



enum { 
  /**@ingroup sip_security_verify @internal 
   *
   * Hash of @ref sip_security_verify "Security-Verify header".
   *
   */
  sip_security_verify_hash = 29234 
};

/**Header class for @ref sip_security_verify "Security-Verify header".
 * 
 * The header class sip_security_verify_class defines how a SIP
 * @ref sip_security_verify "Security-Verify header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_security_verify_t header structure.
 *
 * @ingroup sip_security_verify
 *
 */
SIP_DLL extern msg_hclass_t sip_security_verify_class[];



enum { 
  /**@ingroup sip_privacy @internal 
   *
   * Hash of @ref sip_privacy "Privacy header".
   *
   */
  sip_privacy_hash = 13834 
};

/**Header class for @ref sip_privacy "Privacy header".
 * 
 * The header class sip_privacy_class defines how a SIP
 * @ref sip_privacy "Privacy header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_privacy_t header structure.
 *
 * @ingroup sip_privacy
 *
 */
SIP_DLL extern msg_hclass_t sip_privacy_class[];



enum { 
  /**@ingroup sip_etag @internal 
   *
   * Hash of @ref sip_etag "SIP-ETag header".
   *
   */
  sip_etag_hash = 64478 
};

/**Header class for @ref sip_etag "SIP-ETag header".
 * 
 * The header class sip_etag_class defines how a SIP
 * @ref sip_etag "SIP-ETag header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_etag_t header structure.
 *
 * @ingroup sip_etag
 *
 */
SIP_DLL extern msg_hclass_t sip_etag_class[];



enum { 
  /**@ingroup sip_if_match @internal 
   *
   * Hash of @ref sip_if_match "SIP-If-Match header".
   *
   */
  sip_if_match_hash = 26974 
};

/**Header class for @ref sip_if_match "SIP-If-Match header".
 * 
 * The header class sip_if_match_class defines how a SIP
 * @ref sip_if_match "SIP-If-Match header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_if_match_t header structure.
 *
 * @ingroup sip_if_match
 *
 */
SIP_DLL extern msg_hclass_t sip_if_match_class[];



enum { 
  /**@ingroup sip_mime_version @internal 
   *
   * Hash of @ref sip_mime_version "MIME-Version header".
   *
   */
  sip_mime_version_hash = 49047 
};

/**Header class for @ref sip_mime_version "MIME-Version header".
 * 
 * The header class sip_mime_version_class defines how a SIP
 * @ref sip_mime_version "MIME-Version header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_mime_version_t header structure.
 *
 * @ingroup sip_mime_version
 *
 */
SIP_DLL extern msg_hclass_t sip_mime_version_class[];



enum { 
  /**@ingroup sip_content_type @internal 
   *
   * Hash of @ref sip_content_type "Content-Type header".
   *
   */
  sip_content_type_hash = 51226 
};

/**Header class for @ref sip_content_type "Content-Type header".
 * 
 * The header class sip_content_type_class defines how a SIP
 * @ref sip_content_type "Content-Type header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_content_type_t header structure.
 *
 * @ingroup sip_content_type
 *
 */
SIP_DLL extern msg_hclass_t sip_content_type_class[];



enum { 
  /**@ingroup sip_content_encoding @internal 
   *
   * Hash of @ref sip_content_encoding "Content-Encoding header".
   *
   */
  sip_content_encoding_hash = 8707 
};

/**Header class for @ref sip_content_encoding "Content-Encoding header".
 * 
 * The header class sip_content_encoding_class defines how a SIP
 * @ref sip_content_encoding "Content-Encoding header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_content_encoding_t header structure.
 *
 * @ingroup sip_content_encoding
 *
 */
SIP_DLL extern msg_hclass_t sip_content_encoding_class[];



enum { 
  /**@ingroup sip_content_language @internal 
   *
   * Hash of @ref sip_content_language "Content-Language header".
   *
   */
  sip_content_language_hash = 62108 
};

/**Header class for @ref sip_content_language "Content-Language header".
 * 
 * The header class sip_content_language_class defines how a SIP
 * @ref sip_content_language "Content-Language header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_content_language_t header structure.
 *
 * @ingroup sip_content_language
 *
 */
SIP_DLL extern msg_hclass_t sip_content_language_class[];



enum { 
  /**@ingroup sip_content_disposition @internal 
   *
   * Hash of @ref sip_content_disposition "Content-Disposition header".
   *
   */
  sip_content_disposition_hash = 16333 
};

/**Header class for @ref sip_content_disposition "Content-Disposition header".
 * 
 * The header class sip_content_disposition_class defines how a SIP
 * @ref sip_content_disposition "Content-Disposition header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_content_disposition_t header structure.
 *
 * @ingroup sip_content_disposition
 *
 */
SIP_DLL extern msg_hclass_t sip_content_disposition_class[];



enum { 
  /**@ingroup sip_content_length @internal 
   *
   * Hash of @ref sip_content_length "Content-Length header".
   *
   */
  sip_content_length_hash = 8402 
};

/**Header class for @ref sip_content_length "Content-Length header".
 * 
 * The header class sip_content_length_class defines how a SIP
 * @ref sip_content_length "Content-Length header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_content_length_t header structure.
 *
 * @ingroup sip_content_length
 *
 */
SIP_DLL extern msg_hclass_t sip_content_length_class[];



enum { 
  /**@ingroup sip_unknown @internal 
   *
   * Hash of @ref sip_unknown "unknown headers".
   *
   */
  sip_unknown_hash = -3 
};

/**Header class for @ref sip_unknown "unknown headers".
 * 
 * The header class sip_unknown_class defines how a SIP
 * @ref sip_unknown "unknown headers" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_unknown_t header structure.
 *
 * @ingroup sip_unknown
 *
 */
SIP_DLL extern msg_hclass_t sip_unknown_class[];



enum { 
  /**@ingroup sip_error @internal 
   *
   * Hash of @ref sip_error "erroneous headers".
   *
   */
  sip_error_hash = -4 
};

/**Header class for @ref sip_error "erroneous headers".
 * 
 * The header class sip_error_class defines how a SIP
 * @ref sip_error "erroneous headers" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_error_t header structure.
 *
 * @ingroup sip_error
 *
 */
SIP_DLL extern msg_hclass_t sip_error_class[];



enum { 
  /**@ingroup sip_separator @internal 
   *
   * Hash of @ref sip_separator "separator line between headers and body".
   *
   */
  sip_separator_hash = -5 
};

/**Header class for @ref sip_separator "separator line between headers and body".
 * 
 * The header class sip_separator_class defines how a SIP
 * @ref sip_separator "separator line between headers and body" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_separator_t header structure.
 *
 * @ingroup sip_separator
 *
 */
SIP_DLL extern msg_hclass_t sip_separator_class[];



enum { 
  /**@ingroup sip_payload @internal 
   *
   * Hash of @ref sip_payload "message payload".
   *
   */
  sip_payload_hash = -6 
};

/**Header class for @ref sip_payload "message payload".
 * 
 * The header class sip_payload_class defines how a SIP
 * @ref sip_payload "message payload" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_payload_t header structure.
 *
 * @ingroup sip_payload
 *
 */
SIP_DLL extern msg_hclass_t sip_payload_class[];


SOFIA_END_DECLS
#endif /* !defined SIP_HCLASSES_H */
