/* $Id: xio-unix.c,v 1.20 2005/09/04 09:42:49 gerhard Exp $ */
/* Copyright Gerhard Rieger 2001-2005 */
/* Published under the GNU General Public License V.2, see file COPYING */

/* this file contains the source for opening addresses of UNIX socket type */

#include "xiosysincludes.h"
#include "xioopen.h"

#include "xio-socket.h"
#include "xio-listen.h"
#include "xio-unix.h"
#include "xio-named.h"


#if WITH_UNIX

static int xioopen_unix_connect(char *a1, int xioflags, xiofile_t *fd, unsigned groups, int dummy1, int dummy2, void *dummyp1);
static int xioopen_unix_listen(char *a1, int xioflags, xiofile_t *fd, unsigned groups, int dummy1, int dummy2, void *dummyp1);


const struct addrdesc addr_unix_connect = { "unix-connect",   3, xioopen_unix_connect, GROUP_FD|GROUP_NAMED|GROUP_SOCKET|GROUP_SOCK_UNIX|GROUP_RETRY, 0, 0, NULL HELP(":<filename>") };

#if WITH_LISTEN
const struct addrdesc addr_unix_listen  = { "unix-listen", 3, xioopen_unix_listen, GROUP_FD|GROUP_NAMED|GROUP_SOCKET|GROUP_SOCK_UNIX|GROUP_LISTEN|GROUP_CHILD|GROUP_RETRY, 0, 0, NULL HELP(":<filename>") };
#endif /* WITH_LISTEN */


#if WITH_LISTEN
static int xioopen_unix_listen(char *a1, int xioflags, xiofile_t *fd, unsigned groups, int dummy1, int dummy2, void *dummyp1) {
   /* we expect the form: filename */
   struct sockaddr_un us;
   char *name;
   struct opt *opts = NULL, *opts0 = NULL;
   int socktype = SOCK_STREAM;
   bool opt_unlink_early = false;
   bool opt_unlink_close = true;
   int result;

   socket_un_init(&us);

   name = a1;
   if (a1 = strchr(name, ',')) {
      if (a1-name > UNIX_PATH_MAX) {
	 Error2("socket address too long (%d, max is %d)",
		a1-name, UNIX_PATH_MAX);
	 return STAT_NORETRY;
      }
      *a1++ = '\0';
      strncpy(us.sun_path, name, Min(UNIX_PATH_MAX, a1-1-name));
      if (a1-1-name <= UNIX_PATH_MAX)
	 us.sun_path[a1-1-name] = '\0';
   } else {
      strncpy(us.sun_path, name, UNIX_PATH_MAX);
   }

   if (parseopts(a1, groups, &opts) < 0)
      return STAT_NORETRY;
   applyopts(-1, opts, PH_INIT);
   if (applyopts_single(&fd->stream, opts, PH_INIT) < 0)  return -1;

   retropt_bool(opts, OPT_UNLINK_EARLY, &opt_unlink_early);
   if (opt_unlink_early) {
      if (Unlink(name) < 0) {
	 if (errno == ENOENT) {
	    Warn2("unlink(\"%s\"): %s", name, strerror(errno));
	 } else {
	    Error2("unlink(\"%s\"): %s", name, strerror(errno));
	 }
      }
   }

   retropt_bool(opts, OPT_UNLINK_CLOSE, &opt_unlink_close);

   /* trying to set user-early, perm-early etc. here is useless because
      file system entry is available only past bind() call. */
   applyopts_named(name, opts, PH_EARLY);	/* umask! */

   retropt_int(opts, OPT_SO_TYPE, &socktype);

   if (opt_unlink_close) {
      if ((fd->stream.unlink_close = strdup(name)) == NULL) {
	 Error1("strdup(\"%s\"): out of memory", name);
      }
      fd->stream.opt_unlink_close = true;
   }

   opts0 = copyopts(opts, GROUP_ALL);

   if ((result =
	xioopen_listen(&fd->stream, xioflags,
		     (struct sockaddr *)&us, sizeof(struct sockaddr_un),
		     opts, opts0, PF_UNIX, socktype, 0))
       != 0)
      return result;
   return 0;
}
#endif /* WITH_LISTEN */


static int xioopen_unix_connect(char *a1, int xioflags, xiofile_t *xxfd, unsigned groups, int dummy1, int dummy2, void *dummyp1) {
   /* we expect the form: filename */
   struct single *xfd = &xxfd->stream;
   char *a2;
   bool needbind = false;
   struct sockaddr_un them, us;
   struct opt *opts = NULL;
   bool opt_unlink_close = false;
   int result;

   socket_un_init(&us);
   socket_un_init(&them);

   if (a2 = strchr(a1, ','))  *a2++ = '\0';

   strncpy(them.sun_path, a1, UNIX_PATH_MAX);

   if (parseopts(a2, groups, &opts) < 0) {
      return STAT_NORETRY;
   }
   retropt_bool(opts, OPT_UNLINK_CLOSE, &opt_unlink_close);

   applyopts(-1, opts, PH_INIT);
   if (applyopts_single(xfd, opts, PH_INIT) < 0)  return -1;

   if (retropt_bind(opts, AF_UNIX, NULL, (struct sockaddr *)&us, 0) >= 0) {
      needbind = true;
   }

   if (opt_unlink_close) {
      if ((xxfd->stream.unlink_close = strdup(a1)) == NULL) {
	 Error1("strdup(\"%s\"): out of memory", a1);
      }
      xxfd->stream.opt_unlink_close = true;
   }

   if ((result =
	xioopen_connect(xfd,
		      needbind?(struct sockaddr *)&us:NULL, sizeof(us),
		      (struct sockaddr *)&them,
		      sizeof(struct sockaddr_un),
		      opts, PF_UNIX, SOCK_STREAM, 0, false)) != 0) {
      return result;
   }
   if ((result = _xio_openlate(xfd, opts)) < 0) {
      return result;
   }
   return 0;
}

#endif /* WITH_UNIX */
