/*********************************************************************
tree.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

tree.h is the header file for tree.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#include "anommem.h"

extern mindex T[NUM_FEATURES];

#define isleaf(node) (node & DMINDEXMASK)
#define asleaf(leaf) (leaf | DMINDEXMASK)
#define encleaf2mindex(node) (node ^ DMINDEXMASK)
/* arg is a dmindex; if it denotes a leaf, return the count on that leaf
   otherwise return the sum on the interior node */ 
#define count_or_sum(node) (isleaf(node) ? leafnode(encleaf2mindex(node)).count : intnode(node).sum)
#define eleafval(leaf) leafnode(encleaf2mindex(leaf)).value
#define largestval(node) (isleaf(node) ? eleafval(node) : largest_val(node))
#define treetype(t) tree(t).type
#define treeroot(t) tree(t).root
#define treenext(t) tree(t).next
#define intleft(node) intnode(node).left
#define intright(node) intnode(node).right
#define intsum(node) intnode(node).sum
#define intsortpt(node) intnode(node).sortpt
#define intwait(node) intnode(node).wait
#define leafcount(leaf) leafnode(leaf).count
#define leafvalue(leaf) leafnode(leaf).value
#define leafnexttree(leaf) leafnode(leaf).nexttree

/* return the standard wait time for an interior node given the counts on 
   its children */
#define wait_time(c1,c2) (min(max(10,ceil(c1>c2?(2*c2-c1):(2*c1-c2))),MAX_U16))

void tree_init();
void increment_simple_count(features type1,valtype val1);
void increment_2joint_count(features type1,valtype val1,features type2,valtype val2,int skip);
void increment_3joint_count(features type1,valtype val1,features type2,valtype val2,features type3,valtype val3,int skip);
void increment_4joint_count(features type1,valtype val1,features type2,valtype val2,features type3,valtype val3,features type4,valtype val4,int skip);
double prob_simple(features type1,valtype val1);
double prob_cond1(features type,valtype val,features ctype,valtype cval);
double prob_cond2(features type,valtype val,features ctype1,valtype cval1,features ctype2,valtype cval2);
double prob_cond3(features type,valtype val,features ctype1,valtype cval1,features ctype2,valtype cval2,features ctype3,valtype cval3);
double prob_2joint(features type1,valtype val1,features type2,valtype val2);
double prob_Njoint(int size,features type[],valtype val[]);

void scale_and_prune_all_trees(double factor,double threshold);

void write_all_uncond_probs(FILE *f);
void write_all_cond_probs(FILE *f);

float feature_trees_stats(features f,float *amind,float *amaxd,float *aaved,float *awaved);
featcomb calc_all_entropies();
void write_all_entropies(FILE *f,featcomb c);

void print_all_trees();
void printtree(dmindex tree,char *ind);

int sanity_check_trees();

/* generally no need to call these externally */
double tree_value_prob(mindex tree,valtype val);
mindex find_nexttree_of_type(mindex leaf,features type);
mindex get_nexttree_of_type(mindex leaf,features type);
mindex incr_tree_value_count(mindex tree,valtype newval);
mindex increment_value_count(mindex node,valtype val);
mindex add_node_above_to_right(mindex node,valtype val);
mindex add_node_above_to_left(mindex node,valtype val);
mindex add_node_between(mindex node,valtype val);
void rebalance_tree(mindex tree);
void rebalance_subtree(mindex encnode);
int out_of_balance(mindex node);
void free_all_in_tree(mindex tree);
void free_all_in_subtree(dmindex encnode);
void scale_and_prune_tree(mindex tree,double factor,double threshold);
dmindex scale_and_prune_subtree(dmindex encnode,double factor,double threshold,double *change,valtype *newrightmost);
valtype largest_val(mindex node);
mindex dup_intnode(mindex node);
mindex find_leaf(mindex tree,valtype newval);
mindex find_leaf_in_subtree(dmindex encchild,valtype val);
mindex find_leaf2(features type1,valtype val1,features type2,valtype val2);
mindex find_leaf3(features type1,valtype val1,features type2,valtype val2,features type3,valtype val3);
unsigned int feature_tree_stats(mindex tree,features f,unsigned int *smind,unsigned int *smaxd,float *saved,float *swaved,unsigned int *snum_leaves);
unsigned int feature_subtree_stats(mindex encnode,features f,unsigned int *smind,unsigned int *smaxd,float *saved,float *swaved,unsigned int *snum_leaves);
unsigned int tree_stats(mindex tree,unsigned int *mind,unsigned int *maxd,float *aved,float *waved);
double tree_count(mindex tree);
unsigned int num_leaves(mindex tree);
unsigned int num_subtree_leaves(mindex encnode);
unsigned int tree_depth_total(mindex tree);
unsigned int subtree_depth_total(mindex encnode,unsigned int depth);
double weighted_tree_depth_total(mindex tree);
double weighted_subtree_depth_total(mindex encnode,unsigned int depth);
void tree_min_max_depth(mindex tree,unsigned int *mind,unsigned int *maxd);
void subtree_min_max_depth(mindex tree,unsigned int *mind,unsigned int *maxd,unsigned int depth);
void write_feat_val_list(FILE *f,int depth,features feats[],valtype vals[]);
void write_all_tree_uncond_probs(FILE *f,mindex tree,int depth,features feats[],valtype vals[],double treesum);
void write_all_subtree_uncond_probs(FILE *f,dmindex encnode,int depth,features feats[],valtype vals[],double treesum);
void write_all_tree_cond_probs(FILE *f,mindex tree,int depth,features feats[],valtype vals[]);
void write_all_subtree_cond_probs(FILE *f,dmindex encnode,int depth,features feats[],valtype vals[],double treesum);
void write_featurecomb(featcomb C,double val,int depth,features feats[]);
void inc_featurecomb(featcomb C,double val,int depth,features feats[]);
featcomb create_featurecomb(int depth,double val);
void scale_all_featurecomb(featcomb c,double factor);
void add_all_tree_entrsum(featcomb c,mindex tree,int depth,features feats[],double totsum);
void add_all_subtree_entrsum(featcomb c,dmindex encnode,int depth,features feats[],double treesum,double totsum);
void write_all_entropies2(FILE *f,featcomb c,int depth,features feats[]);
void write_feature_names(FILE *f,int depth,features feats[]);
void printtree2(dmindex encnode,char *ind);
void printtree_shallow(dmindex tree);
void printtree2_shallow(dmindex encnode);
int sanity_check_tree(mindex tree);
int sanity_check_subtree(dmindex encnode);

/* $Id: tree.h,v 1.3 2000/09/22 17:43:54 jim Exp $ */
