/*==================================================================
 * keyspan.h - Header file for keyspan widget
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __KEYSPAN_H__
#define __KEYSPAN_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#define KEYSPAN(obj)	GTK_CHECK_CAST(obj, keyspan_get_type(), KeySpan)
#define KEYSPAN_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, keyspan_get_type(), KeySpanClass)
#define IS_KEYSPAN(obj)	GTK_CHECK_TYPE(obj, keyspan_get_type())

enum
{ KEYSPAN_KEYMODE, KEYSPAN_VELMODE };

typedef struct _KeySpan KeySpan;
typedef struct _KeySpanClass KeySpanClass;

struct _KeySpan
{
  GtkWidget widget;

  guint8 mode;			/* 0 = keyspan, 1 = velocity span */
  guint8 selected;		/* current selected endpoint: 0=none,1=lo,2=hi */

  guint8 lokey;			/* low key number */
  guint8 hikey;			/* high key number */
};

struct _KeySpanClass
{
  GtkWidgetClass parent_class;

  void (*span_change) (KeySpan * keyspan);
};

#define KEYSPAN_DEFAULT_SIZEX 676
#define KEYSPAN_DEFAULT_SIZEY 16

GtkWidget *keyspan_new (void);
guint keyspan_get_type (void);
void keyspan_set_mode (KeySpan * keyspan, gint mode);
void keyspan_set_span (KeySpan * keyspan, guint8 lokey, guint8 hikey);

#endif /* __KEYSPAN_H__ */
