/*==================================================================
 * uif_sfont.h - Header file for sound font interface routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __UIF_SFONT__
#define __UIF_SFONT__

#include <gtk/gtk.h>
#include "sfont.h"
#include "vbank.h"

/* forward declaration to fix UISFont/SFTreeNodes mutual dependancy */
typedef struct _UISFont UISFont;
typedef struct _UIVBank UIVBank;

#include "uif_sftree.h"


#define RGB2GDK(c, r, g, b)	G_STMT_START {	\
    c.red = (guint32)r * 65535 / 255;		\
    c.green = (guint32)g * 65535 / 255;		\
    c.blue = (guint32)b * 65535 / 255;		\
} G_STMT_END

/* ties user interface information to SFData */
struct _UISFont
{
  SFData *sf;
  SFTreeNodes *nodes;		/* sftree nodes, see uif_sftree.h */
};

/* ties user interface information to VBnkData */
struct _UIVBank
{
  VBnkData *vbnk;		/* virtual bank data */
  VBnkNodes *nodes;		/* sftree nodes for virtual banks */
};

/* global vars */

GList *uisf_sfonts;
GList *uisf_vbanks;

UISFont *uisf_selected_uisfont;
gpointer uisf_selected_elem;
gint uisf_selected_elem_type;
SFZone *uisf_selected_zone;

gboolean uisf_piano_follows;
gboolean uisf_auto_temp_audible;

/* function prototypes */

void uisf_init (void);
UISFont *uisf_add_sfont (SFData * sf);
UIVBank *uisf_add_vbank (VBnkData *vbnk);
void uisf_remove_sfont (UISFont * uisf);
void uisf_remove_vbank (UIVBank * uivb);
void uisf_new_sfont (void);
void uisf_new_vbank (void);
UISFont *uisf_find_sfont_by_fname (gchar * fname, SFData * excl);
UIVBank *uisf_find_vbank_by_fname (gchar * fname, VBnkData * excl);
SFItemID uisf_load_sfont (gchar * fname);
void uisf_open_sfont (void);
void uisf_dump_sfont (void);
void uisf_close_sfont (void);
GtkWidget *uisf_save_sfont (gint save_as);
void uisf_sfont_info (void);
void uisf_cb_sfont_info_date_today (GtkWidget * btn, GtkWidget * entry);
void uisf_cb_sfont_info_okay (GtkWidget * btn, GtkWidget *infowin);

void uisf_item_properties (void);
void uisf_newmod_preset (gboolean create);
GtkWidget * uisf_create_preset_config_dialog (gchar *title, gchar *name,
  guint8 bank, guint8 prenum, GtkSignalFunc cbfunc);
void uisf_cb_newmod_preset_type_toggled (GtkToggleButton * togglebutton,
  GtkWidget * presetwin);	/* glade */
void uisf_cb_newmod_preset_okay (GtkButton * button, GtkWidget * psetwin);	/* glade */
void uisf_newmod_inst (gboolean create);
GtkWidget *uisf_create_inst_config_dialog (gchar *title, gchar *name,
					   GtkSignalFunc cbfunc);
void uisf_cb_newmod_inst_okay (GtkButton * button, GtkWidget * instwin);	/* glade */
void uisf_modify_sample (void);
GtkWidget *uisf_create_sample_config_dialog (gchar *title, gchar *name,
					     guint32 samplerate, gint8 pitchadj,
					     GtkSignalFunc cbfunc);
void uisf_cb_modify_sample_okay (GtkButton * button, GtkWidget * samwin);       /* glade */
void uisf_dialog_sfitem_delete (void);
void uisf_item_global_zone (void);
void uisf_find (void);
void uisf_goto_zone_ref (void);
void uisf_sfitem_add (SFItemID parent, gpointer data, gint pos, SFNodeType type);
void uisf_sfitem_delete (SFItemID qnode);

void uisf_set_sam_in_view (SFSample * sam, SFData * sf, gboolean forceupd);
void uisf_sfitem_selected (GtkCTreeNode * node);
void uisf_deactivate_selection (void);
void uisf_silence_audible (void);
void uisf_set_selected_nozone (void);
void uisf_wavetable_load_sfitem (SFItemID itemid, gboolean force);
void uisf_wavetable_reset (void);

#endif
