/*==================================================================
 * wtbl_awe.c - OSS AWE wavetable driver routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#include "config.h"

#ifdef AWE_SUPPORT

#include <stdio.h>
#include <glib.h>

#include "wtbl_awe.h"
#include "wtbl_awefx.h"
#include "wavetable.h"
#include "seq_oss.h"
#include "smurfcfg.h"
#include "util.h"

#if defined(HAVE_SYS_SOUNDCARD_H)
#include <sys/soundcard.h>
#elif defined(HAVE_MACHINE_SOUNDCARD_H)
#include <machine/soundcard.h>
#endif

#if defined(HAVE_AWE_VOICE_H)
#include <awe_voice.h>
#elif defined(HAVE_SYS_AWE_VOICE_H)
#include <sys/awe_voice.h>
#elif defined(HAVE_LINUX_AWE_VOICE_H)
#include <linux/awe_voice.h>
#endif


SEQ_USE_EXTBUF ();		/* use buffer from seq_oss.c */

gboolean awe_new_api = FALSE;

gint
awe_init (void)
{				/* initialize AWE */
  if (!seq_oss_init_synth (SAMPLE_TYPE_AWE32, wtbl_drivers[WTBL_AWE].name))
    return (FAIL);

  /* use MIDI channel mode */
  AWE_SET_CHANNEL_MODE (seq_oss_dev, AWE_PLAY_MULTI);
  seqbuf_dump ();

#if defined(AWE_REMOVE_INFO) && !defined(AWE_NO_CACHE_SUPPORT)
  /* if newer (v0.4.4) AWE driver */
  awe_new_api = TRUE;
#endif

  return (OK);
}

/* this stuff isn't used yet */
void
awe_set_effect (gint chan, guint16 genid, SFGenAmount amt)
{
  gint aweval;

  g_return_if_fail (genid <= SFGen_MaxValid);
  g_return_if_fail (awefxtbl[genid].method != METH_INVALID);
  if (awefxtbl[genid].method == METH_NONE)
    return;

  printf ("awe_set_effect %d = %d\n", genid, amt.sword);

  if (awefxtbl[genid].convfunc)
    aweval = (*awefxtbl[genid].convfunc) (amt.sword);
  else
    aweval = aweval;

  if (awefxtbl[genid].method == METH_EFFECT)
    {
      printf ("AWE_ADD_EFFECT %d = %d\n", awefxtbl[genid].awenum, aweval);
      AWE_SEND_EFFECT (seq_oss_dev, chan, awefxtbl[genid].awenum, aweval);
    }

/*
    else SEQ_CONTROL(oss_dev, chan, awefxtbl[genid].awenum, aweval);
*/
}

#endif /* #ifdef AWE_SUPPORT */
