/***************************************************************************
    smb4kerror  -  This is the class that manages the error messages.
                             -------------------
    begin                : Fr Sep 22 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KERROR_H
#define SMB4KERROR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


class Smb4KError
{
  public:
   /**
    * Show an error that occurred in the core.
    *
    * @param code        The error code as defined in smb4kdefs.h
    *
    * @param text        Short text which will be included in the message that's shown
    *                    to the user. Normally, a file name or similar is entered here.
    *                    May be left blank if you do not need to fill text into the error
    *                    message. Please note, that this text is not used to show details.
    *
    * @param details     The text passed here is used to show details. Please note, that
    *                    it depends on the kind of error if it is indeed shown.
    */
    static void error( int code,
                       const QString &text = QString::null,
                       const QString &details = QString::null );

   /**
    * Show a warning.
    *
    * @param code        The code as defined in smb4kdefs.h
    *
    * @param text        Short text which will be included in the message that's shown
    *                    to the user. Normally, a file name or similar is entered here.
    *                    May be left blank if you do not need to fill text into the error
    *                    message. Please note, that this text is not used to show details.
    *
    * @param details     The text passed here is used to show details. Please note, that
    *                    it depends on the kind of error if it is indeed shown.
    *
    * @returns an integer value according to KMessageBox::ButtonCode or 0 if the warning code
    * is unknown.
    */
    static int warning( int code,
                        const QString &text = QString::null,
                        const QString &details = QString::null );

   /**
    * Show an information.
    *
    * @param code        The code as defined in smb4kdefs.h
    *
    * @param text        Short text which will be included in the message that's shown
    *                    to the user. Normally, a file name or similar is entered here.
    *                    May be left blank if you do not need to fill text into the error
    *                    message. Please note, that this text is not used to show details.
    *
    * @param details     The text passed here is used to show details. Please note, that
    *                    it depends on the kind of error if it is indeed shown.
    */
    static void information( int code,
                             const QString &text = QString::null,
                             const QString &details = QString::null );
};

#endif
