/***************************************************************************
    smb4kshareoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

// KDE includes
#include <klocale.h>
#include <kbuttonbox.h>

// system includes
#include <stdlib.h>

// applications specific includes
#include "smb4kshareoptions.h"
#include "../smb4k.h"

Smb4KShareOptions::Smb4KShareOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  QVGroupBox *dirBox = new QVGroupBox( i18n( "Directories" ), this );

  QWidget *dir_container = new QWidget( dirBox, "DirectoryContainer" );
  QGridLayout *dir_layout = new QGridLayout( dir_container );
  dir_layout->setSpacing( 10 );

  QLabel *mount_prefix_label = new QLabel( i18n( "Mount prefix:" ), dir_container );
  dir_layout->addWidget( mount_prefix_label, 0, 0, 0 );
  m_mount_prefix = new KURLRequester( QString::null, dir_container );
  m_mount_prefix->setMode( KFile::Directory );
  dir_layout->addWidget( m_mount_prefix, 0, 1, 0 );

  m_lowercase = new QCheckBox( i18n( "Force generated subdirectories to be lower case" ), dir_container );
  dir_layout->addMultiCellWidget( m_lowercase, 1, 1, 0, 1, 0 );

  QButtonGroup *mountBox = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Mounting and Unmounting" ), this );
  m_unmountAll = new QCheckBox( i18n( "Unmount all shares of user %1 on exit" ).arg( getenv( "USER" ) ), mountBox );
  m_mountRecent = new QCheckBox( i18n( "Remount recently used shares on program start" ), mountBox );
  m_allowUnmountForeign = new QCheckBox( i18n( "Allow the unmounting of shares that are owned by other users" ), mountBox );

  QGroupBox *checks = new QGroupBox( 2, QGroupBox::Horizontal, i18n( "Checks" ), this );
  (void) new QLabel( i18n( "Interval between checks:" ), checks );
  m_check_interval = new KIntNumInput( 2500, checks, 10, "IntervalInput" );
  m_check_interval->setSuffix( " ms" );
  m_check_interval->setRange( 500, 300000, 1, false );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( dirBox, 0, 0, 0 );
  grid->addWidget( mountBox, 1, 0, 0 );
  grid->addWidget( checks, 2, 0, 0 );
  grid->addItem( spacer2, 3, 0 );
}

Smb4KShareOptions::~Smb4KShareOptions()
{
}


#include "smb4kshareoptions.moc"
