/***************************************************************************
                          smb4ksearchdialog  -  description
                             -------------------
    begin                : Do Dez 8 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSEARCHDIALOG_H
#define SMB4KSEARCHDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>

// KDE includes
#include <kcombobox.h>
#include <kpushbutton.h>
#include <klistbox.h>
#include <ktoolbar.h>

// application specific includes
#include "../core/smb4knetworkitems.h"

/**
 * This is the search dialog. It enables the user to find servers,
 * that were not found by the regular network scan.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSearchDialog : public QWidget
{
  Q_OBJECT;

  public:
    /**
     * The constructor.
     *
     * @param parent      the parent widget
     *
     * @param name        the name of this widget
     */
    Smb4KSearchDialog( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSearchDialog();

    /**
     * This function returns a pointer to the combo box. It is useful
     * if you want to set the keyboard focus, etc.
     *
     * @returns a pointer to the combo box.
     */
    KComboBox *comboBox() { return m_input; }

  signals:
    /**
     * This signal emits the highlighted search result.
     *
     * @param item        the search result
     */
    void searchResult( Smb4KHostItem *item );

  protected slots:
    /**
     * This slot is invoked, if a button of the tool bar has
     * been clicked.
     *
     * @param id          the button id
     */
    void slotButtonClicked( int id );

    /**
     * This slot is invoked, if the user pressed Return in the
     * combo box.
     */
    void slotReturnPressed();

    /**
     * This slot receives the results of the network search.
     *
     * @param item        the host item passed on by the scanner
     */
    void slotReceivedSearchResult( Smb4KHostItem *item );

    /**
     * This slot is invoked when the text in the combo box
     * changed.
     *
     * @param text        the text that's in the combo box
     */
    void slotTextChanged( const QString &text );

    /**
     * This slot is invoked when an item is clicked in the
     * list box.
     *
     * @param item        the executed item
     */
    void slotItemClicked( QListBoxItem *item );

    /**
     * This slot is invoked, if the user double clicked an
     * in the list box.
     */
    void slotItemDoubleClicked( QListBoxItem *item );

    /**
     * This slot is invoked, when a host item has been added to
     * the browser widget.
     *
     * @param item        The host item that has been added to the browser widget.
     */
    void slotItemAddedToBrowser( Smb4KHostItem *item );

    /**
     * This slot is invoked when the contents of the hosts list carried by the
     * scanner has changed. It is used to mark the hosts that are in or not in
     * the list.
     */
    void slotCheckItemInBrowser();


  private:
    /**
     * Enumeration for the buttons.
     */
    enum Buttons{ Search, Add, Clear };

    /**
     * The toolbar.
     */
    KToolBar *m_toolbar;

    /**
     * The combo box
     */
    KComboBox *m_input;

    /**
     * The list box
     */
    KListBox *m_window;

    /**
     * Holds the host's name the user is searching for.
     */
    QString m_host;
};

#endif
