/***************************************************************************
    smb4knetworkoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// application specific includes
#include "smb4knetworkoptions.h"

// Qt includes
#include <qbuttongroup.h>
#include <qvgroupbox.h>
#include <qlayout.h>

// KDE includes
#include <klocale.h>

Smb4KNetworkOptions::Smb4KNetworkOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  //
  // The browse list group box.
  //
  QButtonGroup *browsebox = new QButtonGroup( 1, Qt::Horizontal, i18n( "Browse List" ), this );

  m_useNMB = new QRadioButton( i18n( "Scan the network to retrieve the browse list" ), browsebox );
  m_useMaster = new QRadioButton( i18n( "Query the current workgroup master browser to retrieve the browse list" ), browsebox );

  QWidget *masterWidget = new QWidget( browsebox );
  QGridLayout *masterLayout = new QGridLayout( masterWidget );
  m_useHost = new QRadioButton( i18n( "Query this master browser to retrieve the browse list:" ), masterWidget );
  m_hostName = new KLineEdit( masterWidget );
  m_hostName->setMinimumWidth( 150 );
  masterLayout->addWidget( m_useHost, 0, 0, 0 );
  masterLayout->addWidget( m_hostName, 0, 1, 0 );

  browsebox->insert( m_useHost, -1 );

  //
  // The search group box
  //
  QButtonGroup *searchbox = new QButtonGroup( 1, Qt::Horizontal, i18n( "Network Search" ), this );
  QLabel *description = new QLabel( searchbox );
  description->setText( i18n( "Smb4K uses <i>nmblookup</i> by default to do network searches. This method is very reliable but fails sometimes if your network neighborhood is configured uncommonly. In this case you should try to use <i>smbclient</i>." ) );
  description->setTextFormat( Qt::RichText );

  m_nmbSearch = new QRadioButton( i18n( "Use nmblookup (recommended)" ), searchbox );
  m_clientSearch = new QRadioButton( i18n( "Use smbclient" ), searchbox );

  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( browsebox, 0, 0, 0 );
  grid->addWidget( searchbox, 1, 0, 0 );
  grid->addItem( spacer4, 2, 0 );
}


Smb4KNetworkOptions::~Smb4KNetworkOptions()
{
}


#include "smb4knetworkoptions.moc"
