/***************************************************************************
    smb4ksearchtab.h  -  The search widget class.
                             -------------------
    begin                : Son Mai 11 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSEARCHTAB_H
#define SMB4KSEARCHTAB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>

// KDE includes
#include <kcombobox.h>
#include <kpushbutton.h>
#include <klistbox.h>

// application specific includes
#include "../core/smb4knetworkitems.h"

/** 
 * This class contains the Search tab widget.
 */

class Smb4KSearchTab : public QWidget
{
  Q_OBJECT;

  friend class Smb4KApp;

  public:
    /** 
     * The constructor.
     */
    Smb4KSearchTab( QWidget *parent = 0, const char *name = 0 );
    /** 
     * The destructor.
     */
    ~Smb4KSearchTab();

  protected slots:
    /** 
     * This slot is called, if ENTER is pressed or if the
     * user clicked the Search button. 
     */
    void slotSearchClicked();
    /** 
     * This slot is called, if the Add button is clicked. 
     */
    void slotAddClicked();
    /** 
     * This slot is called, if the Clear All button is clicked. 
     */
    void slotClearAllClicked();
    /** 
     * This slot receives the results of the network search. 
     */
    void slotReceivedSearchResult( Smb4KHostItem *item );
    /**
     * This slot is called when you execute an item in the
     * QListBox.
     */
//    void slotItemExecuted( QListBoxItem * );

  private:
    KComboBox *m_input;
    KPushButton *m_searchButton;
    KPushButton *m_addButton;
    KPushButton *m_clearAllButton;
    KListBox *m_window;
    /** Holds the host's name the user is searching for. */
    QString m_host;
};

#endif
