/***************************************************************************
    smb4knetworkitems  -  Network items used by the Smb4KScanner class
    to pass and store data.
                             -------------------
    begin                : Mi Jun 2 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KNETWORKITEMS_H
#define SMB4KNETWORKITEMS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qstring.h>

/**
 * This class provides a container for a workgroup found in the network
 * neighborhood.
 */
 
class Smb4KWorkgroupItem
{
  public:
    /**
     * The constructor.
     */
    Smb4KWorkgroupItem( const QString &name, const QString &master, const QString &masterIP = QString::null );
    /**
     * Empty constructor.
     */
    Smb4KWorkgroupItem() {}
    /**
     * The destructor.
     */
    ~Smb4KWorkgroupItem();
    /**
     * Returns the workgroup name.
     */
    QString workgroup() const { return m_name; }
    /**
     * Returns the name of the master browser.
     */
    QString master() const { return m_master; }
    /**
     * Returns the IP address of the master browser.
     */
    QString ip() const { return m_ip; }
    /**
     * You can mark the master as 'pseudo' with this function.
     */
    void setPseudo();
    /**
     * Returns TRUE, if the master is a 'pseudo'-master.
     */
    bool pseudo() const { return m_pseudo; }
    
  private:
    /**
     * The name of the workgroup.
     */
    QString m_name;
    /**
     * The name of the workgroup master.
     */
    QString m_master;
    /**
     * The IP address of the master.
     */
    QString m_ip;
    /**
     * Determines whether the master is a 'pseudo'-master.
     */
    bool m_pseudo;
};


/**
 * This class provides a container for a host found in the network
 * neighborhood.
 */
 
class Smb4KHostItem
{
  public:
    /**
     * The constructor.
     */
    Smb4KHostItem( const QString &workgroup, const QString &name, const QString &comment = QString::null, const QString &ip = QString::null );
    /**
     * The empty constructor.
     */
    Smb4KHostItem() {}
    /**
     * The destructor.
     */
    ~Smb4KHostItem();
    /**
     * Returns the workgroup the host is in.
     */
    QString workgroup() const { return m_workgroup; }
    /**
     * Returns the name of the host.
     */
    QString name() const { return m_name; }
    /**
     * Returns the IP address of the host.
     */
    QString ip() const { return m_ip; }
    /**
     * Returns the comment for this host.
     */
    QString comment() const { return m_comment; }
    /**
     * Sets the Server string that is reported by the host.
     */
    void setServerString( const QString &server );
    /**
     * Returns the Server string.
     */
    QString serverString() const { return m_server_string; }
    /**
     * Sets the OS string that is reported by the host.
     */
    void setOSString( const QString &os );    
    /**
     * Returns the OS string.
     */
    QString osString() const { return m_os_string; }
    
  private:
    /**
     * The name of the workgroup.
     */
    QString m_workgroup;
    /**
     * The name of the host.
     */
    QString m_name;
    /**
     * The comment for this host.
     */
    QString m_comment;
    /**
     * The IP address of the host.
     */
    QString m_ip;
    /**
     * The Server string as reported by the host.
     */
    QString m_server_string;
    /**
     * The operating system string as reported by the host.
     */
    QString m_os_string;
};


/**
 * This class provides a container for a share found in the 
 * network neighborhood.
 */
 
class Smb4KShareItem
{
  public:
    /**
     * The constructor.
     */
    Smb4KShareItem( const QString &workgroup, const QString &host, const QString &name, const QString &type, const QString &comment );
    /**
     * Empty constructor.
     */
    Smb4KShareItem() {}
    /**
     * The destructor.
     */
    ~Smb4KShareItem();
    /**
     * Returns the workgroup of the host where the share is located.
     */
    QString workgroup() const { return m_workgroup; }
    /**
     * Returns the name of the host where the share is located.
     */
    QString host() const { return m_host; }
    /**
     * Returns the name of the share.
     */
    QString name() const { return m_name; }
    /**
     * Returns the type of the share.
     */
    QString type() const { return m_type; }
    /**
     * Returns the comment for this share.
     */
    QString comment() const { return m_comment; }
    
  private:
    /**
     * The workgroup object.
     */
    QString m_workgroup;
    /**
     * The host name.
     */
    QString m_host;
    /**
     * The name of the share.
     */
    QString m_name;
    /**
     * The type of the share.
     */
    QString m_type;
    /**
     * The comment for this share.
     */
    QString m_comment;
};


/**
 * This class provides a container for the preview
 * of the contents of a share.
 */
 
class Smb4KPreviewItem
{
  public:
    /**
     * The default constructor.
     */
    Smb4KPreviewItem( const QString &host, const QString &share, const QString &path, const QString &name, bool file = true );
    /**
     * The empty constructor.
     */
    Smb4KPreviewItem() {}
    /**
     * The destructor.
     */
    ~Smb4KPreviewItem();
    /**
     * Return the name of the host where the share is located.
     */
    QString host() const { return m_host; }
    /**
     * Return the name of the share that is to be previewed.
     */
    QString share() const { return m_share; }
    /**
     * Return the path that is to be previewed.
     */
    QString path() const { return m_path; }
    /**
     * Return the name of the item.
     */
    QString name() const { return m_name; }
    /**
     * Returns TRUE if this item is a file.
     */
    bool isFile() const { return m_isFile; }
    /**
     * Sets the item to be a file or a directory.
     */
    void setIsFile( bool sw );
    
  private:
    /**
     * The host name.
     */
    QString m_host;
    /**
     * The share name.
     */
    QString m_share;
    /**
     * The path that has to be previewed.
     */
    QString m_path;
    /**
     * The name of the item.
     */
    QString m_name;
    /**
     * Determines whether this is a file or a directory.
     */
    bool m_isFile;
};

#endif
