/*
 * slmon
 *
 * Copyright (C) 2000 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is based on WMMon.app.
 *
 * WMMon.app is copyright (c) 1997, 1998 by Martijn Pieterse and
 * Antoine Nulle.
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 */

#include "signal_handling.h"
#include "defines.h"

void cleanup(int sig)
{
#ifdef HAVE_SLANG
    SLtt_set_cursor_visibility(1);
    SLang_reset_tty();
    SLsmg_reset_smg();
#endif
#ifdef HAVE_GTOP
    glibtop_close()
#endif
	exit(sig);
}

#ifdef HAVE_SLANG
void init_signals(void)
{
    SLsignal(SIGWINCH, handleSIGWINCH);
    SLsignal(SIGKILL, cleanup);
    SLsignal(SIGINT, cleanup);
    SLsignal(SIGQUIT, cleanup);
    SLsignal(SIGSTOP, cleanup);
    SLsignal(SIGTERM, cleanup);
    SLsignal(SIGSEGV, cleanup);
}

void handleSIGWINCH(int signal)
{
    extern int redraw;

    SLsig_block_signals();
    SLtt_get_terminfo();
    SLsmg_reset_smg();
    SLsmg_init_smg();
    SLtt_get_screen_size();
    SLsmg_cls();

    draw_status();
    clear_histogram();
    redraw = 1;
    pos = 0;
    SLsmg_refresh();
    SLsig_unblock_signals();
    SLsignal_intr(SIGWINCH, handleSIGWINCH);
}
#endif
