/*
    This file is part of the sly ident daemon (slidentd).  slidentd 
    was written by Sean Hunter <sean@uncarved.com> as a minimal 
    RFC1413 (ident) daemon.

    slidentd is copyright (c) 2001 Uncarved Systems Ltd.

    slidentd is free software; you can redistribute it and/or modify
    it under the terms of iversion 2 of the GNU General Public License 
    as published by the Free Software Foundation.

    slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    in the file COPYING along with slidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "slid_read.h"
#include <errno.h>
#include <stdlib.h>

ssize_t
slid_read(int fd, void *buf, size_t count)
{
	int actually_read = 0;
	do {
		errno = 0;
		actually_read = read(fd, buf, count);
	} while (errno == EINTR || errno == EAGAIN);

	if (errno) {
		return -1;
	}

	return actually_read;
}

ssize_t
slid_readn(int fd, void *buf, size_t count)
{
	int pos = 0;
	int togo = count;
	while (togo > 0) {
		int actually_read = slid_read(fd, buf + pos, togo);

		if (errno) {
			return -1;
		} else if (actually_read == 0) {
			break;
		}

		togo -= actually_read;
		pos += actually_read;
	}

	return pos;
}
