*DECK DFNCK
      SUBROUTINE DFNCK (LUN, KPRINT, IPASS)
C***BEGIN PROLOGUE  DFNCK
C***PURPOSE  Quick check for the double precision Fullerton
C            special functions.
C***LIBRARY   SLATEC
C***KEYWORDS  QUICK CHECK
C***AUTHOR  Boland, W. Robert, (LANL)
C           Chow, Jeff, (LANL)
C***DESCRIPTION
C
C     This subroutine does a quick check for the double precision
C     routines in the Fullerton special function library.
C
C     Parameter list-
C
C     LUN      input integer value to designate the external
C              device unit for message output
C     KPRINT   input integer value to specify amount of
C              printing to be done by quick check
C     IPASS    output value indicating whether tests passed or
C              failed
C
C***ROUTINES CALLED  D1MACH, D9ATN1, D9LN2R, DACOSH, DAI, DAIE, DASINH,
C                    DATANH, DBESI0, DBESI1, DBESJ0, DBESJ1, DBESK0,
C                    DBESK1, DBESKS, DBESY0, DBESY1, DBETA, DBETAI, DBI,
C                    DBIE, DBINOM, DBSI0E, DBSI1E, DBSK0E, DBSK1E,
C                    DBSKES, DCBRT, DCHU, DCOSDG, DCOT, DDAWS, DE1, DEI,
C                    DERF, DEXPRL, DFAC, DGAMI, DGAMIC, DGAMIT, DGAMMA,
C                    DGAMR, DLI, DLNREL, DPOCH, DPOCH1, DPSI, DSINDG,
C                    DSPENC
C***REVISION HISTORY  (YYMMDD)
C   800801  DATE WRITTEN
C   891115  REVISION DATE from Version 3.2
C   891120  Checks of remainder of FNLIB routines added and code
C           reorganized.  (WRB)
C   900330  Prologue converted to Version 4.0 format.  (BAB)
C   900727  Added EXTERNAL statement.  (WRB)
C***END PROLOGUE  DFNCK
      INTEGER I,LUN,KPRINT,IPASS
      DOUBLE PRECISION D1MACH,
     +                 Y(105),V(105),ERRMAX,ERRTOL,ABSERR,RELERR,
     +                 D9ATN1,D9LN2R,DACOSH,DAI,DAIE,DASINH,DATANH,
     +                 DBESI0,DBESI1,DBESJ0,DBESJ1,DBESK0,DBESK1,
     +                 DBESY0,DBESY1,DBETA,DBETAI,DBI,DBIE,DBINOM,
     +                 DBSI0E,DBSI1E,DBSK0E,DBSK1E,DCBRT,DCHU,DCOSDG,
     +                 DCOT,DDAWS,DE1,DEI,DERF,DEXPRL,DFAC,DGAMI,DGAMIC,
     +                 DGAMIT,DGAMMA,DGAMR,DLI,DLNREL,DPOCH,DPOCH1,DPSI,
     +                 DSINDG,DSPENC
      EXTERNAL DCOT, DERF, DGAMMA
C
C     Correct values through different calculations are stored in V(*)
C
      DATA V(  1) / .8344518000 0000000000 0000000000 D+09/
      DATA V(  2) / .2250829575 1200000000 0000000000 D+13/
      DATA V(  3) / .1307674368 0000000000 0000000000 D+13/
      DATA V(  4) / .8222838654 1779228177 2556288000 D+34/
      DATA V(  5) /-.2000000000 0000000000 0000000000 D+01/
      DATA V(  6) / .9983407900 0000000000 0000000000 D+02/
      DATA V(  7) / .8660254037 8443864676 3723170753 D+00/
      DATA V(  8) /-.7071067811 8654752440 0844362105 D+00/
      DATA V(  9) / .6420926159 3433070300 6419986594 D+00/
      DATA V( 10) /-.1830487721 7124519192 6801943897 D+01/
      DATA V( 11) /-.2908191279 9355107028 5950148310 D+00/
      DATA V( 12) /-.1116064102 7573868712 2866817478 D+00/
      DATA V( 13) / .5000000000 0000000000 0000000000 D+00/
      DATA V( 14) / .7071067811 8654752440 0844362105 D+00/
      DATA V( 15) / .1371498381 4723363824 3285631505 D+00/
      DATA V( 16) /-.1000000500 0003333335 8333416027 D-05/
      DATA V( 17) / .1001251042 3180339898 4880296644 D+01/
      DATA V( 18) / .9950166250 8319464260 9402280122 D+00/
      DATA V( 19) / .2437208648 6531505582 4104923715 D+00/
      DATA V( 20) / .1931471805 5994530941 7232121458 D+00/
      DATA V( 21) / .1111122222 3333344444 0000000000 D+00/
      DATA V( 22) / .3141592653 5900000000 0000000000 D+01/
      DATA V( 23) / .9983407900 0000000000 0000000000 D-01/
      DATA V( 24) /-.1194763217 0000000000 0000000000 D+01/
      DATA V( 25) /-.1111122222 3333344444 0000000000 D+00/
      DATA V( 26) / .2646652412 0000000000 0000000000 D+01/
      DATA V( 27) /-.3786710430 6108797672 7207184637 D+00/
      DATA V( 28) / .1045163780 1174927848 4458888919 D+01/
      DATA V( 29) / .5597735947 7616081174 6795939295 D+00/
      DATA V( 30) / .1000195824 0663265190 1909339800 D+00/
      DATA V( 31) / .4542199048 6317357992 0523812663 D+00/
      DATA V( 32) / .1895117816 3559367554 6652093433 D+01/
      DATA V( 33) / .5822405264 6501250590 2656320160 D+00/
      DATA V( 34) / .1644934066 8482264364 7241516665 D+01/
      DATA V( 35) / .8862269254 5275801364 9083741687 D+00/
      DATA V( 36) /-.3141592653 5897932384 6264338328 D+01/
      DATA V( 37) / .3183098861 8379067153 7767526733 D+00/
      DATA V( 38) / .8823957200 2038009055 0940262394 D-06/
      DATA V( 39) /-.2820947917 7387814347 4039725759 D+00/
      DATA V( 40) / .1875000000 0000000000 0000000000 D+01/
      DATA V( 41) / .5135166683 8205029558 4635612122 D-01/
      DATA V( 42) / .5987500000 0000000000 0000000000 D+02/
      DATA V( 43) / .1570796326 7948966192 3132169164 D+01/
      DATA V( 44) / .7550061690 3746404275 1871235437 D-03/
      DATA V( 45) / .4227843350 9846713939 3487909918 D+00/
      DATA V( 46) / .2303001034 2976863752 7259355045 D+01/
      DATA V( 47) / .9998566182 6372370688 5830759463 D+00/
      DATA V( 48) / .8882907071 8395673587 8281870759 D+00/
      DATA V( 49) / .1353352832 3661269189 3999494971 D+00/
      DATA V( 50) / .3469303062 9580145617 0933128256 D-03/
      DATA V( 51) / .7869386805 7473315279 2400930048 D+00/
      DATA V( 52) / .6316733917 7525812329 1222663623 D-01/
      DATA V( 53) / .3812815664 6177091614 9261183171 D+00/
      DATA V( 54) / .2656250000 0000000000 0000000000 D+00/
      DATA V( 55) / .5204998778 1304653768 2746653770 D+00/
      DATA V( 56) / .8883882317 0170776406 9578446749 D+00/
      DATA V( 57) / .4244363835 0202229593 4042352455 D+00/
      DATA V( 58) / .3370006597 4209342338 3019719632 D+00/
      DATA V( 59) /-.1775967713 1433830434 7397013056 D+00/
      DATA V( 60) / .2238907791 4123566805 1827454628 D+00/
      DATA V( 61) /-.3275791375 9146522203 7734321812 D+00/
      DATA V( 62) / .5767248077 5687338720 2448242187 D+00/
      DATA V( 63) / .5103756726 4974511959 6606592612 D+00/
      DATA V( 64) /-.3085176252 4903378007 3648984210 D+00/
      DATA V( 65) / .1478631433 9122684480 1050675510 D+00/
      DATA V( 66) /-.1070324315 4093754688 8370772230 D+00/
      DATA V( 67) / .2279585302 3360672674 3720444020 D+01/
      DATA V( 68) / .2723987182 3604446894 5442320700 D+02/
      DATA V( 69) / .1590636854 6373290633 8225442450 D+01/
      DATA V( 70) / .2433564214 2450527199 1430504400 D+02/
      DATA V( 71) / .1138938727 4953343565 2719574910 D+00/
      DATA V( 72) / .3691098334 0425942747 3526100740 D-02/
      DATA V( 73) / .1398658818 1652242728 4598806997 D+00/
      DATA V( 74) / .4044613445 4521642083 6502183700 D-02/
      DATA V( 75) / .3085083225 5367103953 3384319255 D+00/
      DATA V( 76) / .1835408126 0932835307 3650751820 D+00/
      DATA V( 77) / .1639722669 4454235692 6122903850 D+00/
      DATA V( 78) / .2152692892 4893765915 8505143243 D+00/
      DATA V( 79) / .8415682150 7077141791 9124867127 D+00/
      DATA V( 80) / .5478075643 1351898686 8201568700 D+00/
      DATA V( 81) / .6002738587 8831258293 6045656600 D+00/
      DATA V( 82) / .1033476847 0686885731 7535710603 D+01/
      DATA V( 83) / .8862269254 5275801364 9083741000 D+00/
      DATA V( 84) / .1329340388 1791370204 7362561200 D+01/
      DATA V( 85) / .2880237507 7214635443 5952215970 D+01/
      DATA V( 86) / .5604991216 3979286993 1128243359 D+00/
      DATA V( 87) / .6725989459 6775144391 7353892000 D+00/
      DATA V( 88) / .9640584892 2044373628 1540578570 D+00/
      DATA V( 89) / .4610685044 4789455843 9575873876 D+00/
      DATA V( 90) / .9221370088 9578911687 9151747751 D+00/
      DATA V( 91) / .2316936064 8083348976 9125254500 D+00/
      DATA V( 92) / .1572592338 0470489995 2660465400 D-01/
      DATA V( 93) / .2932771591 2994736245 0897433147 D+00/
      DATA V( 94) / .2193222051 2871206086 2850888400 D+00/
      DATA V( 95) / .8542770431 0315549330 0048798776 D+00/
      DATA V( 96) / .1878941503 7478950009 0933504950 D+01/
      DATA V( 97) / .6748924111 1563021286 5414309867 D+00/
      DATA V( 98) / .4647504801 9609251501 9775411670 D+00/
      DATA V( 99) / .2499999999 9999999999 9999999880 D+00/
      DATA V(100) / .7350086093 0037774536 9706799000 D+00/
      DATA V(101) / .4069617876 5067297974 2685260000 D+00/
      DATA V(102) / .4482566692 9158295391 6931735480 D+00/
      DATA V(103) / .5963473623 2319407434 1078499290 D+00/
      DATA V(104) / .7573420861 2217595345 4414369190 D+00/
      DATA V(105) / .7578721561 4131210604 3351240000 D+00/
C***FIRST EXECUTABLE STATEMENT  DFNCK
C
C     Compute functional values
C
C     Exercise routines in Category C1.
C
      Y(  1) = DBINOM(35,12)
      Y(  2) = DBINOM(50,15)
      Y(  3) = DFAC(15)
      Y(  4) = DFAC(31)
C
C     Exercise routines in Category C2
C
      Y(  5) = DCBRT(-8.D0)
      Y(  6) = DCBRT(.9950306243 6570396447 5039000000 D6)
C
C     Exercise routines in Category C4A.
C
      Y(  7) = DCOSDG(30.D0)
      Y(  8) = DCOSDG(135.D0)
      Y(  9) = DCOT(1.D0)
      Y( 10) = DCOT(-.5D0)
      Y( 11) = D9ATN1(.5D0)
      Y( 12) = D9ATN1(2.D0)
      Y( 13) = DSINDG(30.D0)
      Y( 14) = DSINDG(135.D0)
C
C     Exercise routines in Category C4B.
C
      Y( 15) = DLNREL(.147D0)
      Y( 16) = DLNREL(-.1D-5)
      Y( 17) = DEXPRL(.25D-2)
      Y( 18) = DEXPRL(-.1D-1)
      Y( 19) = D9LN2R(.5D0)
      Y( 20) = D9LN2R(1.D0)
C
C     Exercise routines in Category C4C.
C
      Y( 21) = DACOSH(.1006179316 4909482374 7218929626 D1)
      Y( 22) = DACOSH(.1159195327 5523908462 8557897777 D2)
      Y( 23) = DASINH(.1000000001 0129514521 1538706587 D0)
      Y( 24) = DASINH(-.1499999999 4824063412 4264852207 D1)
      Y( 25) = DATANH(-.1106572080 4138399806 6515207788 D0)
      Y( 26) = DATANH(.9899999999 9279130066 3084082410 D0)
C
C     Exercise routines in Category C5.
C
      Y( 27) = DLI(.5D0)
      Y( 28) = DLI(2.D0)
      Y( 29) = DE1(.5D0)
      Y( 30) = DE1(1.5D0)
      Y( 31) = DEI(.5D0)
      Y( 32) = DEI(1.D0)
      Y( 33) = DSPENC(.5D0)
      Y( 34) = DSPENC(1.D0)
      Y( 35) = DGAMMA(1.5D0)
      Y( 36) = DGAMMA(-.5D0)*DGAMMA(1.5D0)
      Y( 37) = DGAMR(-1.5D0)*DGAMR(2.5D0)
      Y( 38) = DGAMR(10.5D0)
C
C     Exercise routines in Category C7A.
C
      Y( 39) = DPOCH(-.5D0,1.5D0)
      Y( 40) = DPOCH(.5D0,3.D0)
      Y( 41) = DPOCH1(.5D0,2.5D0)
      Y( 42) = DPOCH1(10.5D0,2.D0)
C
C     Exercise routines in Category C7B.
C
      Y( 43) = DBETA(.5D0,1.5D0)
      Y( 44) = DBETA(5.5D0,5.5D0)
C
C     Exercise routines in Category C7C.
C
      Y( 45) = DPSI(2.D0)
      Y( 46) = DPSI(10.5D0)
C
C     Exercise routines in Category C7E.
C
      Y( 47) = DGAMI(1.D0,8.85D0)
      Y( 48) = DGAMI(2.D0,3.75D0)
      Y( 49) = DGAMIC(1.D0,2.D0)
      Y( 50) = DGAMIC(2.D0,10.4D0)
      Y( 51) = DGAMIT(1.D0,.5D0)
      Y( 52) = DGAMIT(2.D0,3.75D0)
C
C     Exercise routines in Category C7F.
C
      Y( 53) = DBETAI(.5D0,2.D0,1.5D0)
      Y( 54) = DBETAI(.25D0,1.5D0,2.D0)
C
C     Exercise routines in Category C8A.
C
      Y( 55) = DERF(.5D0)
      Y( 56) = DERF(1.125D0)
C
C     Exercise routines in Category C8C.
C
      Y( 57) = DDAWS(.5D0)
      Y( 58) = DDAWS(1.84D0)
C
C     Exercise routines in Category C10A1.
C
      Y( 59) = DBESJ0(5.D0)
      Y( 60) = DBESJ0(2.D0)
      Y( 61) = DBESJ1(5.D0)
      Y( 62) = DBESJ1(2.D0)
      Y( 63) = DBESY0(2.D0)
      Y( 64) = DBESY0(5.D0)
      Y( 65) = DBESY1(5.D0)
      Y( 66) = DBESY1(2.D0)
C
C     Exercise routines in Category C10B1.
C
      Y( 67) = DBESI0(2.D0)
      Y( 68) = DBESI0(5.D0)
      Y( 69) = DBESI1(2.D0)
      Y( 70) = DBESI1(5.D0)
      Y( 71) = DBESK0(2.D0)
      Y( 72) = DBESK0(5.D0)
      Y( 73) = DBESK1(2.D0)
      Y( 74) = DBESK1(5.D0)
      Y( 75) = DBSI0E(2.D0)
      Y( 76) = DBSI0E(5.D0)
      Y( 77) = DBSI1E(5.D0)
      Y( 78) = DBSI1E(2.D0)
      Y( 79) = DBSK0E(2.D0)
      Y( 80) = DBSK0E(5.D0)
      Y( 81) = DBSK1E(5.D0)
      Y( 82) = DBSK1E(2.D0)
C
C     Exercise routines in Category C10B3.
C
      CALL DBSKES(.5D0,2.D0,3,Y(83))
      CALL DBSKES(.5D0,5.D0,3,Y(86))
      CALL DBESKS(.5D0,1.D0,2,Y(89))
C
C     Exercise routines in Category C10D.
C
      Y( 91) = DAI(.5D0)
      Y( 92) = DAI(2.5D0)
      Y( 93) = DAIE(.5D0)
      Y( 94) = DAIE(2.5D0)
      Y( 95) = DBI(.5D0)
      Y( 96) = DBI(1.5D0)
      Y( 97) = DBIE(.5D0)
      Y( 98) = DBIE(2.5D0)
C
C     Exercise routines in Category C11.
C
      Y( 99) = DCHU(1.D0,2.D0,4.D0)
      Y(100) = DCHU(5.D0/6.D0,5.D0/3.D0,4.D0/3.D0)
      Y(101) = DCHU(.75D0,.75D0,2.5D0)
      Y(102) = DCHU(1.D0,1.D0,1.5D0)
      Y(103) = DCHU(1.D0,1.D0,1.D0)
      Y(104) = DCHU(1.D0,1.D0,-LOG(.5D0))
      Y(105) = DCHU(.5D0,.5D0,1.D0)
C
C   Check for possible errors
C
      ERRMAX = D1MACH(4)
      ERRTOL = SQRT(ERRMAX)
      DO 10 I = 1,105
        ABSERR = ABS(V(I)-Y(I))
        RELERR = ABSERR/ABS(V(I))
        ERRMAX = MAX(RELERR,ERRMAX)
        IF (RELERR.GT.ERRTOL .AND. KPRINT.GE.2)
     +      WRITE (LUN,620) I,RELERR,ABSERR
   10 CONTINUE
      IPASS = 0
      IF (ERRMAX.LE.ERRTOL) IPASS = 1
      IF (IPASS.NE.0 .AND. KPRINT.GE.2) WRITE (LUN,610)
      RETURN
  610 FORMAT (' Double precision Fullerton special function ',
     +        ' routines o.k.')
  620 FORMAT (' For I  = ', I3, '  test fails with RELERR  = ',
     +        D38.30, '  and ABSERR  = ', D38.30)
      END
