/* role.h */
/* Kevin Hugo, 1998 */

#ifndef ROLE_H
#define ROLE_H

/*** Included files ***/

#ifndef ATTRIB_H
#include "attrib.h"
#endif



/*** Structure to define names when different for male and female ***/
struct RoleName {
	char	*m;					/* If character is male */
	char	*f;					/* If character is female; null when same */
};



/*** Unified structure containing role information ***/
struct Role {
	/*** Strings that name various things ***/
	struct RoleName	name;		/* The role's name (from u_init.c) */
	struct RoleName rank[9];	/* Names for experience levels (from botl.c) */
	char	*lgod, *ngod, *cgod;/* God names (from pray.c) */
	char	*filename;			/* Abbreviation for use in file names */
	char	*homebase;			/* Quest leader's location (from questpgr.c) */
	char	*intermed;			/* Quest intermediate goal (from questpgr.c) */

	/*** Indices of important monsters and objects ***/
    short	malenum,		/* Index (PM_) as a male monster (botl.c) */
    		femalenum,		/* ...or as a female monster (0 == same) */
			petnum,			/* Index of preferred pet (PM_, 0 == random) */
			ldrnum,         /* Index (PM_) of quest leader (questpgr.c) */
			guardnum,		/* Index (PM_) of quest guardians (questpgr.c) */
			neminum,		/* Index (PM_) of quest nemesis (questpgr.c) */
			enemy1num,		/* Specific quest enemies (PM_, 0 == random) */
			enemy2num;
	char	enemy1sym,		/* Quest enemies by class (S_) */
			enemy2sym;
	short	gift1arti,		/* Index (ART_) of first artifact gift */
			gift2arti,		/* Index (ART_) of second artifact gift */
			questarti;		/* Index (ART_) of quest artifact (questpgr.c) */

	/*** Flags ***/
	short	allow;				/* Bit mask of allowed variations */
#define ROLE_GENDMASK	0xf0	/*	Allowable genders */
#define ROLE_MALE		0x10
#define ROLE_FEMALE		0x20
#define ROLE_NEUTER		0x40
#define ROLE_ALGNMASK	AM_MASK	/*	Allowable alignments */
#define ROLE_LAWFUL		AM_LAWFUL
#define ROLE_NEUTRAL	AM_NEUTRAL
#define ROLE_CHAOTIC	AM_CHAOTIC

	/*** Attributes (from attrib.c) ***/
	xchar	attrbase[A_MAX];	/* Lowest initial attributes */
	xchar	attrdist[A_MAX];	/* Distribution of initial attributes */
	xchar	attrmax[A_MAX];		/* Maximum allowable attributes */
	schar   shp, hd, xlev, ndx;
	/* According to AD&D, HD for some classes (ex. Wizard) should be smaller
	 * (4-sided for wizards).  But this is not AD&D, and using the AD&D
	 * rule here produces an unplayable character.  Thus I have used a minimum
	 * of an 10-sided hit die for everything.  Another AD&D change: wizards get
	 * a minimum strength of 4 since without one you can't teleport or cast
	 * spells. --KAA
	 */
	/* As the wizard has been updated (wizard patch 5 jun '96) their HD can be
	 * brought closer into line with AD&D. This forces wizards to use magic more
	 * and distance themselves from their attackers. --LSZ
	 */ 

	/*** Spell statistics (from spell.c) ***/
	int		spelbase;			/* Base spellcasting ability */
	int		spelheal;			/* Penalty (-bonus) for healing spells */
	int		spelshld;			/* Penalty for wearing any shield */
	int		spelarmr;			/* Penalty for wearing metal armour */
	int		spelstat;			/* Which stat (A_) is used */
	int		spelspec;			/* Spell (SPE_) the class excels at */
	int		spelsbon;			/* Penalty (-bonus) for that spell */

	/*** Properties in variable-length arrays ***/
	/* Intrinsics (see attrib.c) */
	/* Initial inventory (see u_init.c) */
	/* Skills (see u_init.c) */
	/* Techniques (see tech.c) */

	/*** Don't forget to add... ***/
	/* Quest leader, guardians, nemesis (monst.c) */
	/* Quest artifact (artilist.h) */
	/* Quest dungeon definition (dat/Xyz.dat) */
	/* Quest text (dat/quest.txt) */
	/* Dictionary entries (dat/data.bas) */
};

extern const struct Role roles[];	/* Table of available roles */
#define Role_if(X)	(urole.malenum == (X))
#define Role_switch	(urole.malenum)

/* Race-related stuff */
#define Race_elven	(Role_if(PM_ELF) || Role_if(PM_DROW))
#ifdef DWARF
# define Race_human	(!Role_if(PM_ELF) && !Role_if(PM_DROW) && !Role_if(PM_HOBBIT) && \
					 !Role_if(PM_DWARF) && !Role_if(PM_GNOME))
# define Race_yours(ptr) \
					(Race_elven ? is_elf(ptr) : \
					 Role_if(PM_DWARF) ? is_dwarf(ptr) : \
					 Role_if(PM_HOBBIT) ? (ptr) == &mons[PM_HOBBIT] : \
					 Role_if(PM_GNOME) ? is_gnome(ptr) : is_human(ptr))
#else
# define Race_human	(!Role_if(PM_ELF) && !Role_if(PM_DROW) && \
					 !Role_if(PM_HOBBIT) && !Role_if(PM_GNOME))
# define Race_yours(ptr) \
					(Race_elven ? is_elf(ptr) : \
					 Role_if(PM_HOBBIT) ? (ptr) == &mons[PM_HOBBIT] : \
					 Role_if(PM_GNOME) ? is_gnome(ptr) : is_human(ptr))
#endif

/* Obsolete stuff */
extern const char pl_classes[];		/* String with each letter as a role */
/*#define Role_is(X) (u.role == X)*/



/*** Unified structure specifying gender information ***/
struct Gender {
	char	*adj;				/* male/female/neuter */
	char	*he;				/* he/she/it */
	char	*him;				/* him/her/it */
	char	*his;				/* his/her/its */
	short	allow;				/* Equivalent ROLE_ mask */
};
#define ROLE_GENDERS	2		/* Number of permitted player genders */
						/* Increment this to 3 if you allow neuter roles */

extern const struct Gender genders[];	/* Table of available genders */



/*** Unified structure specifying alignment information ***/
struct Align {
	char	*noun;				/* law/balance/chaos */
	char	*adj;				/* lawful/neutral/chaotic */
	short	allow;				/* Equivalent ROLE_ mask */
	short	value;				/* Equivalent A_ value */
};
#define ROLE_ALIGNS		3		/* Number of permitted player alignments */

extern const struct Align aligns[];	/* Table of available alignments */



#endif  /* ROLE_H */
