/*	SCCS Id: @(#)prop.h	3.2	92/11/01	*/
/* Copyright (c) 1989 Mike Threepoint				  */
/* NetHack may be freely redistributed.  See license for details. */

#ifndef PROP_H
#define PROP_H


/*** What the properties are ***/
#define FIRE_RES		1
#define COLD_RES		2
#define SLEEP_RES		3
#define DISINT_RES		4
#define SHOCK_RES		5
#define POISON_RES		6
#define ADORNED			7
#define REGENERATION		8
#define SEARCHING		9
#define SEE_INVIS		10
#define INVIS			11
#define TELEPORT		12
#define TELEPORT_CONTROL	13
#define POLYMORPH		14
#define POLYMORPH_CONTROL	15
#define LEVITATION		16
#define STEALTH			17
#define AGGRAVATE_MONSTER	18
#define CONFLICT		19
#define PROTECTION		20
#define PROT_FROM_SHAPE_CHANGERS 21
#define WARNING			22
#define TELEPAT			23
#define FAST			24
#define STUNNED			25
#define CONFUSION		26
#define SICK			27
#define BLINDED			28
#define SLEEPING		29
#define WOUNDED_LEGS		30
#define STONED			31
#define STRANGLED		32
#define HALLUC			33
#define HALLUC_RES		34
#define FUMBLING		35
#define JUMPING			36
#define WWALKING		37
#define HUNGER			38
#define GLIB			39
#define REFLECTING		40
#define LIFESAVED		41
#define ANTIMAGIC		42
#define DISPLACED		43
#define CLAIRVOYANT		44
#define VOMITING		45
#define ENERGY_REGENERATION	46
#define MAGICAL_BREATHING	47
#define HALF_SPDAM		48
#define HALF_PHDAM		49
#define SICK_RES		50
#define DRAIN_RES		51
#define WARN_UNDEAD		52
#define INVULNERABLE	53
#define FREE_ACTION		54
#define SWIMMING		55
#define SLIMED			56
/* KMH, balance patch -- for new items */
#define FIXED_ABIL		57
#define FLYING			58
#define ACID_RES		59
#define STONE_RES		60
#define UNCHANGING		61
#define PASSES_WALLS	62
#define INDIGESTION		63

#define LAST_PROP		(INDIGESTION)	/* the last property */


/*** Where the properties come from ***/
/* Definitions were moved here from obj.h and you.h */
struct prop {
	/*** Properties conveyed by objects ***/
	long extrinsic;
	/* Armor */
#	define W_ARM        0x00001000L	/* Body armor */
#	define W_ARMC       0x00002000L	/* Cloak */
#	define W_ARMH       0x00004000L	/* Helmet/hat */
#	define W_ARMS       0x00008000L	/* Shield */
#	define W_ARMG       0x00010000L	/* Gloves/gauntlets */
#	define W_ARMF       0x00020000L	/* Footwear */
#ifdef TOURIST
#	define W_ARMU       0x00000200L	/* Undershirt */
#	define W_ARMOR	     (W_ARM | W_ARMC | W_ARMH | W_ARMS | W_ARMG | W_ARMF | W_ARMU)
#else
#	define W_ARMOR	     (W_ARM | W_ARMC | W_ARMH | W_ARMS | W_ARMG | W_ARMF)
#endif
	/* Weapons and artifacts */
#	define W_WEP        0x00040000L	/* Wielded weapon */
#	define W_QUIVER     0x00080000L	/* Quiver for (f)iring ammo */
#	define W_SWAPWEP    0x00100000L	/* Secondary weapon */
#	define W_ART        0x00200000L	/* _Carrying_ artifact, not really worn */
#	define W_ARTI       0x00400000L	/* Invoked artifact, not really worn */
	/* Amulets, rings, tools, and other items */
#	define W_AMUL       0x00800000L	/* Amulet */
#	define W_RINGL      0x01000000L	/* Left ring */
#	define W_RINGR      0x02000000L	/* Right ring */
#	define W_RING       (W_RINGL | W_RINGR)
#	define W_TOOL       0x04000000L	/* Eyewear */
#ifdef YEOMAN
#	define W_SADDLE     0x08000000	/* KMH -- For riding monsters */
#endif
#	define W_BALL       0x00000400L	/* Punishment ball */
#	define W_CHAIN      0x00000800L	/* Punishment chain */

	/*** Property is blocked by an object ***/
	long blocked;					/* Same assignments as extrinsic */
/*#	define I_BLOCKED    0x80000000L	/* Property is blocked OBSOLETE */

	/*** Timeouts, permanent properties, and other flags ***/
	long intrinsic;
	/* Timed properties */
#	define TIMEOUT      0x00ffffffL	/* Up to 16 million turns */
	/* Permanent properties */
#	define FROMEXPER    0x20000000L	/* Gained and lost with experience levels */
#	define FROMOUTSIDE  0x10000000L	/* By corpses, prayer, thrones, etc. */
#	define INTRINSIC    (FROMOUTSIDE|FROMEXPER)
	/* Control flags */
#	define I_SPECIAL    0x40000000L	/* Property is controllable */
};


/*** Definitions for backwards compatibility ***/
#define LEFT_RING	W_RINGL
#define RIGHT_RING	W_RINGR
#define LEFT_SIDE	LEFT_RING
#define RIGHT_SIDE	RIGHT_RING
#define BOTH_SIDES	(LEFT_SIDE | RIGHT_SIDE)
#define WORN_ARMOR	W_ARM
#define WORN_CLOAK	W_ARMC
#define WORN_HELMET	W_ARMH
#define WORN_SHIELD	W_ARMS
#define WORN_GLOVES	W_ARMG
#define WORN_BOOTS	W_ARMF
#define WORN_AMUL	W_AMUL
#define WORN_BLINDF	W_TOOL
#ifdef TOURIST
#define WORN_SHIRT	W_ARMU
#endif


#endif /* PROP_H */
