/* # skkinput (Simple Kana-Kanji Input)
 * Kinput.h --- Public Header file for KinputWidget
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef Kinput_h
#define Kinput_h
#include "commondef.h"
#include "kanji.h"

#define XtNenableKinput1		"enableKinput1"
#define XtCEnableKinput1		"EnableKinput1"

typedef struct _KinputRec	*KinputWidget ;
typedef struct _KinputClassRec	*KinputWidgetClass ;

extern WidgetClass kinputWidgetClass ;

/*
 * Ѵ饤ȴ¤
 */
struct KinputClient {
  /* Ѥ*/
  int probe ;
  /*  XIM Ѥ롣XIM ǤϡѤͽ򤷤Ƥѳ *
   * ׵᤬롣ͽ󤷤ǲ빽򴹤餷*
   * 椫ɤ probe ͽ󤵤Ƥ뤫ɤ reserve *
   * KIP ǤϻȤʤȻפ reserve == probe */
  int reserve ;

  /* Ѵ饤ȤΥɥID */
  Window req_window ;
  Window focus_window ;
  /* Ѵ饤ȤؤϤåѤ륦ɥ */
  Window probe_window ;
  Window xevent_window ;
  /* kinput2 protocol Ѥ ATOM (..xim Ǥޤ餢 */
  /* ˤʤΤĤäȤʤ) */
  Atom property ;
  Atom target ;
  Atom selection ;
  unsigned long attribute_mask ;

  /* ̿ѤƤץȥ */
  int protocol ;
  int window_style ;
  int event_select ;

  /* ץȥ롦å */
  Widget protocol_widget ;
  /* ѴɽƤ륦å */
  Widget skkinput ;

  /* skkinput widget ѤƤե(ǥեȤΥե*
   * ȤǤϤʤ over-the-spot Ѵ饤Ȥ׵  *
   * äѰդեȤǤ롣*/
#if 1
  struct skkinputManagedFont	*fontset[ NUMBER_OF_CHARSET ] ;
#else
  XFontStruct	*fontset[ NUMBER_OF_CHARSET ] ;
#endif
  /* ɥ°⡼ɾ */
  int chat_adapter, eggnl ;

  /* Υ饤ȤؤΥݥ󥿡*/
  struct KinputClient *next ;
} ;

#endif
