/*
 * Copyright (c) 1994  Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * Author:  Makoto Ishisone, Software Research Associates, Inc., Japan
 */
#if !defined(imfuncs_h)
#define imfuncs_h

#include "imprtype.h"

/*
 * Functions to get/put data (defined in imdata.c)
 */
extern int IMGetC8 (IMConnection *conn, int offset ) ;
extern unsigned int IMGetC16 (IMConnection *conn, int offset ) ;
extern int IMGetI16 (IMConnection *conn, int offset ) ;
extern unsigned long IMGetC32 (IMConnection *conn, int offset ) ;
extern void IMGetString (IMConnection *conn,
			       int offset, char *buf, int len ) ;

extern void IMPutC8 (IMConnection *conn, int x ) ;
extern void IMPutC16 (IMConnection *conn, unsigned int x ) ;
extern void IMPutC32 (IMConnection *conn, unsigned long x ) ;
extern void IMPutI16 (IMConnection *conn, int x ) ;
extern void IMPutString( IMConnection *conn, unsigned char *s, int len ) ;
extern void IMPutPad (IMConnection *conn ) ;
extern void IMRewriteC16 (IMConnection *conn, int pos, unsigned int x ) ;

extern int IMWritePos (IMConnection *conn ) ;

extern int IMPutHeader (IMConnection *conn,
			     int major, int minor, int arglen ) ;
extern void IMFinishRequest (IMConnection *conn, int offset ) ;
extern void IMCancelRequest( IMConnection *conn, int offset ) ;
extern void IMSendSimpleRequest(IMConnection *conn, int major, int minor ) ;
extern void IMSendRequestWithIC
( IMConnection *conn, int major, int minor, IMIC *icp ) ;

extern void IMSendError (IMConnection *conn, int code,
			      unsigned int imid, unsigned int icid,
			      char *msg ) ;
extern void IMSendBadProtocol (IMConnection *conn, char *msg ) ;
extern void IMSendBadLength (IMConnection *conn,
				  unsigned int imid, unsigned int icid ) ;

/*
 * Transport layer functions (defined in imxport.c)
 */
extern int IMCreateTCPService (int *portp ) ;
extern IMConnection *IMTCPConnection (Widget protocol, int socket ) ;
extern int IMCreateUnixService (char *path ) ;
extern IMConnection *IMUnixConnection (Widget protocol, int socket ) ;
extern IMConnection *IMXConnection (Widget protocol, XEvent *ev ) ;
extern int IMFlush (IMConnection *conn ) ;
extern void IMShutdown (IMConnection *conn ) ;
extern void IMCloseConnection (IMConnection *conn ) ;

/*
 * Request dispatch functions (defined in imdispatch.c)
 */
extern void IMSetInitialDispatcher (IMConnection *conn ) ;
extern void IMDispatch (IMConnection *conn, int cond ) ;
extern void IMSchedule (IMConnection *conn, int type ) ;
extern void IMProcessQueue (Widget w ) ;

/*
 * Function to compile request dispatch table (defined in imrequest.c)
 */
extern void IMCompileReq (void ) ;

/*
 * Functions handling IM/IC creation/destruction/lookup (defined in imic.c)
 */
extern IMIM *IMGetIM (IMConnection *conn, int arglen ) ;
extern IMIC *IMGetIC (IMConnection *conn, int arglen ) ;
extern IMIM *IMCreateIM (IMConnection *conn, IMConverter *converter ) ;
extern IMIC *IMCreateIC (IMIM *imp ) ;
extern void IMDestroyIM (IMIM *imp ) ;
extern void IMDestroyIC (IMIC *imp ) ;

/*
 * Functions handling conversion start/stop/etc. (defined in imconv.c)
 */
extern int IMStartConversion (IMIC *icp ) ;
extern void IMStopConversion (IMIC *icp ) ;
extern int IMResetIC (IMIC *icp, char **preedit_strp ) ;
extern void IMForwardEvent (IMIC *icp, XEvent *ev ) ;
extern void IMSetFocus (IMIC *icp ) ;
extern void IMUnsetFocus (IMIC *icp ) ;

/*
 * Functions dealing with IM/IC attributes (defined in imattr.c)
 */
extern void IMPutIMAttrList (IMIM *imp ) ;
extern void IMPutICAttrList (IMIM *imp ) ;
extern int IMSetIMValues (IMIM *imp, char *data, int len, int major ) ;
extern int IMGetIMValues (IMIM *imp, char *data, int len, int offset ) ;
extern int IMSetICValues (IMIC *icp, char *data, int len, int major ) ;
extern int IMGetICValues (IMIC *icp, char *data, int len, int offset ) ;
extern void IMFillDefault (IMIC *icp,
				unsigned long common_mask,
				unsigned long preedit_mask,
				unsigned long status_mask ) ;
extern int IMValidateWindow
(Display *dpy, Window win, IMWindowProfile *profilep ) ;
extern int IMValidateICAttributes
(IMIC *icp, int checkonly ) ;
extern void IMFreeICAttributes
(IMIC *icp ) ;
extern unsigned long IMMakeConvAttributes 
(IMIC *icp, struct ConvAttrs *attr ) ;
extern void IMMoveLocation (IMIC *icp, int x, int y ) ;

/*
 * Functions interfacing imlib and IMProtocol widget (defined in improto.c)
 */
extern void IMRegisterConnection (IMConnection *conn ) ;
extern void IMUnregisterConnection (IMConnection *conn ) ;
extern IMConnection *IMConnectionList (Widget w ) ;
extern void IMPushQueue (IMConnection *conn ) ;
extern IMConnection *IMPopQueue (Widget w ) ;
extern int IMQueueEmpty (Widget w ) ;
extern Pixel IMDefaultForeground (Widget w ) ;
extern Pixel IMDefaultBackground (Widget w ) ;
extern char *IMDefaultFontSet( IMIM *imp ) ;
/*extern FontBank IMFontBank( IMIM *imp ) ;*/
extern int IMStatusWidth( Widget w ) ;
extern void IMInitHash( Widget w ) ;
extern IMIM **IMIMHash( Widget w ) ;
extern IMIC **IMICHash( Widget w ) ;
extern unsigned int IMNextIMID( Widget w ) ;
extern unsigned int IMNextICID( Widget w ) ;
extern Atom IMCtextAtom( Widget w ) ;
extern Atom IMKi2CommAtom( Widget w ) ;
extern Atom IMXConnectAtom( Widget w ) ;
extern Atom IMProtocolAtom( Widget w ) ;
extern Atom IMMoreDataAtom( Widget w ) ;
extern struct XrLikeKey *IMTriggerKeys(IMIM *imp, int *num_triggersp ) ; 
extern IMConverter *IMGetConverter( Widget w, char *locale ) ;

#endif /* _imfuncs_h */
