/* # skkinput (Simple Kana-Kanji Input)
 * SeparateWinP.h --- Separate Window Style
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef SeparateWinP_h
#define SeparateWinP_h

#include "commondef.h"
#include "buffers.h"
#include "skkbuf.h"
#include "skkkey.h"
#include "SeparateWin.h"
#include "HistMgr.h"
#include "FontMgr.h"
#include "attrs.h"
#include <X11/CoreP.h>

typedef struct {
  Pixel		puppixel ;	/* foreground pixel */
  /* fontset ̾ʸ󡣤Ĥ convert  fontset á
   * ळȤˤʤ롣 */
  String	fontset_string ;
  String	minibuf_fontset_string ;
  /* ѤƤեȡΤʤ */
  struct skkinputManagedFont	*fontset[ NUMBER_OF_CHARSET ] ;
  struct skkinputManagedFont	*minibuf_fontset[ NUMBER_OF_CHARSET ] ;
  /* ̤褹ΤѤ GC */
  GC		gc, rgc ;
  /* եȤξȴФƤΤϤɤΤǡ*/
  int		font_height, font_ascent ;
  /* 礭ʸȤϡʸ礭ˤ碌
   * 뤬줬̵äˤɤ٤ˤΤꡣ */
  int		cursor_width ;
  /* ȿžɽ뤫ݤ */
  Boolean	reverse_video ;
  Boolean	overthespotLikeInput ;
  /* Shift + Space Ĥ뤫ɤ*/
  Boolean	compatible_close_skkinputkey ;
  Boolean	clearMinibuffer ;
  Boolean	south_cursor ;

  Window	focus_window ;
  Window	client_window ;
  /* 饤ȤƤѿ*/
  struct ConvAttrsMesg *camsg ;

  /* */
  Widget	canvas, canvas_popup ;
  int		canvas_probe ;
  int		conversion_set_focus, conversion_unset_focus ;

  /* եäƤ뤫ɤ*/
  int		is_focus ;

  /* ʬѤХåե빽äƤ*/
  struct myChar pwrite_string[ TEXTBUFSIZE ] ;
  struct myChar pmtextbuffer[ TEXTBUFSIZE ] ;

  /* Callback Ĥʤ˰դġ*/
  XtCallbackList endcallback ;	/* Widget ˲ѡ*/
  XtCallbackList fixcallback ;	/* ѴʸΤѡ*/
  XtCallbackList keybackcallback ;	/* 򲡤᤹Τѡ*/

  /* μϤ˻Ȥѿ(ݥ)*/
  HistoryListNode *historyAttribute ;

  /* skkinput  buffer */
  struct skkinputBuffer	buffer ;
  unsigned long prev_modeline ;
} SeparateWinPart ;

/* դ뤤󤹤󤹡 */
typedef struct _SeparateWinRec {
  CorePart 		core ;
  SeparateWinPart	separateWin ;
} SeparateWinRec ;

/* New fields for the My widget class record */
typedef struct {
  int dummy ;
} SeparateWinClassPart ;

/* դ뤯餹 */
typedef struct _SeparateWinClassRec {
  CoreClassPart		core_class ;
  SeparateWinClassPart	separateWin_class ;
} SeparateWinClassRec ;

/* 餹ݤ󤿡 */
extern SeparateWinClassRec separateWinClassRec ;

/*
 * ¾ѿ( SeparateWin.c ͭ)
 */
static unsigned char *modelineFullStrings[] = {
  "--SKK:E.:--", "--E.:--", "--E.:--", "--E.:--",
} ;

/* νˤäư㤦⡼ɥ饤*/
static unsigned char *modelineDirtyStrings[] = {
  "--", "**", 
} ;

static unsigned char *majorModeStrings[] = {
  "(Fundamental", "(Chatadapter", 
} ;

static unsigned char *minorModeStrings[] = {
  ")--All-------------",
  " egg-nl)--All------",	/* 1 */
  " Ovspt)--All-------",	/* 2 */
  " Ovspt egg-nl)--All",
} ;


#endif
