/* # skkinput (Simple Kana-Kanji Input)
 * FontMgr.h --- Header for Font Manager 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef fontMgr_h
#define fontMgr_h

/* Free ȦΥեȤ򤳤äĤƤˤեȤΥ
 * ɤ빽ڤʤäƤ褦礭礭ɤ
 *  64 ٤ˤƤ롣*/
#define FONT_CACHE_SIZE		(12)

struct skkinputManagedFont {
  XFontStruct	*font ;			/* եȡ*/
  int		refer_count ;		/* ȤƤ*/
  char		*name ;			/* ̾*/
  struct skkinputManagedFont	*next ;
} ;

#if defined(fontMgr_Static)

/* ISO8859 charsetsä ISO8859-1  ASCII ɽˤȤ
 * Ƥޤ顣 */
static unsigned char *iso8859_1_fonts[] =
{ "*-iso8859-1", NULL, } ;
static unsigned char *iso8859_2_fonts[] =
{ "*-iso8859-2", NULL, } ;
static unsigned char *iso8859_3_fonts[] =
{ "*-iso8859-3", NULL, } ;
static unsigned char *iso8859_4_fonts[] =
{ "*-iso8859-4", NULL, } ;
static unsigned char *iso8859_5_fonts[] =
{ "*-iso8859-5", NULL, } ;
static unsigned char *iso8859_6_fonts[] =
{ "*-iso8859-6", NULL, } ;
static unsigned char *iso8859_7_fonts[] =
{ "*-iso8859-7", NULL, } ;
static unsigned char *iso8859_8_fonts[] =
{ "*-iso8859-8", NULL, } ;
static unsigned char *iso8859_9_fonts[] =
{ "*-iso8859-9", NULL, } ;
/* jisx0201-ROMAN/KATAKANA ΥեȤμ̤˻Ȥʸ*/
static unsigned char *jisx0201_1976_fonts[] = 
{ "*-jisx0201.1976-0", NULL } ;
/* jisx0208-1978 ΥեȤμ̤˻Ȥʸ*/
static unsigned char *jisx0208_1978_fonts[] = 
{ "*-jisc6226.1978-0", NULL } ;
/* jisx0208-1983 ΥեȤμ̤˻Ȥʸ*/
static unsigned char *jisx0208_1983_fonts[] = 
{ "*-jisx0208.1983-0", NULL } ;
/* jisx0212-1990 ΥեȤμ̤˻Ȥʸ*/
static unsigned char *jisx0212_1990_fonts[] =
{ "*-jisx0212.1990-0", NULL } ;
/* GB2312-1980 ΥեȤμ̤˻Ȥʸ*/
static unsigned char *gb2312_1980_fonts[] = 
{ "*-gb2312.1980-0", NULL } ;
/* KSC5601-1987 ΥեȤμ̤˻Ȥʸ*/
static unsigned char *ksc5601_1987_fonts[] = 
{ "*-ksc5601.1987-0", NULL } ;

/* եȤμ̤˻Ȥ*/
static unsigned char **fontset_identifiers[ MAX_CHARSET ] = {
  iso8859_1_fonts,
  iso8859_2_fonts,
  iso8859_3_fonts,
  iso8859_4_fonts,
  iso8859_5_fonts,
  iso8859_6_fonts,
  iso8859_7_fonts,
  iso8859_8_fonts,
  iso8859_9_fonts,
  jisx0201_1976_fonts,
  jisx0208_1978_fonts,
  jisx0208_1983_fonts,
  jisx0212_1990_fonts,
  gb2312_1980_fonts,
  ksc5601_1987_fonts,
} ;

#else

void fontMgr_FreeFont
( Display *disp, struct skkinputManagedFont *font ) ;
void fontMgr_PrepareFont
( Display *disp, struct skkinputManagedFont **fontset,
  int charset, unsigned char *exactname ) ;
void fontMgr_PrepareFontByName
( Display *disp, struct skkinputManagedFont **fontset,
  unsigned char *string ) ;
void fontMgr_PrepareFontByAtom
( Display *disp, struct skkinputManagedFont **fontset,
  Atom *fontatoms, Cardinal num_of_fonts ) ;
int fontMgr_GetFontSetInfo
( struct skkinputManagedFont **fontset,
  int *ret_height, int *ret_ascent ) ;
void fontMgr_CopyFontSet
( Display *disp, struct skkinputManagedFont **dest, 
  struct skkinputManagedFont **source ) ;

void fontMgr_initDefaultFontSet
( Display *disp, 
  unsigned char *defaultFontSetName,
  unsigned char *defaultMinibufFontsetName ) ;
void fontMgr_closeDefaultFontSet( Display *disp ) ;
void fontMgr_copyDefaultFontSet
( Display *disp, struct skkinputManagedFont **dest ) ;
void fontMgr_copyDefaultMinibufFontSet
( Display *disp, struct skkinputManagedFont **dest ) ;

#endif

#endif
