/* Public domain. */

#include "uint64.h"
#include "tai.h"
#include "caltimedate.h"

/* XXX: breaks tai encapsulation */

void caltime_utc (struct caltime *ct, struct tai const *t, int *pwday, int *pyday)
{
  /* XXX: check for overflow? */
  struct tai t2 = *t ;
  int leap = leapsecs_sub(&t2) ;
  uint64 u = t2.x + 58486UL ;
  unsigned long s = u % 86400UL ;

  ct->second = (s % 60) + leap ; s /= 60 ;
  ct->minute = s % 60 ; s /= 60 ;
  ct->hour = s ;

  u /= 86400UL ;
  caldate_frommjd(&ct->date, /*XXX*/(long) (u - 53375995543064ULL), pwday, pyday) ;
  ct->offset = 0 ;
}
