#===========================================================================

package Sitescooper::HTTPClient;

require Exporter;
use Carp;
use IO::Handle;
use IO::Select;

@ISA = qw(Exporter);
@EXPORT= qw();
$VERSION = "0.1";
sub Version { $VERSION; }

use strict;

sub new {
  my ($class, $scoop) = @_; $class = ref($class) || $class;
  my $self = { };
  $self->{scoop} = $scoop;
  bless ($self, $class);
  $self;
}

sub init {
  my ($self) = @_;
  croak ("HTTPClient::init called on base class");
}

sub get_max_active_requests {
  my ($self) = @_;
  croak ("HTTPClient::get_max_active_requests called on base class");
}

sub can_preload {
  my ($self) = @_;
  0;
} 

sub start_get {
  my ($self, $url, $lastmod, $is_dynamic) = @_;
  croak ("HTTPClient::start_get called on base class");
  undef;
}

# get the filehandle we're waiting for, for purposes of select().
# return undef if the output is ready anyway, and there's no fh.
sub get_waiting_fh {
  my ($self, $state) = @_;
  croak ("HTTPClient::get_fd called on base class");
}

sub ready_to_finish {
  my ($self, $state) = @_;
  croak ("HTTPClient::ready_to_finish called on base class");
}

sub finish_get {
  my ($self, $state) = @_;
  croak ("HTTPClient::finish_get called on base class");
}

1;

#===========================================================================
# a state object that HTTPRequest methods can create and return;
# used to store their state if needed.

package Sitescooper::HTTPRequestState;

@Sitescooper::HTTPRequestState::ISA = qw(Exporter);
@Sitescooper::HTTPRequestState::EXPORT= qw();

use strict;

sub new {
  my $class = shift; $class = ref($class) || $class;
  my $self = { };
  bless ($self, $class);
  $self;
}

1;
