# coding: utf-8
=begin

 * Name: SiSU

 * Description: extract and print an XML rendition of document structure to screen

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, processing

=end
module SiSU_XML_scaffold
  require "#{SiSU_lib}/particulars"                        # particulars.rb
    include SiSU_Particulars
  require "#{SiSU_lib}/dal"                                # dal.rb
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
    include SiSU_Env
  pwd=Dir.pwd
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
      @sp='  '
    end
    def read
      begin
        @md,@dal_array=@particulars.md,@particulars.dal_array
        SiSU_XML_scaffold::Source::Scroll.new(@dal_array,@md).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      def initialize(data='',md='')
        @data,@md=data,md
        @sp='  '
      end
      def songsheet
        @t='sisu'
        @s=['0',
          'A',
          'B',
          'C',
          '1',
          '2',
          '3'
        ]
        #@t='docbook'         #@t='fictionbook'
        #@s=['book',          #@s=['body',
        #  'part',            #  'section',
        #  'subpart N/A',     #  'section',
        #  'sub-subpart N/A', #  'section',
        #  'chapter',         #  'section',
        #  'sect1',           #  'section',
        #  'sect2'            #  'section'
        #]                    #]
        data=@data
        structure_outline(data) if @md.cmd =~/V/
        structure_simple(data) if @md.cmd =~/V/
        structure_build(data)
      end
      def structure_outline(data)
        puts "\ninfo outline --->\n\n"
        data.each do |o|
          puts "#{o.ocn} #{o.ln} #{o.obj}" if o.is =~/^heading/
        end
      end
      def structure_simple(data)
        puts "\nheading outline --->\n\n"
        data.each_with_index do |o,i|
          if o.is =~ /^heading/; puts "<#{@s[o.ln]}>#{o.ocn} #{o.ln} #{o.obj}</#{@s[o.ln]}>"
          end
        end
      end
      def structure_build(data)
        puts "\nXML [#{@t} type] structure outline --->\n\n"
        h=[0,false,false,false]
        puts "<#{@s[0]}>"
        data.each_with_index do |o,i|
          if o.is =~/^heading/
            case o.ln
            when 1
              structure_build_tag_close(o.ln,h)
              puts "#{@sp*1}<#{@s[1]}>\n#{@sp*1}  #{o.ocn} #{o.ln} #{o.node}"
              h=[1,true,false,false]
            when 2
              structure_build_tag_close(o.ln,h)
              puts "#{@sp*2}<#{@s[2]}>\n#{@sp*2}  #{o.ocn} #{o.ln} #{o.node}"
              h=[2,true,true,false]
            when 3
              structure_build_tag_close(o.ln,h)
              puts "#{@sp*3}<#{@s[3]}>\n#{@sp*3}  #{o.ocn} #{o.ln} #{o.node}"
              h=[3,true,true,true]
            when 4
              structure_build_tag_close(o.ln,h)
              puts "#{@sp*4}<#{@s[4]}>\n#{@sp*4}  #{o.ocn} #{o.ln} #{o.node}"
              h[0]=4
            when 5
              structure_build_tag_close(o.ln,h)
              puts "#{@sp*5}<#{@s[5]}>\n#{@sp*5}  #{o.ocn} #{o.ln} #{o.node}"
              h[0]=5
            when 6
              structure_build_tag_close(o.ln,h)
              puts "#{@sp*6}<#{@s[6]}>\n#{@sp*6}  #{o.ocn} #{o.ln} #{o.node}"
              h[0]=6
            end
          end
        end
        structure_build_tag_close(0,h)
      end
      def structure_build_tag_close(lev,h)
        case h[0]
        when 1
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 2
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 3
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 4
          puts "#{@sp*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 5
          puts "#{@sp*5}</#{@s[5]}>" if (lev <= 5)
          puts "#{@sp*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 6
          puts "#{@sp*6}</#{@s[6]}>" if (lev <= 6)
          puts "#{@sp*5}</#{@s[5]}>" if (lev <= 5)
          puts "#{@sp*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{@sp*3}</#{@s[3]}>" if (lev <= 3) and h[3]
          puts "#{@sp*2}</#{@s[2]}>" if (lev <= 2) and h[2]
          puts "#{@sp*1}</#{@s[1]}>" if (lev <= 1) and h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        end
      end
    end
  end
end
__END__
