=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: SiSU information Structuring Universe, specialised pre-processing wrapper

 * NOTE wrapper makes little sense without additional components, additional sample files must be provided - (saved till later as may confuse)

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah mailto:ralph@amissah.com
   Ralph Amissah mailto:amissah@gmail.com

=end
require SiSU_lib + '/sysenv'
require SiSU_lib + '/param'
include SiSU_Param
@do,@done,@used,@html_output,@txt_input,@txt_output,@@report=Array.new(7){[]}
@@info=nil
@c=0
@cX=SiSU_Screen::Ansi.new('yes').cX 
@done << "\n#{@cX.blue_hi}#{@cX.black}Summary#{@cX.off*2}"
def talent(termsheet,flag)
  no_ocn='0' if flag =~/0/ #flag to request switch off of text object numbering
  @@info=nil
  @@info=termsheet.gsub(/(.+?)\.termsheet\.rb/,'../facility_data/\1.html')
  @env=SiSU_Env::Info_env.new
  @dir_fd="#{@env.path.output}/facility_data"
  Dir.mkdir(@dir_fd) unless FileTest.directory?(@dir_fd)==true
  html_output=[]
  case termsheet
  when /.+?\.(termsheet)\.rb$/
    @basename=termsheet[/(.+?)\.termsheet\.rb/, 1]
    @standard_form={}
    require termsheet
    include Termsheet
    @standard_form=Termsheet::StandardForms.new.standardforms
    puts %{\n#{@@cX.yellow_hi}#{@@cX.black}From#{@@cX.off*2}: #{@@cX.grey_hi}#{@@cX.black}#{@basename}.termsheet.rb#{@@cX.off*3}\n\n}
    @standard_form.each do |k,v|
      @c+=1
      require v
      puts %{\n#{@@cX.blue_hi}#{@@cX.black}Producing the following#{@@cX.off*2}: #{@@cX.green}#{@basename}.#{k}#{@@cX.off}\n\n}
      @done << %{\n\t#{@@cX.grey}Documents generated#{@@cX.off}: #{@@cX.cyan}#{@basename}.#{k}#{@@cX.off}\n}
      @used << %{\n\t#{@@cX.grey}Using#{@@cX.off}: #{@@cX.ruby}#{v}#{@@cX.off}\n}
      html_output=<<WOK
<br /><a href="../#{@basename}.#{k}/landscape.pdf">
<img border="0" width="18" height="15" src="../image/b_pdf.png" alt="pdf landscape"></a>&nbsp;
<a href="../#{@basename}.#{k}/portrait.pdf">
<img border="0" width="15" height="18" src="../image/b_pdf.png" alt="pdf portrait"></a>&nbsp;
<a href="../#{@basename}.#{k}/sisu_manifest.html">#{@basename}.#{k}.sisu_manifest.html</a>
WOK
      @html_output << html_output
      @txt_input << %{\n\tForm #@c: <url:#{Dir.pwd}/#{v}>\n\t        |#{Dir.pwd}/#{v}|@|^|\n}
      @txt_output << %{\n\t#{k}: |../#{@basename}.#{k}/sisu_manifest.html|@|^|\n}
      @report_file_i=File.new("#@dir_fd/#@basename.txt",'w+')
      @report_file_o=File.new("#@dir_fd/#@basename.html",'w+')
      @filename_new=File.new("#@basename.#{k}.sst",'w+')
      file_array=IO.readlines(v,"\n")
      @do << %{#{k}}
      @filename_new << @document
        # "require v" pulls in the composite @document 
        # "termsheet" having all the variables required to complete the standard form @document
      @filename_new.close
    end
    @do.each do |x|
      system %{sisu -Nhwpo #{@basename}.#{x}.sst\n}
    end
  else print "not processed --> ", termsheet, "\n"
  end
  @done << %{\n\t#{@@cX.green}Summary:#{@@cX.off} #{@@cX.blue}#{@env.path.output}/facility_data/#{@basename}.html#{@@cX.off}\n}
  @done << %{\n\t#{@@cX.grey}From details provided in#{@@cX.off}: #{@@cX.green}#{termsheet}#{@@cX.off}\n}
  terms=%{\nTermsheet: <url:#{Dir.pwd}/#{termsheet}>\n           |#{Dir.pwd}/#{termsheet}|@|^|\n}
  @report_file_i << "<url:all.txt>\n|all.txt|@|^|\n" << terms << "\nForms:\n" << @txt_input  << "\nOutput Files\n" << @txt_output
  @report_file_o << %{<a href="toc.html">^</a><br />\n} << @html_output
  @@report << @done << @used << "\n"
  @done,@used=[],[]
end
require SiSU_lib + '/param'
@argv=$*
@proc="#{@argv[0].to_s}"
if @proc =~  /^-?[wft]/
  @argv.shift
  @argv.each do |termsheet|
    talent(termsheet,@proc)
  end
end
@env=SiSU_Env::Info_env.new
@dir_fd="#{@env.path.output}/facility_data"
@url="#{@env.url.webserv}/facility_data"
@@report << %{\n#{@@cX.grey}See#{@@cX.off}: #{@@cX.blue}#@dir_fd/all.txt\t#@dir_fd/toc.html\t#@dir_fd/#{@@cX.off}\n\n#{@@cX.grey}See#{@@cX.off}: #{@@cX.blue}#@url/all.txt\t#@url/toc.html\t#@url/#{@@cX.off}\n\n}
puts @@report
File.unlink("#@dir_fd/all.txt") if FileTest.file?("#@dir_fd/all.txt")
File.unlink("#@dir_fd/toc.html") if FileTest.file?("#@dir_fd/toc.html")
summary_file=File.new("#@dir_fd/all.txt",'w+')
summary_html=File.new("#@dir_fd/toc.html",'w+')
ls_txt=%x{ls #@dir_fd/*.txt}
report_thlnk=[]
ls_txt.scan(/.+/)
ls_txt.each {|x| report_thlnk << x.gsub!(/#@dir_fd\/(.+)/,"<url:\\1>\n|\\1|@|^|")}
report_thlnk.join("\n")
ls_html=%x{ls #@dir_fd/*.html}
#NOTE is necessary to purge @dir_fd ~myout/faciliytData
report_html=[]
ls_html.split(/.+/)
ls_html.each {|x| report_html << x.gsub!(/#@dir_fd\/(.+)/,'<a href="\1">\1</a><br />')}
report_html.join("\n")
summary_file << "#{report_thlnk}"
summary_html << "#{report_html}"
__END__
sisu -t x_bank.and.*
e.g. sisu -t x_bank.and.*.termsheet.rb
e.g. sisu_termsheet.rb -t x_bank.and.c*.termsheet.rb
program calls upon termsheet file with extension termsheet.rb
termsheet.rb calls upon relevant standard form files (to be used) with extension .sForm.rb
there is also a standard_terms.rb file - with terms/details that are  constant
the file produced is named after the termsheet.rb with that extension replaced with .er30
from there scribbler.rb is called upon its usual metaVerse html and pdf  creation
! :-)
to test run
termsheet.rb -f dev.export.import.trade.facility.termsheet.rb
the term sheet calls the standard form or template that is to be run against it.
