=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: relaxng flow/logic

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_relaxng
  require SiSU_lib + '/sysenv'
  require SiSU_lib + '/color_hex_triplets'
  include SiSU_Hex_triplets
  class RelaxNG
    def gpl2_or_later
      @gpl2_or_later =<<RELAXNG
 #  Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 #  Author: Ralph Amissah
 #    http://www.jus.uio.no/sisu
 #    http://www.jus.uio.no/sisu/SiSU/download.html

 #  Description: sisu object models in relaxNG

 #  Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 #  License: GPL 2 or later

 # Summary of GPL 2

 # This program is free software; you can redistribute it and/or modify it
 # under the terms of the GNU General Public License as published by the Free
 # Software Foundation; either version 2 of the License, or (at your option)
 # any later version.

 # This program is distributed in the hope that it will be useful, but WITHOUT
 # ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 # FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 # more details.

 # You should have received a copy of the GNU General Public License along
 # with this program; if not, write to the Free Software Foundation, Inc.,
 # 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

 # If you have Internet connection, the latest version of the GPL should be
 # available at these locations:
 #   http://www.fsf.org/licenses/gpl.html
 #   http://www.gnu.org/copyleft/gpl.html
 #   http://www.jus.uio.no/sisu/gpl2.fsf

 # SiSU was first released to the public on January 4th 2005

 # SiSU uses:
 # 
 #   Standard SiSU markup syntax,
 #   Standard SiSU meta-markup syntax, and the
 #   Standard SiSU object citation numbering and system
 # 
 # © Ralph Amissah 1997, current 2006.
 # All Rights Reserved.

 #  Ralph Amissah: ralph@amissah.com
 #                 ralph.amissah@gmail.com
RELAXNG
    end
    def fn_dtd_sax
      'sisu_sax.dtd'
    end
    def fn_dtd_dom
      'sisu_dom.dtd'
    end
    def fn_dtd_xhtml
      'sisu_xhtml.dtd'
    end
    def rnc_sisu_object_input
      @relaxng =<<RELAXNG
#%% sisu object model: input
#{gpl2_or_later}
#%% definitions
# dublin core:
element-semantic =
  element semantic {
  # dublin core:
  element title { text }
  & element creator { text }?
  & element subject { text }?
  & element description { text }?
  & element publisher { text }?
  & element contributor { text }?
  & element date { text }?
  & element date.created { text }?
  & element date.issued { text }?
  & element date.available { text }?
  & element date.valid { text }?
  & element date.modified { text }?
  & element type { text }?
  & element format { text }?
  & element identifier { text }?
  & element source { text }?
  & element relation { text }?
  & element coverage { text }?
  & element rights { text }?
  & element keywords { text }?
  # extended semantic metadata:
  & attribute subtitle { text }?
  & attribute illustrator { text }?
  & attribute translator { text }?
  & attribute prepared_by { text }?
  & attribute digitized_by { text }?
  & attribute language { text }?
  & attribute language.original { text }?
  & attribute classify.pg { text }?
  & attribute classify.isbn { text }?
  & attribute classify.dewey { text }?
  & attribute classify.loc { text }?
  & attribute prefix.a { text }?
  & attribute prefix.b { text }?
  & attribute suffix { text }?
  & attribute comments { text }?
  & attribute abstract { text }?
  # & attribute information { text }?
  & attribute contact { text }?
  & attribute links { text }?
  }
element-processing =
  element processing {
  attribute structure { text }?
  & attribute level { text }?
  & attribute markup { text }?
  & attribute bold { text }?
  & attribute italics { text }?
  & attribute papersize { text }?
  & attribute vocabulary { text }?
  & element date_scheme { text }?
  & element date.issued.scheme { text }?
  & element date.available.scheme { text }?
  & element date.valid.scheme { text }?
  & element date.modified.scheme { text }?
  }?
element-head =
  element head {
    # processing instructions, and semantic data, distinguish?:
    element metadata {
      element title { text },
      element file { text },
      element generator { text },
      element-semantic,
      element-processing
    }+
  }
# body text/contents
# includes <b> <i> <u> <del> <ins> <indent1> <bullet> etc.
element-txt = 
  element txt {
    text*
    & element b { text }*
    & element i { text }*
    & element u { text }*
    & element ins { text }*
    & element del { text }*
  }
element-endnote =
  element endnote {
    element number { text },
    element note { element-txt }+
  }+
element-para =
  element para {
    # attribute paragraph_format { text },
    element-txt+
    & element-endnote?
  }
element-external_space =
  element external_space {
    # ignored by sisu, provide program needs
    element program {
      # e.g. kdissert
      element name { text },
      element xpos { text },
      element ypos { text },
      element font { text },
      element outline_color { text },
      element text_color { text },
      element comment { text }
    }*
  }*,
#%% structure
  element document {
    # document head:
    element-head,
    # document body:
    element body {
      # object, a unit of text, usually a paragraph with any associated endnotes
      element node {
        element structure {
          # structure document using either node:heading levels or node:heading relationships:
          # (i) sisu default uses node:heading levels (1-6 or A-C,1-3) to build document structure
          element level { text }?,
          # (ii) sisu alternatively could use node:heading relationship information to build document structure
          element node.id { text },
          element node.parent { text },
          element node.child { text }*
        },
        element node.objects {
          element object.heading {
            # nametag used only in headings, especially important for segmented html
            element nametag { text },
            element-para
          },
          element object.para {
            element-para
          }*
        }+,
        element-external_space
      }+
    }
  }
RELAXNG
    end
    def rnc_sisu_object_metaverse
      @relaxng =<<RELAXNG
#%% sisu object model: metaverse
#{gpl2_or_later}
#%% definitions
# dublin core:
element-semantic =
  element semantic {
  # dublin core:
  element title { text }
  & element creator { text }?
  & element subject { text }?
  & element description { text }?
  & element publisher { text }?
  & element contributor { text }?
  & element date { text }?
  & element date.created { text }?
  & element date.issued { text }?
  & element date.available { text }?
  & element date.valid { text }?
  & element date.modified { text }?
  & element type { text }?
  & element format { text }?
  & element identifier { text }?
  & element source { text }?
  & element relation { text }?
  & element coverage { text }?
  & element rights { text }?
  & element keywords { text }?
  # extended semantic metadata:
  & attribute subtitle { text }?
  & attribute illustrator { text }?
  & attribute translator { text }?
  & attribute prepared_by { text }?
  & attribute digitized_by { text }?
  & attribute language { text }?
  & attribute language.original { text }?
  & attribute classify.pg { text }?
  & attribute classify.isbn { text }?
  & attribute classify.dewey { text }?
  & attribute classify.loc { text }?
  & attribute prefix.a { text }?
  & attribute prefix.b { text }?
  & attribute suffix { text }?
  & attribute comments { text }?
  & attribute abstract { text }?
  # & attribute information { text }?
  & attribute contact { text }?
  & attribute links { text }?
  }
element-processing =
  element processing {
  attribute structure { text }?
  & attribute level { text }?
  & attribute markup { text }?
  & attribute bold { text }?
  & attribute italics { text }?
  & attribute papersize { text }?
  & attribute vocabulary { text }?
  & element date_scheme { text }?
  & element date.issued.scheme { text }?
  & element date.available.scheme { text }?
  & element date.valid.scheme { text }?
  & element date.modified.scheme { text }?
  }?
element-head =
  element head {
    # processing instructions, and semantic data, distinguish?:
    element metadata {
      element title { text },
      element file { text },
      element generator { text },
      element-semantic,
      element-processing
    }+
  }
# body text/contents
# includes <b> <i> <u> <del> <ins> <indent1> <bullet> etc.
element-txt = 
  element txt {
    text*
    & element b { text }*
    & element i { text }*
    & element u { text }*
    & element ins { text }*
    & element del { text }*
  }
element-checksum.endnote = element checksum.clean { text }
element-endnote =
  element endnote {
    element number { text },
    element note { element-txt }+,
    element-checksum.endnote
  }+
element-checksum.para =
  element checksum.para {
    element checksum.clean { text },
    element checksum.marked { text }
  }
element-para =
  element para {
    # attribute paragraph_format { text },
    element-txt+
    & element-endnote?
  }
element-object =
  element object {
    element-para,
    element-checksum.para
  }
# object citation number, unique sequential number for objects:
element-ocn = element ocn { text }
element-object_structure_summary =
  element-ocn,
  # type: heading level value 1 -6, or normal text
  element type { text },
  # type number: sequential number for designated type
  element type_number { text },
  # type category: sequential number for designated category, e.g. sequentially counting all headers
  element category_number { text }
element-external_space =
  element external_space {
    # ignored by sisu, provide program needs
    element program {
      # e.g. kdissert
      element name { text },
      element xpos { text },
      element ypos { text },
      element font { text },
      element outline_color { text },
      element text_color { text },
      element comment { text }
    }*
  }*,
#%% structure
  element document {
    # document head:
    element-head,
    # document body:
    element body {
      # object, a unit of text, usually a paragraph with any associated endnotes
      element node {
        element structure {
          # structure document using either node:heading levels or node:heading relationships:
          # (i) sisu default uses node:heading levels (1-6 or A-C,1-3) to build document structure
          element level { text }?,
          # (ii) sisu alternatively could use node:heading relationship information to build document structure
          element node.id { text },
          element node.parent { text },
          element node.child { text }*
        },
        element node.objects {
          element object.heading {
            element-object_structure_summary,
            # nametag used only in headings, especially important for segmented html
            element nametag { text },
            element-object
          },
          element object.para {
            element-object_structure_summary,
            element-object
          }*
        }+,
        element-external_space
      }+
    }
  }
RELAXNG
    end
    def rnc_sax
      @relaxng =<<RELAXNG
#%% sax model
# Author: Ralph@Amissah.com

#%% definitions

#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.

#%% structure
element document {
  #document head:
  element head {
    #dublin core:
    element dc {
      attribute class { text }
    }+
  },
  #document body:
  element body {
    #object, a unit of text, usually a paragraph with any associated endnotes
    element object {
      attribute number { text },
      element ocn { text },
      #body content/text, whether ordinary paragraph or heading:
      element text { 
        #attributes indicates whether ordinary text (norm) or heading, (levels h[1-6]):
        attribute class { text },
        text
      },
      #endnotes, zero or many:
      element endnote {
        attribute notenumber { text },
        #endnotes number:
        element number { text },
        #endnotes content/text:
        element note { text }
      }*
    }+
  }
}
RELAXNG
    end
    def rnc_dom
      @relaxng =<<RELAXNG
#%% dom model
#%% definitions
#dublin core:
element-dc =
  ( attribute title { text }
  #attribute subtitle { text }?
  & attribute creator { text }?
  & attribute subject { text }?
  & attribute description { text }?
  & attribute publisher { text }?
  & attribute contributor { text }?
  & attribute date { text }?
  & attribute datecreated { text }?
  & attribute dateissued { text }?
  & attribute dateavailable { text }?
  & attribute datevalid { text }?
  & attribute datemodified { text }?
  & attribute type { text }?
  & attribute format { text }?
  & attribute identifier { text }?
  & attribute source { text }?
  & attribute relation { text }?
  & attribute coverage { text }?
  & attribute rights { text }?
  & attribute keywords { text }? )
#element-paragraph = 
#  text
#  element b
#  element i
#  element u
#endnotes, zero or many, embedded in text:
element-endnote =
  element endnote {
    element number { text },
    element note { text }
  }*
#body text/contents
element-text =
  element mytext {
    text
    & element-endnote
  }
#object citation number, unique sequential number for objects:
element-ocn =
  element ocn { text }
#object container:
element-object =
  element object {
    element-ocn,
    #note nametag is only used in element-heading, object is used in both heading and content ->
    element nametag { text }?,
    element-text
  }+
#heading object container
element-heading =
  element heading {
    element-object
  }
#content/paragraph/main text object container
element-content =
  element content {
    element-object*
  },
#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.
#%% structure
element document {
  #document head:
  element head {
    attribute id { text },
    element-dc,
    attribute copyright { text }?
    #element title {
    #  attribute xml:lang { text },
    #  text
    #}
  },
  #document body:
  element body { 
    element heading1 {
      element-heading,
      element heading2 {
        element-heading,
        element heading3 {
          element-heading,
          element contents1 {
            element-heading,
            element-content*,
            element contents2 {
              element-heading,
              element-content*,
              element contents3 {
                element-heading,
                element-content*
              }*
            }*
          }+
        }+
      }+
    }+
  }
}
RELAXNG
    end
    def rnc_xhtml
      @relaxng =<<RELAXNG
#%% sax model
# Author: Ralph@Amissah.com
#%% definitions
#dublin core:
element-dc =
  ( attribute title { text }
  #attribute subtitle { text }?
  & attribute creator { text }?
  & attribute subject { text }?
  & attribute description { text }?
  & attribute publisher { text }?
  & attribute contributor { text }?
  & attribute date { text }?
  & attribute datecreated { text }?
  & attribute dateissued { text }?
  & attribute dateavailable { text }?
  & attribute datevalid { text }?
  & attribute datemodified { text }?
  & attribute type { text }?
  & attribute format { text }?
  & attribute identifier { text }?
  & attribute source { text }?
  & attribute relation { text }?
  & attribute coverage { text }?
  & attribute rights { text }?
  & attribute keywords { text }? ),
#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.
#%% structure
element document {
  #document head:
  element head {
    attribute id { text },
    element-dc,
    attribute copyright { text }?
    #element title {
    #  attribute xml:lang { text },
    #  text
    #}
  },
  #document body:
  element body {
    #object, unit
    element object {
      #may or may not be a heading, if heading provide heading level [1-6]:
      element heading { text }?,
      #object citation number, unique sequential number for objects:
      element ocn { text },
      #body content/text, whether heading or ordinary paragraph:
      element text { text },
      #endnotes, zero or many:
      element endnote {
        #endnotes number:
        element en_n { text },
        #endnotes content/text:
        element note { text }
      }*
    }+
  }
}
RELAXNG
    end
    def rnc_sax_ok_old
      @relaxng =<<RELAXNG
#%% sax model
# Author: Ralph@Amissah.com
#%% definitions
#dublin core:
element-dc =
  ( attribute title { text }
  #attribute subtitle { text }?
  & attribute creator { text }?
  & attribute subject { text }?
  & attribute description { text }?
  & attribute publisher { text }?
  & attribute contributor { text }?
  & attribute date { text }?
  & attribute datecreated { text }?
  & attribute dateissued { text }?
  & attribute dateavailable { text }?
  & attribute datevalid { text }?
  & attribute datemodified { text }?
  & attribute type { text }?
  & attribute format { text }?
  & attribute identifier { text }?
  & attribute source { text }?
  & attribute relation { text }?
  & attribute coverage { text }?
  & attribute rights { text }?
  & attribute keywords { text }? ),
#text includes <en> endnote pointer numbers, and <b> <i> <u> etc.
#note includes <b> <i> <u> etc.
#%% structure
element document {
  #document head:
  element head {
    attribute id { text },
    element-dc,
    attribute copyright { text }?
    #element title {
    #  attribute xml:lang { text },
    #  text
    #}
  },
  #document body:
  element body {
    #object, unit
    element object {
      #may or may not be a heading, if heading provide heading level [1-6]:
      element heading { text }?,
      #object citation number, unique sequential number for objects:
      element ocn { text },
      #body content/text, whether heading or ordinary paragraph:
      element text { text },
      #endnotes, zero or many:
      element endnote {
        #endnotes number:
        element en_n { text },
        #endnotes content/text:
        element note { text }
      }*
    }+
  }
}
RELAXNG
    end
    def rnc_dom_old
      @relaxng =<<RELAXNG
# Author: Ralph@Amissah.com
#%% Definitions 
dublin-core =
  element dc {
    attribute id { text },
    attribute title { text },
    attribute subtitle { text }?,
    attribute creator { text }?,
    attribute subject { text }?,
    attribute description { text }?,
    attribute publisher { text }?,
    attribute contributor { text }?,
    attribute date { text }?,
    attribute datecreated { text }?,
    attribute dateissued { text }?,
    attribute dateavailable { text }?,
    attribute datevalid { text }?,
    attribute datemodified { text }?,
    attribute type { text }?,
    attribute format { text }?,
    attribute identifier { text }?,
    attribute source { text }?,
    attribute relation { text }?,
    attribute coverage { text }?,
    attribute rights { text }?,
    attribute keywords { text }?,
    attribute copyright { text }?,
    element title {
      attribute xml:lang { text },
      text
    }
  }
#%% Header 
header-elm =
  element title { text },
  element file { text },
  element generator { text },
  dublin-core
#%% Heading 
heading-elm=
  element heading {
    element object {
      element ocn { id },
      element nametag { text }?,
      element text { text }
    }
  }
#%% Content 
content-elm =
  element content {
    element object {
      element ocn { id }
      & text +
      & element endnote {
        element number { text },
        element note { text }
      }*
    }
  }
#%% Contents 
contents-elm =
  element content1 {
    heading-elm,
    content-elm+,
    element content2 {
      heading-elm,
      content-elm+,
      element content3 {
        heading-elm,
        content-elm+
      }*
    }*
  }+,
#%% Document Structure 
# one aspect missing from model: heading3 if follows heading2 should be contained within heading2, else works i think
element document {
  header-elm,
  element body {
    element heading1 {
      heading-elm
      & element heading2 {
        heading-elm,
        element heading3 {
          heading-elm,
          contents-elm
        }?
      }?
      & element heading2 {
        heading-elm,
        contents-elm
      }?
      & element heading3 {
        heading-elm,
        contents-elm
      }?
      & contents-elm
    }+
  }
}
RELAXNG
    end
  end
end
__END__
