/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  control window
*/

#include "common.h"

#include "nextmrl.xpm"
#include "prevmrl.xpm"
#include "play.xpm"
#include "stop.xpm"
#include "pause.xpm"
#include "playlist.xpm"
#include "fullscreen.xpm"
#include "repeat.xpm"
#include "norepeat.xpm"
#include "mute.xpm"
#include "nomute.xpm"

#include <X11/Xlib.h>

static GtkWidget *control_win;
static GtkWidget *mrl_wid, *time_wid, *info_wid, *vol_wid;
static GtkObject *time_adj, *vol_adj;
static GtkWidget *browse_win = NULL, *jump_win = NULL;
static GtkWidget *h_spin, *m_spin, *s_spin;
static int total_h = 0, total_m = 0, total_s = 0;
static int current_h = 0, current_m = 0, current_s = 0;

static void cb_jump(GtkWidget *w, gpointer data);
static void cb_browse(GtkWidget *w, gpointer data);
static void cb_seek(GtkAdjustment *tadj);
static void cb_mrl(void);
static void cb_volume(GtkAdjustment *tadj);
static int cb_lala(GtkWidget *w, GdkEventButton *ev, gpointer data);


int control_init(void)
{
	GtkWidget *vb, *hb, *hb2, *bb;
	GtkWidget *lab, *b;

	control_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(control_win), _("Sinek Control"));
	gtk_window_set_wmclass(GTK_WINDOW(control_win), "Sinek Control", "Sinek");

	vb = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vb);
	gtk_container_add(GTK_CONTAINER(control_win), vb);
	gtk_container_set_border_width(GTK_CONTAINER(vb), 5);

	hb = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hb);
	gtk_box_pack_start(GTK_BOX(vb), hb, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 2);

	lab = gtk_label_new(_("Media"));
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(hb), lab, FALSE, FALSE, 0);

	mrl_wid = gtk_entry_new();
	gtk_widget_show(mrl_wid);
	gtk_box_pack_start(GTK_BOX(hb), mrl_wid, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(mrl_wid), "activate", GTK_SIGNAL_FUNC(cb_mrl), NULL);
	add_tooltip(mrl_wid, _("Enter a media resource locator"));

	b = gtk_button_new_with_label(_("Open..."));
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(hb), b, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(b), "clicked", GTK_SIGNAL_FUNC(cb_browse), NULL);
	add_tooltip(b, _("Open a video file"));

	time_adj = gtk_adjustment_new(0, 0, 0, 1, 0, 0);
	time_wid = gtk_hscale_new(GTK_ADJUSTMENT(time_adj));
	gtk_widget_show(time_wid);
	gtk_box_pack_start(GTK_BOX(vb), time_wid, TRUE, TRUE, 0);
	gtk_scale_set_draw_value(GTK_SCALE(time_wid), FALSE);
	gtk_signal_connect(time_adj, "value_changed", GTK_SIGNAL_FUNC(cb_seek), NULL);
	gtk_signal_connect(GTK_OBJECT(time_wid), "button_release_event", GTK_SIGNAL_FUNC(cb_lala), NULL);
	add_tooltip(time_wid, _("Seek a position"));

	hb2 = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hb2);
	gtk_box_pack_start(GTK_BOX(vb), hb2, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hb2), 1);

	b = gtk_button_new_with_label(_("Go..."));
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(hb2), b, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(b), "clicked", GTK_SIGNAL_FUNC(cb_jump), NULL);
	add_tooltip(b, _("Jump to a position"));

	info_wid = gtk_entry_new();
	gtk_widget_show(info_wid);
	gtk_box_pack_start(GTK_BOX(hb2), info_wid, TRUE, TRUE, 0);
	gtk_entry_set_editable(GTK_ENTRY(info_wid), FALSE);
	GTK_WIDGET_UNSET_FLAGS(info_wid, GTK_CAN_FOCUS);

	lab = gtk_label_new(_("Volume"));
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(hb2), lab, FALSE, FALSE, 0);

	vol_adj = gtk_adjustment_new(audio_get_volume(), 0, 100, 1, 0, 0);
	vol_wid = gtk_hscale_new(GTK_ADJUSTMENT(vol_adj));
	gtk_widget_show(vol_wid);
	gtk_box_pack_start(GTK_BOX(hb2), vol_wid, TRUE, TRUE, 0);
	gtk_scale_set_draw_value(GTK_SCALE(vol_wid), FALSE);
	gtk_signal_connect(vol_adj, "value_changed", GTK_SIGNAL_FUNC(cb_volume), NULL);
	add_tooltip(vol_wid, _("Adjust audio volume"));

	bb = gtk_hbox_new(TRUE, 5);
	gtk_widget_show(bb);
	gtk_box_pack_start(GTK_BOX(vb), bb, TRUE, TRUE, 2);
	gtk_container_set_border_width(GTK_CONTAINER(bb), 1);

	b = create_pix_button(prevmrl_xpm, CMD_PREVIOUS, _("Previous mrl"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(play_xpm, CMD_PLAY, _("Play"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(pause_xpm, CMD_PAUSE, _("Pause"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(stop_xpm, CMD_STOP, _("Stop"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(nextmrl_xpm, CMD_NEXT, _("Next mrl"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(playlist_xpm, CMD_SHOW_PLAYLIST, _("Open playlist window"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	b = create_pix_button(fullscreen_xpm, CMD_TOGGLE_FULLSCREEN, _("Toggle fullscreen mode"));
	gtk_container_add(GTK_CONTAINER(bb), b);
	sinek.repeat_tog = create_pix_toggle(repeat_xpm, norepeat_xpm, CMD_TOGGLE_REPEAT, _("Toggle repeat mode"));
	gtk_container_add(GTK_CONTAINER(bb), sinek.repeat_tog);
	sinek.mute_tog = create_pix_toggle(mute_xpm, nomute_xpm, CMD_TOGGLE_MUTE, _("Toggle mute mode"));
	gtk_container_add(GTK_CONTAINER(bb), sinek.mute_tog);

	if(sinek.repeat_one)
	{
		GTK_TOGGLE_BUTTON(sinek.repeat_tog)->active = TRUE;
		update_pix_toggle(sinek.repeat_tog);
	}

	sinek.control_win = control_win;

	wm_manage(control_win, WM_NORMAL);
	if(!sinek.hide_gui) gtk_widget_show(control_win);

	return 1;
}


void control_current_time(int secs)
{
	static char buf[30];

	current_h = secs / 3600;
	current_m = (secs % 3600) / 60;
	current_s = secs % 60;

	GTK_ADJUSTMENT(time_adj)->value = secs;
	gtk_signal_emit_by_name(time_adj, "changed");
	sinek.seeking = 0;

	sprintf(buf, "%02d:%02d:%02d of %02d:%02d:%02d", current_h, current_m, current_s, total_h, total_m, total_s);
	gtk_entry_set_text(GTK_ENTRY(info_wid), buf);
}


void control_total_time(int secs)
{
	total_h = secs / 3600;
	total_m = (secs % 3600) / 60;
	total_s = secs % 60;

	GTK_ADJUSTMENT(time_adj)->upper = secs;
}


void control_mrl(char *mrl)
{
	gtk_entry_set_text(GTK_ENTRY(mrl_wid), mrl);
	gtk_entry_set_position(GTK_ENTRY(mrl_wid), -1);
}


void control_volume(int value)
{
	GTK_ADJUSTMENT(vol_adj)->value = value;
	gtk_signal_emit_by_name(vol_adj, "changed");
}


static void cb_seek(GtkAdjustment *tadj)
{
	static char buf[30];
	int secs, h, m, s;

	sinek.seeking = 1;

	secs = tadj->value;
	h = secs / 3600;
	m = (secs % 3600) / 60;
	s = secs % 60;

	sprintf(buf, "%02d:%02d:%02d of %02d:%02d:%02d", h, m, s, total_h, total_m, total_s);
	gtk_entry_set_text(GTK_ENTRY(info_wid), buf);
}


static void cb_volume(GtkAdjustment *vadj)
{
	audio_set_volume(vadj->value);
}


static int cb_lala(GtkWidget *w, GdkEventButton *ev, gpointer data)
{
	if(sinek.seeking)
	{
		video_seek(GTK_ADJUSTMENT(time_adj)->value);
		sinek.seeking = 0;
	}
	return TRUE;
}


static void cb_mrl(void)
{
	char *mrl;

	mrl = gtk_entry_get_text(GTK_ENTRY(mrl_wid));
	if(!mrl || *mrl == 0) return;
	video_play(mrl);
}


static void cb_browse(GtkWidget *w, gpointer data)
{
	if(!browse_win)
	{
		browse_win = file_request(0);
		wm_manage(browse_win, 0);
	}
	gtk_widget_show(browse_win);
}


static void cb_jump_go(GtkWidget *w, GtkWidget *win)
{
	int h, m, s, secs;

	h = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(h_spin));
	m = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(m_spin));
	s = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(s_spin));
	secs = h * 3600 + m * 60 + s;
	video_seek(secs);
	gtk_widget_hide(win);
}


static void cb_jump(GtkWidget *w, gpointer data)
{
	GtkObject *adj;
	GtkWidget *vb, *fr, *hb, *b;

	if(jump_win) goto out;

	jump_win = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(jump_win), _("Go to..."));

	vb = GTK_DIALOG(jump_win)->vbox;
	gtk_widget_show(vb);
	fr = gtk_frame_new(NULL);
	gtk_widget_show(fr);
	gtk_box_pack_start(GTK_BOX(vb), fr, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(fr), 5);

	hb = gtk_hbox_new(TRUE, 0);
	gtk_widget_show(hb);
	gtk_container_add(GTK_CONTAINER(fr), hb);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 5);

	adj = gtk_adjustment_new(current_h, 0, 100, 1, 0, 0);
	h_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_widget_show(h_spin);
	gtk_box_pack_start(GTK_BOX(hb), h_spin, FALSE, FALSE, 0);

	adj = gtk_adjustment_new(current_m, 0, 60, 1, 0, 0);
	m_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_widget_show(m_spin);
	gtk_box_pack_start(GTK_BOX(hb), m_spin, FALSE, FALSE, 0);

	adj = gtk_adjustment_new(current_s, 0, 60, 1, 0, 0);
	s_spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 0);
	gtk_widget_show(s_spin);
	gtk_box_pack_start(GTK_BOX(hb), s_spin, FALSE, FALSE, 0);

	hb = GTK_DIALOG(jump_win)->action_area;
	gtk_widget_show(hb);
	gtk_container_set_border_width(GTK_CONTAINER(hb), 10);

	b = gtk_button_new_with_label(_("GO"));
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(hb), b, TRUE, TRUE, 0);

	gtk_signal_connect(GTK_OBJECT(b), "clicked", GTK_SIGNAL_FUNC(cb_jump_go), jump_win);
	gtk_signal_connect_object(GTK_OBJECT(jump_win), "delete_event", gtk_widget_hide, GTK_OBJECT(jump_win));

	wm_manage(jump_win, 0);
out:
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(h_spin), current_h);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(m_spin), current_m);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(s_spin), current_s);
	gtk_widget_show(jump_win);
}
