/*
 * Copyright (c) 1997 - 2001 Hansjrg Malthaner
 *
 * This file is part of the Simutrans project under the artistic licence.
 * (see licence.txt)
 */

#ifndef gui_ifc_action_listener_h
#define gui_ifc_action_listener_h

#include "../../simtypes.h"

class gui_komponente_t;

/**
 * This interface must be implemented by all classes which want to
 * listen actions, i.e. button presses
 * @author Hj. Malthaner
 */
class action_listener_t
{
public:
	virtual ~action_listener_t() {}

	/**
	 * This method is called if an action is triggered
	 * @author Hj. Malthaner
	 *
	 * Returns true, if action is done and no more
	 * components should be triggered.
	 * V.Meyer
	 */
	virtual bool action_triggered(gui_komponente_t *komp, value_t extra) = 0;
};

#endif
