#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

#ifndef __GRAPHIC_TOOLBOX_H__
#define __GRAPHIC_TOOLBOX_H__

@interface NSBezierPath (RoundRect)
- (void) appendBezierPathWithLeftAndBottomRoundedCorners: (NSRect) aRect withRadius: (float) radius;
- (void) appendBezierPathWithBottomRoundedCorners: (NSRect) aRect withRadius: (float) radius;
- (void) appendBezierPathWithLeftRoundedCorners: (NSRect) aRect withRadius: (float) radius;
- (void) appendBezierPathWithTopRoundedCorners: (NSRect) aRect withRadius: (float) radius;
- (void) appendBezierPathWithRoundedRectangle: (NSRect) aRect withRadius: (float) radius;
- (void) appendBezierDemiSupPathWithRoundedRectangle: (NSRect) aRect withRadius: (float) radius;
- (void) appendBezierDemiDownPathWithRoundedRectangle: (NSRect) aRect withRadius: (float) radius;
@end

@interface GraphicToolbox: NSObject
+ (void) drawHorizontalGradientOnRect: (NSRect) rect withStartColor: (NSColor*) begin andEndColor: (NSColor*) end;
+ (void) drawVerticalGradientOnRect: (NSRect) rect withStartColor: (NSColor*) begin andEndColor: (NSColor*) end;
+ (void) drawButtonOnRect: (NSRect) rect pushed: (BOOL) state;
+ (void) drawButtonOnRect: (NSRect) rect pushed: (BOOL) state width: (int) width;
+ (void) drawButtonOnRect: (NSRect) rect pushed: (BOOL) state width: (int) width highlight: (NSColor*) highlight 
	downlight: (NSColor*) downlight flipped: (BOOL) flipped;
//+ (void) drawButtonWithImage: (NSRect) rect;
+ (void) drawCadre: (NSRect) rect;
+ (void) drawFrame: (NSRect) rect;
+ (void) semiRoundPathWithRect: (NSRect) rect andRound: (int) round;
+ (void) setColor;
+ (void) fillRect: (NSRect) rect withHorizontalImage: (NSImage*) image;
@end

#endif
