/**
 * HTTP/HTTPS protocol support 
 *
 * Copyright (C) 2001 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <http.h>
#include <setup.h>
#include <cookie.h>
#include <string.h>

char request[1024]; 
char *protocol; 
char *keepalive;

/**
 * returns int, ( < 0 == error )
 * formats and sends an HTTP/1.0 request
 */
int
SIEGEhttp_send( char *host, char *path )
{
  int rlen;

  /* cookie value  */
  char cookie[512];

  memset( cookie,  0, sizeof( cookie ));
  memset( request, 0, sizeof( request ));

  /* HTTP protocol string */
  protocol = (my.protocol == TRUE)?"HTTP/1.1":"HTTP/1.0";
  keepalive = (my.keepalive == TRUE)?"keep-alive":"close";

  snprintf(
    cookie, sizeof( cookie ),
    "%s",
    get_cookie( host )
  );

  /* build a request string to
     pass to the server       */
  if( my.authorize ){
    rlen=snprintf(
      request, sizeof( request ),
      "GET %s %s\015\012"
      "Host: %s\015\012"
      "Authorization: Basic %s\015\012"
      "Cookie: %s\015\012"
      "Accept: */*\015\012"
      "Accept-Encoding: * \015\012"
      "User-Agent: %s\015\012"
      "Connection: %s\015\012\015\012",
      path, protocol, host, my.auth, cookie, my.uagent, keepalive
    );
  }
  else{ 
    rlen=snprintf(
      request, sizeof( request ),
      "GET %s %s\015\012"
      "Host: %s\015\012"
      "Cookie: %s\015\012"
      "Accept: */*\015\012"
      "Accept-Encoding: * \015\012"
      "User-Agent: %s\015\012"
      "Connection: %s\015\012\015\012",
      path, protocol, host, cookie, my.uagent, keepalive
    );
  }
  
  if( rlen<0 || rlen>sizeof(request)  ){ joe_fatal("http_send: request buffer overrun!"); }
  return SIEGEsocket_write( request, rlen );
}

/**
 * returns int, ( < 0 == error )
 * formats and sends an HTTP/1.0 request
 */
int
SIEGEhttp_post( char *host, char *path, char *data, size_t len )
{
  int  rlen;

  /* cookie value  */
  char cookie[512];

  /* HTTP user agent char array */
  char user_agent[256];

  if( my.debug ){ printf( "Data: %s\n", data ); }
  memset( cookie,  0, sizeof( cookie ));
  memset( request, 0, sizeof( request ));

  /* HTTP protocol string */
  protocol  = (my.protocol  == TRUE)?"HTTP/1.1":"HTTP/1.0";
  keepalive = (my.keepalive == TRUE)?"keep-alive":"close";
  
  snprintf(
    cookie, sizeof( cookie ),
    "%s",
    get_cookie( host )
  );

    /* build a request string to
     pass to the server       */
  if( my.authorize ){
    rlen=snprintf(
      request, sizeof( request ),
      "POST %s %s\015\012"
      "Host: %s\015\012"
      "Authorization: Basic %s\015\012"
      "Cookie: %s\015\012"
      "Accept: */*\015\012"
      "Accept-Encoding: * \015\012"
      "User-Agent: %s\015\012"
      "Connection: %s\015\012"
      "Content-type: application/x-www-form-urlencoded\015\012"
      "Content-length: %d\015\012\015\012"
      "%*.*s\015\012",
      path, protocol, host, my.auth, cookie, my.uagent, keepalive, len, len, len, data
    );
  }
  else{
    rlen=snprintf(
      request, sizeof( request ),
      "POST %s %s\015\012"
      "Host: %s\015\012"
      "Cookie: %s\015\012"
      "Accept: */*\015\012"
      "Accept-Encoding: * \015\012"
      "User-Agent: %s\015\012"
      "Connection: %s\015\012"
      "Content-type: application/x-www-form-urlencoded\015\012"
      "Content-length: %d\015\012\015\012"
      "%*.*s\015\012",
      path, protocol, host, cookie, my.uagent, keepalive, len, len, len, data
    );
  }

  if( my.debug ){ printf("%s\n", request); fflush(stdout); }
  if( rlen<0 || rlen>sizeof(request) ){ joe_fatal("http_post: request buffer overrun!"); }
  return SIEGEsocket_write( request, rlen );
}

/**
 * returns headers struct
 * reads from http/https socket and parses
 * header information into the struct.
 */
struct headers
SIEGEhttp_read_headers( char *host )
{ 
  int  x;           /* while loop index      */
  int  n;           /* assign socket_read    */
  char c;           /* assign char read      */
  char line[255];   /* assign chars read     */
  struct headers h; /* struct to hold it all */
  memset( &h.head, 0, sizeof( h.head )); 
  memset( &h.cookie, 0, sizeof( h.cookie ));
    
  while( TRUE ){
    x = 0;
    memset( &line, 0, sizeof( line ));
    
    while(( n = SIEGEsocket_read( &c, 1 )) == 1 ){
      line[x] = c; 
      if(( line[0] == '\n' ) || ( line[1] == '\n' )){ 
        return h;
      }
      if( line[x] == '\n' ) break;
      x ++;
    }
    if( strncasecmp( line, "http", 4 ) == 0 ){
      strncpy( h.head, line, 8 );
      h.code = atoi( line + 9 ); 
    }
    if( strncasecmp( line, "content-length: ", 16 ) == 0 ){ 
      h.length = atol( line + 16 ); 
    }
    if( strncasecmp( line, "set-cookie: ", 12 ) == 0 ){
      strncpy( h.cookie, line+12, strlen( line ));
      add_cookie( host, h.cookie );
    }
    if( strncasecmp( line, "connection: ", 12 ) == 0 ){
      if ( strncasecmp( line+12, "keep-alive", 10 ) == 0 ){
        h.keepalive = 1;
      }
      else if( strncasecmp( line+12, "close", 5 ) == 0 ){
        h.keepalive = 0;
      }
    }
  } /* end of while TRUE */
  return h;
}

/**
 * returns int
 * reads a http/https socket
 * ( you know what I mean :)
 */
int
SIEGEhttp_read( int len )
{ 
  char c;   
  int  n;  
  int  bytes;

  bytes = 0;
  while(( n = SIEGEsocket_read( &c, 1 )) == 1 ){
    bytes++;
    if( bytes == len && len != 0 ) break;
  } 
  return bytes;
}

