/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    sound.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlesound ()
//	determine the correct procedure to use
void handlesound () {
	//  kernel 2.4 contains no sound device information
	if (KERNEL==VER24) return;
	// proc/sound in kernel 2.2 is compatible with kernel 2.0
	if (KERNEL==VER22) handlesoundv20();
	if (KERNEL==VER20) handlesoundv20();
	return;
}

// handlesoundv20() Function
void handlesoundv20 () {
	char filename [INPUT_STRING];
	FILE *filep;
	char tmpstring [INPUT_STRING];
	int c=0;
	int col=0;
	char type [INPUT_STRING];
	char desc [INPUT_STRING];

	// Open /proc/sound
	sprintf (filename, "%ssound", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	// Find PROC_SOUNDDRV
	fgetstr (filep, tmpstring, INPUT_STRING);
	strncpy (PROCINFO[PROC_SOUNDDRV], tmpstring, STORAGE_STRING-1);
	PROCINFO[PROC_SOUNDDRV][STORAGE_STRING-1]=0;
	// Enter Loop
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strncmp(tmpstring, "Installed drivers:", 18)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				killcrlf (tmpstring, strlen(tmpstring));
				col=cinstr(tmpstring, ':');
				if (col==-1) break;
				fillstring (type, 0, INPUT_STRING);
				strncpy (type, tmpstring, col);
				type[col]=0;
				rstring (tmpstring, col+1, desc);
				SNDDRV[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDDRV[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDDRV[c])[0]=0;
				sprintf (*SNDDRV[c], "%-10s %s", type, desc);
				c++;
				if (c==SNDDRV_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDDRV=c-1;
			continue;
		}
		if (strncmp(tmpstring, "Card config:", 12)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (strlen(tmpstring)==1) break;
				killcrlf (tmpstring, strlen(tmpstring));
				SNDCONF[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDCONF[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDCONF[c])[0]=0;
				strncpy (*SNDCONF[c], tmpstring, STORAGE_STRING-1);
				(*SNDCONF[c])[STORAGE_STRING-1]=0;
				c++;
				if (c==SNDCONF_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDCONF=c-1;
			continue;
		}
		if (strncmp(tmpstring, "Audio devices:", 14)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (strlen(tmpstring)==1) break;
				killcrlf (tmpstring, strlen(tmpstring));
				SNDAUDIO[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDAUDIO[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDAUDIO[c])[0]=0;
				strncpy (*SNDAUDIO[c], tmpstring, STORAGE_STRING-1);
				(*SNDAUDIO[c])[STORAGE_STRING-1]=0;
				c++;
				if (c==SNDAUDIO_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDAUDIO=c-1;
			continue;
		}
		if (strncmp(tmpstring, "Synth devices:", 14)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (strlen(tmpstring)==1) break;
				killcrlf (tmpstring, strlen(tmpstring));
				SNDSYNTH[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDSYNTH[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDSYNTH[c])[0]=0;
				strncpy (*SNDSYNTH[c], tmpstring, STORAGE_STRING-1);
				(*SNDSYNTH[c])[STORAGE_STRING-1]=0;
				c++;
				if (c==SNDSYNTH_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDSYNTH=c-1;
			continue;
		}
		if (strncmp(tmpstring, "Midi devices:", 13)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (strlen(tmpstring)==1) break;
				killcrlf (tmpstring, strlen(tmpstring));
				SNDMIDI[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDMIDI[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDMIDI[c])[0]=0;
				strncpy (*SNDMIDI[c], tmpstring, STORAGE_STRING-1);
				(*SNDMIDI[c])[STORAGE_STRING-1]=0;
				c++;
				if (c==SNDMIDI_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDMIDI=c-1;
			continue;
		}
		if (strncmp(tmpstring, "Timers:", 7)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (strlen(tmpstring)==1) break;
				killcrlf (tmpstring, strlen(tmpstring));
				SNDTIMERS[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDTIMERS[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDTIMERS[c])[0]=0;
				strncpy (*SNDTIMERS[c], tmpstring, STORAGE_STRING-1);
				(*SNDTIMERS[c])[STORAGE_STRING-1]=0;
				c++;
				if (c==SNDTIMERS_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDTIMERS=c-1;
			continue;
		}
		if (strncmp(tmpstring, "Mixers:", 7)==0) {
			c=0;
			do {
				fgets (tmpstring, INPUT_STRING, filep);
				if (feof(filep)!=0) break;
				if (strlen(tmpstring)==1) break;
				killcrlf (tmpstring, strlen(tmpstring));
				SNDMIXERS[c]=malloc(STRING_ARRAY_SIZE);
				if (SNDMIXERS[c]==NULL) error_handler(ERROR_MALLOC);
				(*SNDMIXERS[c])[0]=0;
				strncpy (*SNDMIXERS[c], tmpstring, STORAGE_STRING-1);
				(*SNDMIXERS[c])[STORAGE_STRING-1]=0;
				c++;
				if (c==SNDMIXERS_COUNT_MAX) break;
			} while (0==0);
			NUM_SNDMIXERS=c-1;
			continue;
		}
	} while (0==0);
	fclose (filep);
	// Return
	return;
}

