/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    html.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// display_html() Function
void display_html () {
	int i=0;
	int j=0;
	char tmpstring [INPUT_STRING];

	// Display All proc Filesystem Information
	fprintf (fstdout, "si:  Dumping Information\n");
	fprintf (fstdout, "\n");
	// Print the Content-Type Line
	fstdout=stdout;
	fprintf (fstdout, "Content-Type: text/html\n");
	fprintf (fstdout, "Expires: now\n\n");
	fprintf (fstdout, "<HTML><HEAD><TITLE>si - System Information Viewer</TITLE></HEAD><BODY>");
	// si
		fprintf (fstdout, "<H1><A HREF=\"http://si.netpedia.net\">si</A> - System Information Viewer</H1><BR><BR>");
		fprintf (fstdout, "<P><B>si - Program Information:</B><BR>");
		fprintf (fstdout, "%s</P>", PROCINFO[PROC_EXINFO]);
	// System
		if (OPT_SHOW_SYSTEM==1) {
		fprintf (fstdout, "<BR><H1>System Information:</H1>");
		// cpu information
			fprintf (fstdout, "<P><B>CPU Information:</B><BR>");
			if (NUM_CPU>=0) {
				fprintf (fstdout, "Number of CPUs: %i</P>", NUM_CPU + 1);
				for (i=0; i<=NUM_CPU; i++) {
					fprintf (fstdout, "<P><B>Processor #%i Information:</B><BR>", i);
					fprintf (fstdout, "<TABLE>");
					fprintf (fstdout, "<TR><TD>Vendor:</TD><TD>%s</TD></TR>", CPU[i]->VENDOR);
					fprintf (fstdout, "<TR><TD>Model:</TD><TD>%s</TD></TR>", CPU[i]->MODEL);
					if (KERNEL != VER20) {
						fprintf (fstdout, "<TR><TD>Speed:</TD><TD>%s MHz</TD></TR>", CPU[i]->SPEED);
						fprintf (fstdout, "<TR><TD>Cache:</TD><TD>%s</TD></TR>", CPU[i]->CACHE);
						fprintf (fstdout, "</TABLE>CPU Usage By Priority Modes:<TABLE>");
						fprintf (fstdout, "<TR><TD>User Mode:</TD><TD>%s</TD></TR>", CPU[i]->USER);
						fprintf (fstdout, "<TR><TD>Nice Mode:</TD><TD>%s</TD></TR>", CPU[i]->NICE);
						fprintf (fstdout, "<TR><TD>System Mode:</TD><TD>%s</TD></TR>", CPU[i]->SYS);
						fprintf (fstdout, "<TR><TD>Idle Mode:</TD><TD>%s</TD></TR>", CPU[i]->IDLE);
					}
					fprintf (fstdout, "</TABLE></P>");
				}
			}
			fprintf (fstdout, "<P><B>Total CPU Usage By Priority Modes:</B><BR>");
			fprintf (fstdout, "<TABLE>");
			fprintf (fstdout, "<TR><TD>User Mode:</TD><TD>%s</TD></TR>", PROCINFO[PROC_CPUUSER]);
			fprintf (fstdout, "<TR><TD>Nice Mode:</TD><TD>%s</TD></TR>", PROCINFO[PROC_CPUNICE]);
			fprintf (fstdout, "<TR><TD>System Mode:</TD><TD>%s</TD></TR>", PROCINFO[PROC_CPUSYS]);
			fprintf (fstdout, "<TR><TD>Idle Mode:</TD><TD>%s</TD></TR>", PROCINFO[PROC_CPUIDLE]);
			fprintf (fstdout, "</TABLE></P>");
		// load averages
			fprintf (fstdout, "<P><B>Load Averages (previous one, five, and fifteen minutes):</B><BR>");
			fprintf (fstdout, "<TABLE><TR><TD>One:</TD><TD>%s</TD></TR><TR><TD>Five:</TD><TD>%s</TD></TR><TR><TD>Fifteen:</TD><TD>%s</TD></TR></TABLE></P>", PROCINFO[PROC_LOADAVG_1], PROCINFO[PROC_LOADAVG_5], PROCINFO[PROC_LOADAVG_15]);
		// boottime
			fprintf (fstdout, "<P><B>Boot Time:</B><BR>");
			fprintf (fstdout, "%s</P>", PROCINFO[PROC_BTIME]);
		// uptime
			fprintf (fstdout, "<P><B>Uptime:</B><BR>");
			fprintf (fstdout, "%s</P>", PROCINFO[PROC_UPTIME]);
		// context switches
			fprintf (fstdout, "<P><B>Number of Context Switches System Underwent:</B><BR>");
			fprintf (fstdout, "%s</P>", PROCINFO[PROC_CTXT]);
		}
	// Hardware
		if (OPT_SHOW_HARDWARE==1) {
			fprintf (fstdout, "<H1>Hardware Information:</H1>");
			// devices
			if (NUM_CHARDEV>=0) {
				fprintf (fstdout, "<P><B>Character Devices:</B><BR>");
				fprintf (fstdout, "<TABLE>");
				fprintf (fstdout, "<TR><TD><B>Num</B></TD><TD><B>Device</B></TD></TR>");
				for (i=0; i<=NUM_CHARDEV; i++)
					fprintf (fstdout, "<TR><TD>%3d</TD><TD>%s</TD></TR>", CHARDEV[i]->NUMBER, CHARDEV[i]->NAME);
				fprintf (fstdout, "</TABLE></P>");
			}
			if (NUM_BLOCKDEV>=0) {
				fprintf (fstdout, "<P><B>Block Devices:</B><BR>");
				fprintf (fstdout, "<TABLE>");
				fprintf (fstdout, "<TR><TD><B>Num</B></TD><TD><B>Device</B></TD></TR>");
				for (i=0; i<=NUM_BLOCKDEV; i++)
					fprintf (fstdout, "<TR><TD>%3d</TD><TD>%s</TD></TR>", BLOCKDEV[i]->NUMBER, BLOCKDEV[i]->NAME);
				fprintf (fstdout, "</TABLE></P>");
			}
			// misc
			if (NUM_MISC>=0) {
				fprintf (fstdout, "<P><B>Miscellaneous Devices:</B><BR>");
				fprintf (fstdout, "<TABLE>");
				fprintf (fstdout, "<TR><TD><B>Num</B></TD><TD><B>Device</B></TD></TR>");
				for (i=0; i<=NUM_MISC; i++)
					fprintf (fstdout, "<TR><TD>%3d</TD><TD>%s</TD></TR>", MISC[i]->NUMBER, MISC[i]->NAME);
				fprintf (fstdout, "</TABLE></P>");
			}
			// isa dma channels
			if (NUM_ISADMA>=0) {
				fprintf (fstdout, "<P><B>Registered ISA DMA (Direct Memory Access) Channels:</B><BR>");
				fprintf (fstdout, "<TABLE>");
				fprintf (fstdout, "<TR><TD><B>Num</B></TD><TD><B>Device</B></TD></TR>");
				for (i=0; i<=NUM_ISADMA; i++)
					fprintf (fstdout, "<TR><TD>%3d</TD><TD>%s</TD></TR>", ISADMA[i]->NUMBER, ISADMA[i]->NAME);
				fprintf (fstdout, "</TABLE></P>");
			}
			// irq interrupts
			if (NUM_IRQINT>=0) {
				fprintf (fstdout, "<P><B>IRQ Interrupts:</B><BR>");
				if (KERNEL == VER20) {
					fprintf (fstdout, "\t INT          CPU  Name<BR>");
					for (i=0; i<=NUM_IRQINT; i++)
						fprintf (fstdout, "\t%s<BR>", *IRQINT[i]);
				}
				else {
					fprintf (fstdout, "\tINT");
					for (i=0; i<=NUM_CPU; i++)
						fprintf (fstdout, "          CPU%d", i);
					fprintf (fstdout, "       Controller  Name<BR>");
					for (i=0; i<=NUM_IRQINT; i++)
						fprintf (fstdout, "\t%s<BR>", *IRQINT[i]);
				}
				fprintf (fstdout, "</P>");
			}
			// ioports
			if (NUM_IOPORTS>=0) {
				fprintf (fstdout, "<P><B>IO (Input-Output) Ports:</B><BR>");
				fprintf (fstdout, "\t Address    Name<BR>");
				for (i=0; i<=NUM_IOPORTS; i++)
					fprintf (fstdout, "\t%s<BR>", *IOPORTS[i]);
				fprintf (fstdout, "</P>");
			}
			// tty drivers
			if (NUM_TTYDRIVERS>=0) {
				fprintf (fstdout, "<P><B>TTY Drivers:</B><BR>");
				for (i=0; i<=NUM_TTYDRIVERS; i++) {
					fprintf (fstdout, "%s<BR>", TTYDRIVERS[i]->DRIVER);
					fprintf (fstdout, "<UL><TABLE>");
					fprintf (fstdout, "<TR><TD>Name:</TD><TD>%s</TD></TR>", TTYDRIVERS[i]->NAME);
					fprintf (fstdout, "<TR><TD>Major:</TD><TD>%s</TD></TR>", TTYDRIVERS[i]->MAJOR);
					fprintf (fstdout, "<TR><TD>Range:</TD><TD>%s</TD></TR>", TTYDRIVERS[i]->RANGE);
					fprintf (fstdout, "<TR><TD>Type:</TD><TD>%s</TD></TR>", TTYDRIVERS[i]->TYPE);
					fprintf (fstdout, "</TABLE></UL>");
				}
				fprintf (fstdout, "</P>");
			}
			// tty ldiscs
			if (NUM_TTYLDISCS>=0) {
				fprintf (fstdout, "<P><B>TTY ldiscs:</B><BR>");
				fprintf (fstdout, "<TABLE>");
				for (i=0; i<=NUM_TTYLDISCS; i++)
					fprintf (fstdout, "<TR><TD>%-20s</TD><TD>%d</TD></TR>", TTYLDISCS[i]->NAME, TTYLDISCS[i]->COUNT);
				fprintf (fstdout, "</TABLE></P>");
			}
			// ide drivers
			if (NUM_IDEDRV>=0) {
				fprintf (fstdout, "<P><B>IDE Drivers:</B><BR>");
				for (i=0; i<=NUM_IDEDRV; i++)
					fprintf (fstdout, "%-20s (Version: %s)<BR>", IDEDRV[i]->NAME, IDEDRV[i]->VERSION);
				fprintf (fstdout, "</P>");
			}
			// ide devices
			if (NUM_IDEDEV>=0) {
				fprintf (fstdout, "<P><B>IDE Devices:</B><BR>");
				for (i=0; i<=NUM_IDEDEV; i++) {
					fprintf (fstdout, "%s (%s)<BR>", IDEDEV[i]->NAME, IDEDEV[i]->PARENT);
					fprintf (fstdout, "<UL><TABLE>");
					fprintf (fstdout, "<TR><TD>Driver:</TD><TD>%s</TD></TR>", IDEDEV[i]->DRIVER);
					fprintf (fstdout, "<TR><TD>Media:</TD><TD>%s</TD></TR>", IDEDEV[i]->MEDIA);
					fprintf (fstdout, "<TR><TD>Model:</TD><TD>%s</TD></TR>", IDEDEV[i]->MODEL);
					fprintf (fstdout, "<TR><TD>Cylinders:</TD><TD>%d</TD></TR>", IDEDEV[i]->CYL);
					fprintf (fstdout, "<TR><TD>Heads:</TD><TD>%d</TD></TR>", IDEDEV[i]->HEAD);
					fprintf (fstdout, "<TR><TD>Sectors:</TD><TD>%d</TD></TR>", IDEDEV[i]->SECT);
					fprintf (fstdout, "</TABLE></UL>");
				}
				fprintf (fstdout, "</P>");
			}
			// scsi drivers
			if (NUM_SCSIDRV>=0) {
				fprintf (fstdout, "<P><B>SCSI Drivers:</B><BR>");
				for (i=0; i<=NUM_SCSIDRV; i++) {
					fprintf (fstdout, "%s<BR>", SCSIDRV[i]->NAME);
					fprintf (fstdout, "<UL>%s</UL><BR>", SCSIDRV[i]->DESC);
				}
			}
			// scsi devices
			if (NUM_SCSIDEV>=0) {
				fprintf (fstdout, "<P><B>SCSI Devices:</B><BR>");
				for (i=0; i<=NUM_SCSIDEV; i++) {
					fprintf (fstdout, "%s %s  (%d,%d,%d)<BR>", SCSIDEV[i]->VENDOR, SCSIDEV[i]->MODEL, SCSIDEV[i]->CHANNEL, SCSIDEV[i]->ID, SCSIDEV[i]->LUN);
					fprintf (fstdout, "<UL><TABLE>");
					fprintf (fstdout, "<TR><TD>Hardware Revision:</TD><TD>%s</TD></TR>", SCSIDEV[i]->REV);
					fprintf (fstdout, "<TR><TD>Hardware Type:</TD><TD>%s</TD></TR>", SCSIDEV[i]->TYPE);
					fprintf (fstdout, "<TR><TD>Host Name:</TD><TD>%s</TD></TR>", SCSIDEV[i]->HOST);
					fprintf (fstdout, "<TR><TD>ANSI SCSI Revision:</TD><TD>%s</TD></TR>", SCSIDEV[i]->ANSIREV);
					fprintf (fstdout, "</TABLE></UL>");
				}
				fprintf (fstdout, "</P>");
			}
			// parallel port settings
			if (NUM_PARPORT>=0) {
				fprintf (fstdout, "<P><B>Parallel Port Settings:</B><BR>");
				for (i=0; i<=NUM_PARPORT; i++) {
					fprintf (fstdout, "Parallel Port #%s<BR>", PARPORT[i]->NAME);
					fprintf (fstdout, "<UL><TABLE>");
					fprintf (fstdout, "<TR><TD>Autoprobe Results:</TD><TD>%s</TD></TR>", PARPORT[i]->AUTOPROBE);
					fprintf (fstdout, "<TR><TD>Devices:</TD><TD>%s</TD></TR>", PARPORT[i]->DEVICES);
					fprintf (fstdout, "<TR><TD>Base IO-Port:</TD><TD>%s</TD></TR>", PARPORT[i]->IOPORT);
					fprintf (fstdout, "<TR><TD>IRQ:</TD><TD>%s</TD></TR>", PARPORT[i]->IRQ);
					fprintf (fstdout, "<TR><TD>DMA:</TD><TD>%s</TD></TR>", PARPORT[i]->DMA);
					fprintf (fstdout, "<TR><TD>Modes:</TD><TD>%s</TD></TR>", PARPORT[i]->PORTTYPE);
					fprintf (fstdout, "</TABLE></UL>");
				}
				fprintf (fstdout, "</P>");
			}
			// sound settings
			if (strlen(PROCINFO[PROC_SOUNDDRV])>0) {
				fprintf (fstdout, "<P><B>Sound Software:</B><BR>");
				fprintf (fstdout, "%s</P>", PROCINFO[PROC_SOUNDDRV]);
			}
			if (NUM_SNDDRV>=0) {
				fprintf (fstdout, "<P><B>Sound Drivers:</B><BR>");
				for (i=0; i<=NUM_SNDDRV; i++)
					fprintf (fstdout, "%s<BR>", *SNDDRV[i]);
				fprintf (fstdout, "</P>");
			}
			if (NUM_SNDCONF>=0) {
				fprintf (fstdout, "<P><B>Sound Card Configuration:</B><BR>");
				for (i=0; i<=NUM_SNDCONF; i++)
					fprintf (fstdout, "%s<BR>", *SNDCONF[i]);
				fprintf (fstdout, "</P>");
			}
			if (NUM_SNDAUDIO>=0) {
				fprintf (fstdout, "<P><B>Sound Audio Devices:</B><BR>");
				for (i=0; i<=NUM_SNDAUDIO; i++)
					fprintf (fstdout, "%s<BR>", *SNDAUDIO[i]);
				fprintf (fstdout, "</P>");
			}
			if (NUM_SNDSYNTH>=0) {
				fprintf (fstdout, "<P><B>Sound Synthesizer Devices:</B><BR>");
				for (i=0; i<=NUM_SNDSYNTH; i++)
					fprintf (fstdout, "%s<BR>", *SNDSYNTH[i]);
				fprintf (fstdout, "</P>");
			}
			if (NUM_SNDMIDI>=0) {
				fprintf (fstdout, "<P><B>Sound MIDI Devices:</B><BR>");
				for (i=0; i<=NUM_SNDMIDI; i++)
					fprintf (fstdout, "%s<BR>", *SNDMIDI[i]);
				fprintf (fstdout, "</P>");
			}
			if (NUM_SNDTIMERS>=0) {
				fprintf (fstdout, "<P><B>Sound Timers:</B><BR>");
				for (i=0; i<=NUM_SNDTIMERS; i++)
					fprintf (fstdout, "%s<BR>", *SNDTIMERS[i]);
				fprintf (fstdout, "</P>");
			}
			if (NUM_SNDMIXERS>=0) {
				fprintf (fstdout, "<P><B>Sound Mixers:</B><BR>");
				for (i=0; i<=NUM_SNDMIXERS; i++)
					fprintf (fstdout, "%s<BR>", *SNDMIXERS[i]);
				fprintf (fstdout, "</P>");
			}
		}
	// Memory
		if (OPT_SHOW_MEMORY==1) {
			fprintf (fstdout, "<H1>Memory Information:</H1>");
			fprintf (fstdout, "<UL><TABLE>");
			fprintf (fstdout, "<TR><TD>Total Memory:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_MEMTOTAL]);
			fprintf (fstdout, "<TR><TD>Free Memory:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_MEMFREE]);
			fprintf (fstdout, "<TR><TD>Shared Memory:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_MEMSHARED]);
			fprintf (fstdout, "<TR><TD>Buffers:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_BUFFERS]);
			fprintf (fstdout, "<TR><TD>Cached Memory:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_CACHED]);
			fprintf (fstdout, "<TR><TD>Total Swap:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_SWAPTOTAL]);
			fprintf (fstdout, "<TR><TD>Free Swap:</TD><TD>%7s kb</TD></TR>", PROCINFO[PROC_SWAPFREE]);
			fprintf (fstdout, "</TABLE></UL>");
			fprintf (fstdout, "<P><B>MTRR (Memory Type Range Register) Configuration:</B><BR>");
			if (NUM_MTRR==-1) fprintf (fstdout, "MTRR Support Not Availible.");
			for (i=0; i<=NUM_MTRR; i++) {
				fprintf (fstdout, "Register %d: (Size=%dMB)<BR>", MTRR[i]->REG, MTRR[i]->SIZE);
				fprintf (fstdout, "<UL><TABLE>");
				fprintf (fstdout, "<TR><TD>Offset:</TD><TD>%10s  (%dMB)</TD></TR>", MTRR[i]->OFFHEX, MTRR[i]->OFFMB);
				fprintf (fstdout, "<TR><TD>Options:</TD><TD>%s</TD></TR>", MTRR[i]->OPTION);
				fprintf (fstdout, "<TR><TD>Count:</TD><TD>%d</TD></TR>", MTRR[i]->COUNT);
				fprintf (fstdout, "</TABLE></UL>");
			}
			fprintf (fstdout, "</P>");
		}
	// Kernel
		if (OPT_SHOW_KERNEL==1) {
		fprintf (fstdout, "<H1>Kernel Information:</H1>");
		// ostype & osrelease
			fprintf (fstdout, "<P><B>Operating System:</B><BR>");
			fprintf (fstdout, "%s %s</P>", PROCINFO[PROC_OSTYPE], PROCINFO[PROC_OSRELEASE]);
		// version
			fprintf (fstdout, "<P><B>Kernel Revision:</B><BR>");
			fprintf (fstdout, "%s</P>", PROCINFO[PROC_VERSION]);
		// cmdline
			fprintf (fstdout, "<P><B>Command Line:</B><BR>");
			fprintf (fstdout, "%s</P>", PROCINFO[PROC_CMDLINE]);
		// modprobe
			if (KERNEL != VER20) {
				fprintf (fstdout, "<P><B>Location of modprobe:</B><BR>");
				fprintf (fstdout, "%s</P>", PROCINFO[PROC_MODPROBE]);
			}
		// modules
			if (NUM_MODULES==-1) fprintf (fstdout, "<P><B>Modules:</B><BR>None Loaded</P>");
			else {
				fprintf (fstdout, "<P><B>Modules:</B><BR>");
				fprintf (fstdout, "Name Size Usage<BR>");
				for (i=0; i<=NUM_MODULES; i++)
					fprintf (fstdout, "%s<BR>", *MODULES[i]);
				fprintf (fstdout, "</P>");
			}
		}
	// Filesystems
		if (OPT_SHOW_FILESYS==1) {
		fprintf (fstdout, "<H1>File System Information:</H1>");
		// disk usage
			fprintf (fstdout, "<P><B>Disk Usage:</B>");
			fprintf (fstdout, "<TABLE>");
			fprintf (fstdout, "<TR><TD>Total IO:</TD><TD>%7d</TD></TR>", PROC_DISK);
			fprintf (fstdout, "<TR><TD>Read IO:</TD><TD>%7d</TD></TR>", PROC_DISKRIO);
			fprintf (fstdout, "<TR><TD>Write IO:</TD><TD>%7d</TD></TR>", PROC_DISKWIO);
			fprintf (fstdout, "<TR><TD>Read Blocks:</TD><TD>%7d</TD></TR>", PROC_DISKRBLK);
			fprintf (fstdout, "<TR><TD>Write Blocks:</TD><TD>%7d</TD></TR>", PROC_DISKWBLK);
			fprintf (fstdout, "</TABLE></P>");
		// page file usage
			fprintf (fstdout, "<P><B>Page File Usage:</B>");
			fprintf (fstdout, "<TABLE>");
			fprintf (fstdout, "<TR><TD>Pages In:</TD><TD>%7s</TD></TR>", PROCINFO[PROC_PAGE_IN]);
			fprintf (fstdout, "<TR><TD>Pages Out:</TD><TD>%7s</TD></TR>", PROCINFO[PROC_PAGE_OUT]);
			fprintf (fstdout, "</TABLE></P>");
		// swap page usage
			fprintf (fstdout, "<P><B>Swap Page Usage:</B>");
			fprintf (fstdout, "<TABLE>");
			fprintf (fstdout, "<TR><TD>Swap Pages In:</TD><TD>%7s</TD></TR>", PROCINFO[PROC_SWAP_IN]);
			fprintf (fstdout, "<TR><TD>Swap Pages Out:</TD><TD>%7s</TD></TR>", PROCINFO[PROC_SWAP_OUT]);
			fprintf (fstdout, "</TABLE></P>");
		// support filesystems
			if (NUM_FILESYS>=0) {
				fprintf (fstdout, "<P><B>Supported Filesystems:</B><BR>");
				for (i=0; i<=NUM_FILESYS; i++) {
					if (strlen(FILESYS[i]->DEV)>0)
						fprintf (fstdout, "%-12s (%s)<BR>", FILESYS[i]->NAME, FILESYS[i]->DEV);
					else
						fprintf (fstdout, "%s<BR>", FILESYS[i]->NAME);
				}
				fprintf (fstdout, "</P>");
			}
		// partitions
			if (NUM_PARTS>=0) {
				fprintf (fstdout, "<P><B>Disk Partitions:</B><BR>");
				for (i=0; i<=NUM_PARTS; i++)
					fprintf (fstdout, "%s<BR>", *PARTS[i]);
				fprintf (fstdout, "</P>");
			}
		// mounts
			if (NUM_MOUNTS>=0) {
				fprintf (fstdout, "<P><B>Mounted Filesystems:</B>");
				fprintf (fstdout, "<TABLE>");
				fprintf (fstdout, "<TR><TD>%-20s</TD><TD>%-20s</TD><TD>%-15s</TD><TD>%-10s</TD></TR>", "Device", "Mountpoint", "Filesystem", "Modes");
				for (i=0; i<=NUM_MOUNTS; i++)
					fprintf (fstdout, "<TR><TD>%-20s</TD><TD>%-20s</TD><TD>%-15s</TD><TD>%-10s</TD></TR>", MOUNTS[i]->DEVICE, MOUNTS[i]->MOUNTPOINT, MOUNTS[i]->FILESYS, MOUNTS[i]->MODE);
				fprintf (fstdout, "</TABLE></P>");
			}
		// swaps
			if (NUM_SWAPS>=0) {
				fprintf (fstdout, "<P><B>Swap Filesystems:</B><BR>");
				fprintf (fstdout, "%-20s%-10s%-10s<BR>", "Device", "Size", "Used");
				for (i=0; i<=NUM_SWAPS; i++)
					fprintf (fstdout, "%s<BR>", *SWAPS[i]);
				fprintf (fstdout, "</P>");
			}
		}
	// Network
		if (OPT_SHOW_NETWORK==1) {
		fprintf (fstdout, "<H1>Network Information:</H1>");
		// hostname and domainname
			fprintf (fstdout, "<P><B>Host Name:</B> %s<BR>", PROCINFO[PROC_HOSTNAME]);
			fprintf (fstdout, "<B>Domain Name:</B> %s</P>", PROCINFO[PROC_DOMAINNAME]);
		}
	// Processes
		if (OPT_SHOW_PROCESS==1) {
		fprintf (fstdout, "<H1>Process Information:</H1>");
		// processes
			fprintf (fstdout, "<P><B>Number of Processes Run:</B><BR>");
			fprintf (fstdout, "%s</P>", PROCINFO[PROC_PROCESS]);
		// number of currently running processes
			fprintf (fstdout, "<P><B>Number of Currently Running Processes:</B><BR>");
			fprintf (fstdout, "%d</P>", NUM_PROC + 1);
		// process information
			fprintf (fstdout, "<P><B>Currently Running Processes:</B><BR>");
			for (i=0; i<=NUM_PROC; i++) {
				fprintf (fstdout, "%s (%ld)  -  %s", PROC[i]->NAME, PROC[i]->PID, PROC[i]->STATE);
				fprintf (fstdout, "<UL><TABLE>");
				fprintf (fstdout, "<TR><TD>Command Line:</TD><TD>%s</TD></TR>", PROC[i]->CMDLINE);
				fprintf (fstdout, "<TR><TD>Working Directory:</TD><TD>%s</TD></TR>", PROC[i]->CWD);
				fprintf (fstdout, "<TR><TD>Executable File:</TD><TD>%s</TD></TR>", PROC[i]->EXE);
				fprintf (fstdout, "<TR><TD>Files in Use (%d):</TD></TR>", PROC[i]->NUM_FILES+1);
				if (PROC[i]->NUM_FILES>=0) {
					fprintf (fstdout, "<TR><TD></TD><TD>");
					for (j=0; j<=PROC[i]->NUM_FILES; j++)
						fprintf (fstdout, "%s<BR>", PROC[i]->FILES[j]);
					fprintf (fstdout, "</TD></TR>");
				}
				// Find Parent Process
				tmpstring[0]=0;
				for (j=0; j<=NUM_PROC; j++) {
					if (PROC[j]->PID==PROC[i]->PPID)
						strcpy (tmpstring, PROC[j]->NAME);
				}
				if (strlen(tmpstring)==0) strcpy (tmpstring, "Unknown");
				fprintf (fstdout, "<TR><TD>Parent Process:</TD><TD>%s (%d)</TD></TR>", tmpstring, PROC[i]->PPID);
				fprintf (fstdout, "<TR><TD>Group ID:</TD><TD>%d</TD></TR>", PROC[i]->PGRP);
				fprintf (fstdout, "<TR><TD>Session ID:</TD><TD>%d</TD></TR>", PROC[i]->SESSION);
				fprintf (fstdout, "<TR><TD>TTY:</TD><TD>%s</TD></TR>", PROC[i]->TTY);
				fprintf (fstdout, "<TR><TD>TTY Group ID:</TD><TD>%d</TD></TR>", PROC[i]->TPGID);
				fprintf (fstdout, "<TR><TD>User Time:</TD><TD>%d Jiffies</TD></TR>", PROC[i]->UTIME);
				fprintf (fstdout, "<TR><TD>System Time:</TD><TD>%d Jiffies</TD></TR>", PROC[i]->STIME);
				fprintf (fstdout, "<TR><TD>Priority Level:</TD><TD>%d</TD></TR>", PROC[i]->PRIORITY);
				fprintf (fstdout, "<TR><TD>Start Time:</TD><TD>%s</TD></TR>", PROC[i]->STARTTIME);
				fprintf (fstdout, "<TR><TD>Total Time:</TD><TD>%s</TD></TR>", PROC[i]->TOTALTIME);
				fprintf (fstdout, "<TR><TD>Virtual Memory Size:</TD><TD>%d bytes</TD></TR>", PROC[i]->VSIZE);
				fprintf (fstdout, "<TR><TD>Start Code:</TD><TD>%d</TD></TR>", PROC[i]->STARTCODE);
				fprintf (fstdout, "<TR><TD>End Code:</TD><TD>%d</TD></TR>", PROC[i]->ENDCODE);
				fprintf (fstdout, "</TABLE></UL>");
			}
			fprintf (fstdout, "</P>");
		}
	// Return
	fprintf (fstdout, "<BR><BR>\n");
	fprintf (fstdout, "</BODY></HTML>\n");
	fstdout=stderr;
	return;
}

