/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    dump.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// display_dump() Function
void display_dump () {
	int i=0;
	int j=0;
	char tmpstring [INPUT_STRING];

	// Display All proc Filesystem Information
	fprintf (fstdout, "si:  Dumping Information\n");
	fprintf (fstdout, "\n");
	// si
		fprintf (fstdout, "\nsi - Program Information:\n");
		fprintf (fstdout, "  %s\n", PROCINFO[PROC_EXINFO]);
	// System
		if (OPT_SHOW_SYSTEM==1) {
		fprintf (fstdout, "\nSystem Information:\n");
		// cpu information
			fprintf (fstdout, "  CPU Information:\n");
			if (NUM_CPU>=0) {
				fprintf (fstdout, "\tNumber of CPUs:\t%i\n", NUM_CPU + 1);
				for (i=0; i<=NUM_CPU; i++) {
					fprintf (fstdout, "\tProcessor #%i Information:\n", i);
					fprintf (fstdout, "\t\tVendor:\t%s\n", CPU[i]->VENDOR);
					fprintf (fstdout, "\t\tModel:\t%s\n", CPU[i]->MODEL);
					if (KERNEL != VER20) {
						fprintf (fstdout, "\t\tSpeed:\t%s MHz\n", CPU[i]->SPEED);
						fprintf (fstdout, "\t\tCache:\t%s\n", CPU[i]->CACHE);
						fprintf (fstdout, "\t\tCPU Usage By Priority Modes:\n");
						fprintf (fstdout, "\t\t\tUser Mode:\t%s\n", CPU[i]->USER);
						fprintf (fstdout, "\t\t\tNice Mode:\t%s\n", CPU[i]->NICE);
						fprintf (fstdout, "\t\t\tSystem Mode:\t%s\n", CPU[i]->SYS);
						fprintf (fstdout, "\t\t\tIdle Mode:\t%s\n", CPU[i]->IDLE);
					}
				}
			}
			fprintf (fstdout, "\tTotal CPU Usage By Priority Modes:\n");
			fprintf (fstdout, "\t\tUser Mode:\t%s\n", PROCINFO[PROC_CPUUSER]);
			fprintf (fstdout, "\t\tNice Mode:\t%s\n", PROCINFO[PROC_CPUNICE]);
			fprintf (fstdout, "\t\tSystem Mode:\t%s\n", PROCINFO[PROC_CPUSYS]);
			fprintf (fstdout, "\t\tIdle Mode:\t%s\n", PROCINFO[PROC_CPUIDLE]);
		// load averages
			fprintf (fstdout, "  Load Averages (previous one, five, and fifteen minutes):\n");
			fprintf (fstdout, "\tOne: %s\tFive: %s\tFifteen: %s\n", PROCINFO[PROC_LOADAVG_1], PROCINFO[PROC_LOADAVG_5], PROCINFO[PROC_LOADAVG_15]);
		// boottime
			fprintf (fstdout, "  Boot Time:\n");
			fprintf (fstdout, "\t%s\n", PROCINFO[PROC_BTIME]);
		// uptime
			fprintf (fstdout, "  Uptime:\n");
			fprintf (fstdout, "\t%s\n", PROCINFO[PROC_UPTIME]);
		// context switches
			fprintf (fstdout, "  Number of Context Switches System Underwent:\n");
			fprintf (fstdout, "\t%s\n", PROCINFO[PROC_CTXT]);
		}
	// Hardware
		if (OPT_SHOW_HARDWARE==1) {
			fprintf (fstdout, "\nHardware Information:\n");
			// devices
			if (NUM_CHARDEV>=0) {
				fprintf (fstdout, "  Character Devices:\n");
				fprintf (fstdout, "        Num\tDevice\n");
				for (i=0; i<=NUM_CHARDEV; i++)
					fprintf (fstdout, "\t%3d\t%s\n", CHARDEV[i]->NUMBER, CHARDEV[i]->NAME);
			}
			if (NUM_BLOCKDEV>=0) {
				fprintf (fstdout, "  Block Devices:\n");
				fprintf (fstdout, "        Num\tDevice\n");
				for (i=0; i<=NUM_BLOCKDEV; i++)
					fprintf (fstdout, "\t%3d\t%s\n", BLOCKDEV[i]->NUMBER, BLOCKDEV[i]->NAME);
			}
			// misc
			if (NUM_MISC>=0) {
				fprintf (fstdout, "  Miscellaneous Devices:\n");
				fprintf (fstdout, "        Num\tDevice\n");
				for (i=0; i<=NUM_MISC; i++)
					fprintf (fstdout, "\t%3d\t%s\n", MISC[i]->NUMBER, MISC[i]->NAME);
			}
			// isa dma channels
			if (NUM_ISADMA>=0) {
				fprintf (fstdout, "  Registered ISA DMA (Direct Memory Access) Channels:\n");
				fprintf (fstdout, "        Num\tDevice\n");
				for (i=0; i<=NUM_ISADMA; i++)
					fprintf (fstdout, "\t%3d\t%s\n", ISADMA[i]->NUMBER, ISADMA[i]->NAME);
			}
			// irq interrupts
			if (NUM_IRQINT>=0) {
				fprintf (fstdout, "  IRQ Interrupts:\n");
				if (KERNEL == VER20) {
					fprintf (fstdout, "\t INT          CPU  Name\n");
					for (i=0; i<=NUM_IRQINT; i++)
						fprintf (fstdout, "\t%s\n", *IRQINT[i]);
				}
				else {
					fprintf (fstdout, "\tINT");
					for (i=0; i<=NUM_CPU; i++)
						fprintf (fstdout, "          CPU%d", i);
					fprintf (fstdout, "       Controller  Name\n");
					for (i=0; i<=NUM_IRQINT; i++)
						fprintf (fstdout, "\t%s\n", *IRQINT[i]);
				}
			}
			// ioports
			if (NUM_IOPORTS>=0) {
				fprintf (fstdout, "  IO (Input-Output) Ports:\n");
				fprintf (fstdout, "\t Address    Name\n");
				for (i=0; i<=NUM_IOPORTS; i++)
					fprintf (fstdout, "\t%s\n", *IOPORTS[i]);
			}
			// tty drivers
			if (NUM_TTYDRIVERS>=0) {
				fprintf (fstdout, "  TTY Drivers:\n");
				for (i=0; i<=NUM_TTYDRIVERS; i++) {
					fprintf (fstdout, "\t%s\n", TTYDRIVERS[i]->DRIVER);
					fprintf (fstdout, "\t\tName: \t%s\n", TTYDRIVERS[i]->NAME);
					fprintf (fstdout, "\t\tMajor:\t%s\n", TTYDRIVERS[i]->MAJOR);
					fprintf (fstdout, "\t\tRange:\t%s\n", TTYDRIVERS[i]->RANGE);
					fprintf (fstdout, "\t\tType: \t%s\n", TTYDRIVERS[i]->TYPE);
				}
			}
			// tty ldiscs
			if (NUM_TTYLDISCS>=0) {
				fprintf (fstdout, "  TTY ldiscs:\n");
				for (i=0; i<=NUM_TTYLDISCS; i++)
					fprintf (fstdout, "\t%-20s %d\n", TTYLDISCS[i]->NAME, TTYLDISCS[i]->COUNT);
			}
			// ide drivers
			if (NUM_IDEDRV>=0) {
				fprintf (fstdout, "  IDE Drivers:\n");
				for (i=0; i<=NUM_IDEDRV; i++)
					fprintf (fstdout, "\t%-20s (Version: %s)\n", IDEDRV[i]->NAME, IDEDRV[i]->VERSION);
			}
			// ide devices
			if (NUM_IDEDEV>=0) {
				fprintf (fstdout, "  IDE Devices:\n");
				for (i=0; i<=NUM_IDEDEV; i++) {
					fprintf (fstdout, "\t%s (%s)\n", IDEDEV[i]->NAME, IDEDEV[i]->PARENT);
					fprintf (fstdout, "\t\tDriver:\t%s\n", IDEDEV[i]->DRIVER);
					fprintf (fstdout, "\t\tMedia: \t%s\n", IDEDEV[i]->MEDIA);
					fprintf (fstdout, "\t\tModel: \t%s\n", IDEDEV[i]->MODEL);
					fprintf (fstdout, "\t\tCylinders:  %d  Heads:  %d  Sectors:  %d\n", IDEDEV[i]->CYL, IDEDEV[i]->HEAD, IDEDEV[i]->SECT);
				}
			}
			// scsi drivers
			if (NUM_SCSIDRV>=0) {
				fprintf (fstdout, "  SCSI Drivers:\n");
				for (i=0; i<=NUM_SCSIDRV; i++) {
					fprintf (fstdout, "\t%s\n", SCSIDRV[i]->NAME);
					fprintf (fstdout, "\t\t%s\n", SCSIDRV[i]->DESC);
				}
			}
			// scsi devices
			if (NUM_SCSIDEV>=0) {
				fprintf (fstdout, "  SCSI Devices:\n");
				for (i=0; i<=NUM_SCSIDEV; i++) {
					fprintf (fstdout, "\t%s %s  (%d,%d,%d)\n", SCSIDEV[i]->VENDOR, SCSIDEV[i]->MODEL, SCSIDEV[i]->CHANNEL, SCSIDEV[i]->ID, SCSIDEV[i]->LUN);
					fprintf (fstdout, "\t\tHardware Revision:  \t%s\n", SCSIDEV[i]->REV);
					fprintf (fstdout, "\t\tHardware Type:      \t%s\n", SCSIDEV[i]->TYPE);
					fprintf (fstdout, "\t\tHost Name:          \t%s\n", SCSIDEV[i]->HOST);
					fprintf (fstdout, "\t\tANSI SCSI Revision: \t%s\n", SCSIDEV[i]->ANSIREV);
				}
			}
			// parallel port settings
			if (NUM_PARPORT>=0) {
				fprintf (fstdout, "  Parallel Port Settings:\n");
				for (i=0; i<=NUM_PARPORT; i++) {
					fprintf (fstdout, "\tParallel Port #%s\n", PARPORT[i]->NAME);
					fprintf (fstdout, "\t\tAutoprobe Results:  %s\n", PARPORT[i]->AUTOPROBE);
					fprintf (fstdout, "\t\tDevices:            %s\n", PARPORT[i]->DEVICES);
					fprintf (fstdout, "\t\tBase IO-Port:       %s\n", PARPORT[i]->IOPORT);
					fprintf (fstdout, "\t\tIRQ:                %s\n", PARPORT[i]->IRQ);
					fprintf (fstdout, "\t\tDMA:                %s\n", PARPORT[i]->DMA);
					fprintf (fstdout, "\t\tModes:              %s\n", PARPORT[i]->PORTTYPE);
				}
			}
			// sound settings
			if (strlen(PROCINFO[PROC_SOUNDDRV])>0) {
				fprintf (fstdout, "  Sound Software:\n");
				fprintf (fstdout, "\t%s\n", PROCINFO[PROC_SOUNDDRV]);
			}
			if (NUM_SNDDRV>=0) {
				fprintf (fstdout, "  Sound Drivers:\n");
				for (i=0; i<=NUM_SNDDRV; i++)
					fprintf (fstdout, "\t%s\n", *SNDDRV[i]);
			}
			if (NUM_SNDCONF>=0) {
				fprintf (fstdout, "  Sound Card Configuration:\n");
				for (i=0; i<=NUM_SNDCONF; i++)
					fprintf (fstdout, "\t%s\n", *SNDCONF[i]);
			}
			if (NUM_SNDAUDIO>=0) {
				fprintf (fstdout, "  Sound Audio Devices:\n");
				for (i=0; i<=NUM_SNDAUDIO; i++)
					fprintf (fstdout, "\t%s\n", *SNDAUDIO[i]);
			}
			if (NUM_SNDSYNTH>=0) {
				fprintf (fstdout, "  Sound Synthesizer Devices:\n");
				for (i=0; i<=NUM_SNDSYNTH; i++)
					fprintf (fstdout, "\t%s\n", *SNDSYNTH[i]);
			}
			if (NUM_SNDMIDI>=0) {
				fprintf (fstdout, "  Sound MIDI Devices:\n");
				for (i=0; i<=NUM_SNDMIDI; i++)
					fprintf (fstdout, "\t%s\n", *SNDMIDI[i]);
			}
			if (NUM_SNDTIMERS>=0) {
				fprintf (fstdout, "  Sound Timers:\n");
				for (i=0; i<=NUM_SNDTIMERS; i++)
					fprintf (fstdout, "\t%s\n", *SNDTIMERS[i]);
			}
			if (NUM_SNDMIXERS>=0) {
				fprintf (fstdout, "  Sound Mixers:\n");
				for (i=0; i<=NUM_SNDMIXERS; i++)
					fprintf (fstdout, "\t%s\n", *SNDMIXERS[i]);
			}
		}
	// Memory
		if (OPT_SHOW_MEMORY==1) {
			fprintf (fstdout, "\nMemory Information:\n");
			fprintf (fstdout, "    Total Memory:   %7s kb\n", PROCINFO[PROC_MEMTOTAL]);
			fprintf (fstdout, "    Free Memory:    %7s kb\n", PROCINFO[PROC_MEMFREE]);
			fprintf (fstdout, "    Shared Memory:  %7s kb\n", PROCINFO[PROC_MEMSHARED]);
			fprintf (fstdout, "    Buffers:        %7s kb\n", PROCINFO[PROC_BUFFERS]);
			fprintf (fstdout, "    Cached Memory:  %7s kb\n", PROCINFO[PROC_CACHED]);
			fprintf (fstdout, "    Total Swap:     %7s kb\n", PROCINFO[PROC_SWAPTOTAL]);
			fprintf (fstdout, "    Free Swap:      %7s kb\n", PROCINFO[PROC_SWAPFREE]);
			fprintf (fstdout, "  MTRR (Memory Type Range Register) Configuration:\n");
			if (NUM_MTRR==-1) fprintf (fstdout, "    MTRR Support Not Availible.\n");
			for (i=0; i<=NUM_MTRR; i++) {
				fprintf (fstdout, "\tRegister %d:\t\t(Size=%dMB)\n", MTRR[i]->REG, MTRR[i]->SIZE);
				fprintf (fstdout, "\t\tOffset: \t%10s  (%dMB)\n", MTRR[i]->OFFHEX, MTRR[i]->OFFMB);
				fprintf (fstdout, "\t\tOptions:\t%s\n", MTRR[i]->OPTION);
				fprintf (fstdout, "\t\tCount:  \t%d\n", MTRR[i]->COUNT);
			}
		}
	// Kernel
		if (OPT_SHOW_KERNEL==1) {
		fprintf (fstdout, "\nKernel Information:\n");
		// ostype & osrelease
			fprintf (fstdout, "  Operating System:\n");
			fprintf (fstdout, "\t%s %s\n", PROCINFO[PROC_OSTYPE], PROCINFO[PROC_OSRELEASE]);
		// version
			fprintf (fstdout, "  Kernel Revision:\n");
			fprintf (fstdout, "\t%s\n", PROCINFO[PROC_VERSION]);
		// cmdline
			fprintf (fstdout, "  Command Line:\n");
			fprintf (fstdout, "\t%s\n", PROCINFO[PROC_CMDLINE]);
		// modprobe
			if (KERNEL != VER20) {
				fprintf (fstdout, "  Location of modprobe:\n");
				fprintf (fstdout, "\t%s\n", PROCINFO[PROC_MODPROBE]);
			}
		// modules
			if (NUM_MODULES==-1) fprintf (fstdout, "  Modules:\n    None Loaded\n");
			else {
				fprintf (fstdout, "  Modules:\n");
				fprintf (fstdout, "\tName                    Size      Usage\n");
				for (i=0; i<=NUM_MODULES; i++)
					fprintf (fstdout, "\t%s\n", *MODULES[i]);
			}
		}
	// Filesystems
		if (OPT_SHOW_FILESYS==1) {
		fprintf (fstdout, "\nFile System Information:\n");
		// disk usage
			fprintf (fstdout, "  Disk Usage:\n");
			fprintf (fstdout, "\tTotal IO:        %7d\n", PROC_DISK);
			fprintf (fstdout, "\tRead IO:         %7d\n", PROC_DISKRIO);
			fprintf (fstdout, "\tWrite IO:        %7d\n", PROC_DISKWIO);
			fprintf (fstdout, "\tRead Blocks:     %7d\n", PROC_DISKRBLK);
			fprintf (fstdout, "\tWrite Blocks:    %7d\n", PROC_DISKWBLK);
		// page file usage
			fprintf (fstdout, "  Page File Usage:\n");
			fprintf (fstdout, "\tPages In:        %7s\n", PROCINFO[PROC_PAGE_IN]);
			fprintf (fstdout, "\tPages Out:       %7s\n", PROCINFO[PROC_PAGE_OUT]);
		// swap page usage
			fprintf (fstdout, "  Swap Page Usage:\n");
			fprintf (fstdout, "\tSwap Pages In:   %7s\n", PROCINFO[PROC_SWAP_IN]);
			fprintf (fstdout, "\tSwap Pages Out:  %7s\n", PROCINFO[PROC_SWAP_OUT]);
		// support filesystems
			if (NUM_FILESYS>=0) {
				fprintf (fstdout, "  Supported Filesystems:\n");
				for (i=0; i<=NUM_FILESYS; i++) {
					if (strlen(FILESYS[i]->DEV)>0)
						fprintf (fstdout, "\t%-12s(%s)\n", FILESYS[i]->NAME, FILESYS[i]->DEV);
					else
						fprintf (fstdout, "\t%s\n", FILESYS[i]->NAME);
				}
			}
		// partitions
			if (NUM_PARTS>=0) {
				fprintf (fstdout, "  Disk Partitions:\n");
				for (i=0; i<=NUM_PARTS; i++)
					fprintf (fstdout, "\t%s\n", *PARTS[i]);
			}
		// mounts
			if (NUM_MOUNTS>=0) {
				fprintf (fstdout, "  Mounted Filesystems:\n");
				fprintf (fstdout, "\t%-20s%-20s%-15s%-10s\n", "Device", "Mountpoint", "Filesystem", "Modes");
				for (i=0; i<=NUM_MOUNTS; i++)
					fprintf (fstdout, "\t%-20s%-20s%-15s%-10s\n", MOUNTS[i]->DEVICE, MOUNTS[i]->MOUNTPOINT, MOUNTS[i]->FILESYS, MOUNTS[i]->MODE);
			}
		// swaps
			if (NUM_SWAPS>=0) {
				fprintf (fstdout, "  Swap Filesystems:\n");
				fprintf (fstdout, "\t%-20s%-10s%-10s\n", "Device", "Size", "Used");
				for (i=0; i<=NUM_SWAPS; i++)
					fprintf (fstdout, "\t%s\n", *SWAPS[i]);
			}
		}
	// Network
		if (OPT_SHOW_NETWORK==1) {
		fprintf (fstdout, "\nNetwork Information:\n");
		// hostname and domainname
			fprintf (fstdout, "  Host Name:\t%s\n", PROCINFO[PROC_HOSTNAME]);
			fprintf (fstdout, "  Domain Name: \t%s\n", PROCINFO[PROC_DOMAINNAME]);
		}
	// Processes
		if (OPT_SHOW_PROCESS==1) {
		fprintf (fstdout, "\nProcess Information:\n");
		// processes
			fprintf (fstdout, "  Number of Processes Run:\n");
			fprintf (fstdout, "\t%s\n", PROCINFO[PROC_PROCESS]);
		// number of currently running processes
			fprintf (fstdout, "  Number of Currently Running Processes:\n");
			fprintf (fstdout, "\t%d\n", NUM_PROC + 1);
		// process information
			fprintf (fstdout, "  Currently Running Processes:\n");
			for (i=0; i<=NUM_PROC; i++) {
				fprintf (fstdout, "    %s (%ld)  -  %s\n", PROC[i]->NAME, PROC[i]->PID, PROC[i]->STATE);
				fprintf (fstdout, "        Command Line:\t\t%s\n", PROC[i]->CMDLINE);
				fprintf (fstdout, "        Working Directory:\t%s\n", PROC[i]->CWD);
				fprintf (fstdout, "        Executable File:\t%s\n", PROC[i]->EXE);
				fprintf (fstdout, "        Files in Use (%d):\n", PROC[i]->NUM_FILES+1);
				if (PROC[i]->NUM_FILES>=0) {
					for (j=0; j<=PROC[i]->NUM_FILES; j++)
						fprintf (fstdout, "           %s\n", PROC[i]->FILES[j]);
				}
				// Find Parent Process
				tmpstring[0]=0;
				for (j=0; j<=NUM_PROC; j++) {
					if (PROC[j]->PID==PROC[i]->PPID)
						strcpy (tmpstring, PROC[j]->NAME);
				}
				if (strlen(tmpstring)==0) strcpy (tmpstring, "Unknown");
				fprintf (fstdout, "        Parent Process:\t%s (%d)\n", tmpstring, PROC[i]->PPID);
				fprintf (fstdout, "        Group ID:\t\t%d\n", PROC[i]->PGRP);
				fprintf (fstdout, "        Session ID:\t\t%d\n", PROC[i]->SESSION);
				fprintf (fstdout, "        TTY:\t\t\t%s\n", PROC[i]->TTY);
				fprintf (fstdout, "        TTY Group ID:\t\t%d\n", PROC[i]->TPGID);
				fprintf (fstdout, "        User Time:\t\t%d Jiffies\n", PROC[i]->UTIME);
				fprintf (fstdout, "        System Time:\t\t%d Jiffies\n", PROC[i]->STIME);
				fprintf (fstdout, "        Priority Level:\t\t%d\n", PROC[i]->PRIORITY);
				fprintf (fstdout, "        Start Time:\t\t%s\n", PROC[i]->STARTTIME);
				fprintf (fstdout, "        Total Time:\t\t%s\n", PROC[i]->TOTALTIME);
				fprintf (fstdout, "        Virtual Memory Size:\t%d bytes\n", PROC[i]->VSIZE);
				fprintf (fstdout, "        Start Code:\t\t%d\n", PROC[i]->STARTCODE);
				fprintf (fstdout, "        End Code:\t\t%d\n", PROC[i]->ENDCODE);
			}
		}
	// Return
	fprintf (fstdout, "\n");
	return;
}

