/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    color.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


#ifdef HAVE_LIBNCURSES
// ncurses Variables
WINDOW *win;
short COLOR_HEAD  = 1;
short COLOR_SUB   = 2;
short COLOR_DATA  = 3;
short COLOR_TOCH  = 4;
short COLOR_TOCS  = 5;
short COLOR_TITLE = 6;
// Page Variables
#define PAGE_SI		0
#define PAGE_SYS	1
#define PAGE_SYSMISC	2
#define PAGE_HARDWARE	3
#define PAGE_IRQIO	4
#define PAGE_TTY	5
#define PAGE_IDE	6
#define PAGE_SCSI	7
#define PAGE_PARPORT	8
#define PAGE_SOUND	9
#define PAGE_MEMORY	10
#define PAGE_KERNEL	11
#define PAGE_FILESYS	12
#define PAGE_DISKS	13
#define PAGE_NETWORK	14
#define PAGE_PROCESS	15
#define MAX_PAGE	15


// display_color() Function
void display_color () {
	int i=0;
	int j=0;
	int pagenum=0;
	int key;
//	char pagestr  [STORAGE_STRING];
	char col1 [STORAGE_STRING];
	char col2 [STORAGE_STRING];
	char col3 [STORAGE_STRING];

	// Start ncurses
	ncurses_init ();
	// Start Display Program Loop
	do {
		erase ();
/*		color_set (COLOR_TITLE, NULL);
		attron (WA_BOLD);
		if (pagenum==PAGE_SI)       sprintf (pagestr, "PROGRAM INFORMATION");
		if (pagenum==PAGE_SYS)      sprintf (pagestr, "SYSTEM INFORMATION");
		if (pagenum==PAGE_SYSMISC)  sprintf (pagestr, "LOAD AVERAGES/BOOTTIME/UPTIME");
		if (pagenum==PAGE_HARDWARE) sprintf (pagestr, "HARDWARE DEVICE INFORMATION");
		if (pagenum==PAGE_IRQIO)    sprintf (pagestr, "IRQ/IOPORT INFORMATION");
		if (pagenum==PAGE_TTY)      sprintf (pagestr, "TTY INFORMATION");
		if (pagenum==PAGE_IDE)      sprintf (pagestr, "IDE INFORMATION");
		if (pagenum==PAGE_SCSI)     sprintf (pagestr, "SCSI INFORMATION");
		if (pagenum==PAGE_PARPORT)  sprintf (pagestr, "PARALLEL PORT INFORMATION");
		if (pagenum==PAGE_SOUND)    sprintf (pagestr, "SOUND INFORMATION");
		if (pagenum==PAGE_MEMORY)   sprintf (pagestr, "MEMORY INFORMATION");
		if (pagenum==PAGE_KERNEL)   sprintf (pagestr, "KERNEL INFORMATION");
		if (pagenum==PAGE_FILESYS)  sprintf (pagestr, "FILESYSTEMS");
		if (pagenum==PAGE_DISKS)    sprintf (pagestr, "PARTITIONS/MOUNTS/SWAP");
		if (pagenum==PAGE_NETWORK)  sprintf (pagestr, "NETWORK INFORMATION");
		if (pagenum==PAGE_PROCESS)  sprintf (pagestr, "PROCESS INFORMATION");
		printw ("si (System Information Viewer)  -  [%s]  -  Page %d\n", pagestr, pagenum);
*/		switch (pagenum) {
			case PAGE_SI:
				// si Program Information
				headattr ();
				printw ("si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)\n");
				printw ("si:  Dumping Information\n");
//				subattr ();
//				printw ("\nProgram Navigation Help:\n");
//				dataattr ();
//				printw ("<Page Down>   or  <Space>        Next Page\n");
//				printw ("   <Page Up>  or  '-'            Previous Page\n");
//				printw ("              q                  Quit Program\n");
				subattr ();
				printw ("\nTable of Contents and Shortcut Keys:\n");
				color_set (COLOR_TOCH, NULL);
				printw ("(1)  si Program Information and Help\n");
				printw ("(S)  System Information and CPU Information\n");
				color_set (COLOR_TOCS, NULL);
				printw ("     (2)  Miscellaneous System Information (Load Averages, Uptime, Boottime)\n");
				color_set (COLOR_TOCH, NULL);
				printw ("(H)  Hardware Information (Devices)\n");
				color_set (COLOR_TOCS, NULL);
				printw ("     (3)  IRQ and IO Port Information\n");
				printw ("     (4)  TTY Information\n");
				printw ("     (5)  IDE Information\n");
				printw ("     (6)  SCSI Information\n");
				printw ("     (7)  Parallel Port Information\n");
				printw ("     (8)  Sound Information\n");
				color_set (COLOR_TOCH, NULL);
				printw ("(M)  Memory Information\n");
				printw ("(K)  Kernel Information\n");
				printw ("(F)  File System Information\n");
				color_set (COLOR_TOCS, NULL);
				printw ("     (9)  Disk Information (Partitions, Mounts, Swaps)\n");
				color_set (COLOR_TOCH, NULL);
				printw ("(N)  Network Information\n");
				printw ("(P)  Process Information\n");
				printw ("\n(Q)  Quit Program\n");
				// Break
				break;
			case PAGE_SYS:
				// System
				headattr ();
				printw ("System Information:\n");
				// cpu information
				for (i=0; i<=NUM_CPU; i++) { 
					subattr ();
					printw ("  CPU Information:\n");
					if (NUM_CPU>=0) {
						dataattr ();
						printw ("\tNumber of CPUs:\t%i\n", NUM_CPU + 1);
							printw ("\tProcessor #%i Information:\n", i);
							printw ("\t\tVendor:\t%s\n", CPU[i]->VENDOR);
							printw ("\t\tModel:\t%s\n", CPU[i]->MODEL);
							if (KERNEL != VER20) {
								printw ("\t\tSpeed:\t%s MHz\n", CPU[i]->SPEED);
								printw ("\t\tCache:\t%s\n", CPU[i]->CACHE);
								printw ("\t\tCPU Usage By Priority Modes:\n");
								printw ("\t\t\tUser Mode:\t%s\n", CPU[i]->USER);
								printw ("\t\t\tNice Mode:\t%s\n", CPU[i]->NICE);
								printw ("\t\t\tSystem Mode:\t%s\n", CPU[i]->SYS);
								printw ("\t\t\tIdle Mode:\t%s\n", CPU[i]->IDLE);
							}
					}
					subattr ();
					printw ("\tTotal CPU Usage By Priority Modes:\n");
					dataattr ();
					printw ("\t\tUser Mode:\t%s\n", PROCINFO[PROC_CPUUSER]);
					printw ("\t\tNice Mode:\t%s\n", PROCINFO[PROC_CPUNICE]);
					printw ("\t\tSystem Mode:\t%s\n", PROCINFO[PROC_CPUSYS]);
					printw ("\t\tIdle Mode:\t%s\n", PROCINFO[PROC_CPUIDLE]);
					}
				break;
			case PAGE_SYSMISC:
				// load averages
					subattr ();
					printw ("  Load Averages (previous one, five, and fifteen minutes):\n");
					dataattr ();
					printw ("\tOne: %s\tFive: %s\tFifteen: %s\n", PROCINFO[PROC_LOADAVG_1], PROCINFO[PROC_LOADAVG_5], PROCINFO[PROC_LOADAVG_15]);
				// boottime
					subattr ();
					printw ("  Boot Time:\n");
					dataattr ();
					printw ("\t%s\n", PROCINFO[PROC_BTIME]);
				// uptime
					subattr ();
					printw ("  Uptime:\n");
					dataattr ();
					printw ("\t%s\n", PROCINFO[PROC_UPTIME]);
				// context switches
					subattr ();
					printw ("  Number of Context Switches System Underwent:\n");
					dataattr ();
					printw ("\t%s\n", PROCINFO[PROC_CTXT]);
				break;
			case PAGE_HARDWARE:
				// Hardware
					headattr ();
					printw ("Hardware Information:\n");
					// devices
					if ((NUM_CHARDEV>=0) || (NUM_BLOCKDEV>=0) || (NUM_MISC>=0)) {
						subattr ();
						printw ("%-24s%-22s%s\n", "  Character Devices:", "Block Devices:", "Misc Devices:");
						dataattr ();
						printw ("%-24s%-22s%s\n", "      Num  Device", "    Num  Device", "    Num  Device");
						j=NUM_CHARDEV;
						if (NUM_BLOCKDEV>j) j=NUM_BLOCKDEV;
						if (NUM_MISC>j) j=NUM_MISC;
						for (i=0; i<=j; i++) {
							if (i<=NUM_CHARDEV)
								sprintf (col1, "      %3d  %s", CHARDEV[i]->NUMBER, CHARDEV[i]->NAME);
							else
								sprintf (col1, " ");
							if (i<=NUM_BLOCKDEV)
								sprintf (col2, "    %3d  %s", BLOCKDEV[i]->NUMBER, BLOCKDEV[i]->NAME);
							else
								sprintf (col2, " ");
							if (i<=NUM_MISC)
								sprintf (col3, "    %3d  %s", MISC[i]->NUMBER, MISC[i]->NAME);
							else
								sprintf (col3, " ");
							printw ("%-24s%-22s%s\n", col1, col2, col3); 
						}
						printw ("\n");
					}
					// isa dma channels
					if (NUM_ISADMA>=0) {
						subattr ();
						printw ("  Registered ISA DMA (Direct Memory Access) Channels:\n");
						dataattr ();
						printw ("        Num\tDevice\n");
						for (i=0; i<=NUM_ISADMA; i++)
							printw ("\t%3d\t%s\n", ISADMA[i]->NUMBER, ISADMA[i]->NAME);
					}
					break;
			case PAGE_IRQIO:
					// irq interrupts
					if (NUM_IRQINT>=0) {
						subattr ();
						printw ("  IRQ Interrupts:\n");
						dataattr ();
						if (KERNEL == VER20) {
							printw ("\t INT          CPU  Name\n");
							for (i=0; i<=NUM_IRQINT; i++)
								printw ("\t%s\n", *IRQINT[i]);
						}
						else {
							printw ("\tINT");
							for (i=0; i<=NUM_CPU; i++)
								printw ("          CPU%d", i);
							printw ("       Controller  Name\n");
							for (i=0; i<=NUM_IRQINT; i++)
								printw ("\t%s\n", *IRQINT[i]);
						}
					}
					// ioports
					if (NUM_IOPORTS>=0) {
						subattr ();
						printw ("  IO (Input-Output) Ports:\n");
						dataattr ();
						printw ("%-25s%s\n", "\t Address    Name", "\t Address    Name");
						for (i=0; i<=(NUM_IOPORTS/2); i++) {
							strcpy (col1, *IOPORTS[i]);
							if ((i+(NUM_IOPORTS/2)+1) <= NUM_IOPORTS)
								strcpy (col2, *IOPORTS[i+(NUM_IOPORTS/2)+1]);
							else
								sprintf (col2, " ");
							printw ("\t%-25s\t%s\n", col1, col2);
						}
					}
					break;
			case PAGE_TTY:
					// tty drivers
					if (NUM_TTYDRIVERS>=0) {
						subattr ();
						printw ("  TTY Drivers:\n");
						dataattr ();
						for (i=0; i<=(NUM_TTYDRIVERS/2); i++) {
							strcpy (col1, TTYDRIVERS[i]->DRIVER);
							if ( (i+(NUM_TTYDRIVERS/2)+1) <= NUM_TTYDRIVERS)
								strcpy (col2, TTYDRIVERS[i+(NUM_TTYDRIVERS/2)+1]->DRIVER);
							else
								sprintf (col2, " ");
							printw ("\t%-32s%s\n", col1, col2);
							sprintf (col1, "     Name:  %s", TTYDRIVERS[i]->NAME);
							if ( (i+(NUM_TTYDRIVERS/2)+1) <= NUM_TTYDRIVERS)
								sprintf (col2, "     Name:  %s", TTYDRIVERS[i+(NUM_TTYDRIVERS/2)+1]->NAME);
							else
								sprintf (col2, " ");
							printw ("\t%-32s%s\n", col1, col2);
/*							sprintf (col1, "     Major:     %s", TTYDRIVERS[i]->MAJOR);
							if ( (i+(NUM_TTYDRIVERS/2)+1) <= NUM_TTYDRIVERS)
								sprintf (col2, "     Major:     %s", TTYDRIVERS[i+(NUM_TTYDRIVERS/2)+1]->MAJOR);
							else
								sprintf (col2, " ");
							printw ("\t%-32s%s\n", col1, col2);
							sprintf (col1, "     Range:     %s", TTYDRIVERS[i]->RANGE);
							if ( (i+(NUM_TTYDRIVERS/2)+1) <= NUM_TTYDRIVERS)
								sprintf (col2, "     Range:     %s", TTYDRIVERS[i+(NUM_TTYDRIVERS/2)+1]->RANGE);
							else
								sprintf (col2, " ");
							printw ("\t%-32s%s\n", col1, col2);
*/							sprintf (col1, "     Type:  %s", TTYDRIVERS[i]->TYPE);
							if ( (i+(NUM_TTYDRIVERS/2)+1) <= NUM_TTYDRIVERS)
								sprintf (col2, "     Type:  %s", TTYDRIVERS[i+(NUM_TTYDRIVERS/2)+1]->TYPE);
							else
								sprintf (col2, " ");
							printw ("\t%-32s%s\n", col1, col2);
						}
					}
					// tty ldiscs
					if (NUM_TTYLDISCS>=0) {
						subattr ();
						printw ("  TTY ldiscs:\n");
						dataattr();
						for (i=0; i<=NUM_TTYLDISCS; i++)
							printw ("\t%-20s %d\n", TTYLDISCS[i]->NAME, TTYLDISCS[i]->COUNT);
					}
					if ((NUM_TTYDRIVERS<0) && (NUM_TTYLDISCS<0)) {
						dataattr ();
						printw ("\n\nNo TTY Drivers or ldiscs Information Found.\n\n");
					}
					break;
			case PAGE_IDE:
					// ide drivers
					if (NUM_IDEDRV>=0) {
						subattr ();
						printw ("  IDE Drivers:\n");
						dataattr ();
						for (i=0; i<=NUM_IDEDRV; i++)
							printw ("\t%-20s (Version: %s)\n", IDEDRV[i]->NAME, IDEDRV[i]->VERSION);
					}
					// ide devices
					if (NUM_IDEDEV>=0) {
						subattr ();
						printw ("  IDE Devices:\n");
						dataattr ();
						for (i=0; i<=NUM_IDEDEV; i++) {
							printw ("\t%s (%s)\n", IDEDEV[i]->NAME, IDEDEV[i]->PARENT);
							printw ("\t\tDriver:\t%s\n", IDEDEV[i]->DRIVER);
							printw ("\t\tMedia: \t%s\n", IDEDEV[i]->MEDIA);
							printw ("\t\tModel: \t%s\n", IDEDEV[i]->MODEL);
							printw ("\t\tCylinders:  %d  Heads:  %d  Sectors:  %d\n", IDEDEV[i]->CYL, IDEDEV[i]->HEAD, IDEDEV[i]->SECT);
						}
					}
					if ((NUM_IDEDRV<0) && (NUM_IDEDEV<0)) {
						dataattr ();
						printw ("\n\nNo IDE Drivers or Devices Found.\n\n");
					}
					break;
			case PAGE_SCSI:
					// scsi drivers
					if (NUM_SCSIDRV>=0) {
						subattr ();
						printw ("  SCSI Drivers:\n");
						dataattr ();
						for (i=0; i<=NUM_SCSIDRV; i++) {
							printw ("\t%s\n", SCSIDRV[i]->NAME);
							printw ("\t\t%s\n", SCSIDRV[i]->DESC);
						}
					}
					// scsi devices
					if (NUM_SCSIDEV>=0) {
						subattr ();
						printw ("  SCSI Devices:\n");
						dataattr();
						for (i=0; i<=NUM_SCSIDEV; i++) {
							printw ("\t%s %s  (%d,%d,%d)\n", SCSIDEV[i]->VENDOR, SCSIDEV[i]->MODEL, SCSIDEV[i]->CHANNEL, SCSIDEV[i]->ID, SCSIDEV[i]->LUN);
//							printw ("\t\tHardware Revision:   %s\n", SCSIDEV[i]->REV);
							printw ("\t\tHardware Type:  %s\n", SCSIDEV[i]->TYPE);
//							printw ("\t\tHost Name:           %s\n", SCSIDEV[i]->HOST);
//							printw ("\t\tANSI SCSI Revision:  %s\n", SCSIDEV[i]->ANSIREV);
						}
					}
					if ((NUM_SCSIDRV<0) && (NUM_SCSIDEV<0)) {
						dataattr ();
						printw ("\n\nNo SCSI Drivers or Devices Found.\n\n");
					}
					break;
			case PAGE_PARPORT:
					// parallel port settings
					if (NUM_PARPORT>=0) {
						subattr ();
						printw ("  Parallel Port Settings:\n");
						dataattr ();
						for (i=0; i<=NUM_PARPORT; i++) {
							printw ("\tParallel Port #%s\n", PARPORT[i]->NAME);
							printw ("\t\tAutoprobe Results:  %s\n", PARPORT[i]->AUTOPROBE);
							printw ("\t\tDevices:            %s\n", PARPORT[i]->DEVICES);
							printw ("\t\tBase IO-Port:       %s\n", PARPORT[i]->IOPORT);
							printw ("\t\tIRQ:                %s\n", PARPORT[i]->IRQ);
							printw ("\t\tDMA:                %s\n", PARPORT[i]->DMA);
							printw ("\t\tModes:              %s\n", PARPORT[i]->PORTTYPE);
						}
					}
					if (NUM_PARPORT<0) {
						dataattr ();
						printw ("\n\nNo Parallel Port Devices Found.\n\n");
					}
					break;
			case PAGE_SOUND:
					// sound settings
					if (strlen(PROCINFO[PROC_SOUNDDRV])>0) {
						subattr ();
						printw ("  Sound Software:\n");
						dataattr ();
						printw ("\t%s\n", PROCINFO[PROC_SOUNDDRV]);
					}
					if (NUM_SNDDRV>=0) {
						subattr ();
						printw ("  Sound Drivers:\n");
						dataattr ();
						for (i=0; i<=NUM_SNDDRV; i++)
							printw ("\t%s\n", *SNDDRV[i]);
					}
					if (NUM_SNDCONF>=0) {
						subattr ();
						printw ("  Sound Card Configuration:\n");
						dataattr ();
						for (i=0; i<=NUM_SNDCONF; i++)
							printw ("\t%s\n", *SNDCONF[i]);
					}
					if (NUM_SNDAUDIO>=0) {
						subattr ();
						printw ("  Sound Audio Devices:\n");
						dataattr ();
						for (i=0; i<=NUM_SNDAUDIO; i++)
							printw ("\t%s\n", *SNDAUDIO[i]);
					}
					if ((NUM_SNDSYNTH>=0) || (NUM_SNDMIDI>=0)) {
						subattr ();
						printw ("  %-35s%s\n", "Sound Synthesizer Devices:", "Sound MIDI Devices");
						dataattr ();
						j=NUM_SNDSYNTH;
						if (j<NUM_SNDMIDI) j=NUM_SNDMIDI;
						for (i=0; i<=j; i++) {
							if (i<=NUM_SNDSYNTH)
								strcpy (col1, *SNDSYNTH[i]);
							else
								sprintf (col1, " ");
							if (i<=NUM_SNDMIDI)
								strcpy (col2, *SNDMIDI[i]);
							else
								sprintf (col2, " ");
							printw ("\t%-35s%s\n", col1, col2);
						}
					}
					if ((NUM_SNDTIMERS>=0) || (NUM_SNDMIXERS>=0)) {
						subattr ();
						printw ("  %-35s%s\n", "Sound Timers:", "Sound Mixers:");
						dataattr ();
						j=NUM_SNDTIMERS;
						if (j<NUM_SNDMIXERS) j=NUM_SNDMIXERS;
						for (i=0; i<=NUM_SNDTIMERS; i++) {
							if (i<=NUM_SNDTIMERS)
								strcpy(col1, *SNDTIMERS[i]);
							else
								sprintf (col1, " ");
							if (i<=NUM_SNDMIXERS)
								strcpy (col2, *SNDMIXERS[i]);
							else
								sprintf (col2, " ");
							printw ("\t%-35s%s\n", col1, col2);
						}
					}
				if ((strlen(PROCINFO[PROC_SOUNDDRV])<=0) && (NUM_SNDDRV<0) && (NUM_SNDCONF<0) && (NUM_SNDAUDIO<0) && (NUM_SNDSYNTH<0) && (NUM_SNDMIDI<0) && (NUM_SNDTIMERS<0) && (NUM_SNDMIXERS<0)) {
					dataattr ();
					printw ("\n\nNo Sound Software Found.\n\n");
				}
				break;
			case PAGE_MEMORY:
				// Memory
				headattr ();
				printw ("Memory Information:\n");
				dataattr ();
				printw ("    Total Memory:   %7s kb\n", PROCINFO[PROC_MEMTOTAL]);
				printw ("    Free Memory:    %7s kb\n", PROCINFO[PROC_MEMFREE]);
				printw ("    Shared Memory:  %7s kb\n", PROCINFO[PROC_MEMSHARED]);
				printw ("    Buffers:        %7s kb\n", PROCINFO[PROC_BUFFERS]);
				printw ("    Cached Memory:  %7s kb\n", PROCINFO[PROC_CACHED]);
				printw ("    Total Swap:     %7s kb\n", PROCINFO[PROC_SWAPTOTAL]);
				printw ("    Free Swap:      %7s kb\n", PROCINFO[PROC_SWAPFREE]);
				subattr ();
				printw ("    MTRR (Memory Type Range Register) Configuration:\n");
				dataattr ();
				if (NUM_MTRR==-1) printw ("\tMTRR Support Not Availible.\n");
				for (i=0; i<=NUM_MTRR; i++) {
					printw ("\tRegister %d:\t\t(Size=%dMB)\n", MTRR[i]->REG, MTRR[i]->SIZE);
					printw ("\t\tOffset: \t%10s  (%dMB)\n", MTRR[i]->OFFHEX, MTRR[i]->OFFMB);
					printw ("\t\tOptions:\t%s\n", MTRR[i]->OPTION);
					printw ("\t\tCount:  \t%d\n", MTRR[i]->COUNT);
				}
				break;
			case PAGE_KERNEL:
				// Kernel
				headattr ();
				printw ("Kernel Information:\n");
				// ostype & osrelease
					subattr ();
					printw ("  Operating System:\n");
					dataattr ();
					printw ("\t%s %s\n", PROCINFO[PROC_OSTYPE], PROCINFO[PROC_OSRELEASE]);
				// version
					subattr ();
					printw ("  Kernel Revision:\n");
					dataattr ();
					printw ("\t%s\n", PROCINFO[PROC_VERSION]);
				// cmdline
					subattr ();
					printw ("  Command Line:\n");
					dataattr ();
					printw ("\t%s\n", PROCINFO[PROC_CMDLINE]);
				// modprobe
					if (KERNEL != VER20) {
						subattr ();
						printw ("  Location of modprobe:\n");
						dataattr ();
						printw ("\t%s\n", PROCINFO[PROC_MODPROBE]);
					}
				// modules
					subattr ();
					if (NUM_MODULES==-1) {
						printw ("  Modules:\n");
						dataattr();
						printw ("\tNone Loaded\n");
					}
					else {
						printw ("  Modules:\n");
						dataattr ();
						printw ("\tName                    Size      Usage\n");
						for (i=0; i<=NUM_MODULES; i++)
							printw ("\t%s\n", *MODULES[i]);
					}
				break;
			case PAGE_FILESYS:
				// Filesystems
				headattr ();
				printw ("File System Information:\n");
				// disk usage
					subattr ();
					printw ("  %-35s%s\n", "Disk Usage:", "Supported Filesystems:");
					dataattr ();
					for (i=0; i<=NUM_FILESYS; i++) {
						sprintf (col1, "                                        ");
						if (i==0) sprintf(col1,  "\tTotal IO:        %7d", PROC_DISK);
						if (i==1) sprintf(col1,  "\tRead IO:         %7d", PROC_DISKRIO);
						if (i==2) sprintf(col1,  "\tWrite IO:        %7d", PROC_DISKWIO);
						if (i==3) sprintf(col1,  "\tRead Blocks:     %7d", PROC_DISKRBLK);
						if (i==4) sprintf(col1,  "\tWrite Blocks:    %7d", PROC_DISKWBLK);
						// page file usage
						if (i==5) {
							subattr  ();
							sprintf(col1,    "Page File Usage:                        ");
						}
						if (i==6) sprintf(col1,  "\tPages In:        %7s", PROCINFO[PROC_PAGE_IN]);
						if (i==7) sprintf(col1,  "\tPages Out:       %7s", PROCINFO[PROC_PAGE_OUT]);
						// swap page usage
						if (i==8) {
							subattr ();
							sprintf(col1,    "Swap Page Usage:                        ");
						}
						if (i==9) sprintf(col1,  "\tSwap Pages In:   %7s", PROCINFO[PROC_SWAP_IN]);
						if (i==10) sprintf(col1, "\tSwap Pages Out:  %7s", PROCINFO[PROC_SWAP_OUT]);
						// support filesystems
						if (strlen(FILESYS[i]->DEV)>0)
							sprintf(col2, "%-12s(%s)", FILESYS[i]->NAME, FILESYS[i]->DEV);
						else
							sprintf(col2, "%s", FILESYS[i]->NAME);
						printw ("  %-35s\t", col1);
						dataattr ();
						printw ("%s\n", col2);
					}
					break;
			case PAGE_DISKS:
				// partitions
					if (NUM_PARTS>=0) {
						subattr ();
						printw ("  Disk Partitions:\n");
						dataattr ();
						for (i=0; i<=NUM_PARTS; i++)
							printw ("\t%s\n", *PARTS[i]);
					}
				// mounts
					if (NUM_MOUNTS>=0) {
						subattr ();
						printw ("  Mounted Filesystems:\n");
						dataattr ();
						printw ("\t%-20s%-20s%-15s%-10s\n", "Device", "Mountpoint", "Filesystem", "Modes");
						for (i=0; i<=NUM_MOUNTS; i++)
							printw ("\t%-20s%-20s%-15s%-10s\n", MOUNTS[i]->DEVICE, MOUNTS[i]->MOUNTPOINT, MOUNTS[i]->FILESYS, MOUNTS[i]->MODE);
					}
				// swaps
					if (NUM_SWAPS>=0) {
						subattr ();
						printw ("  Swap Filesystems:\n");
						dataattr ();
						printw ("\t%-20s%-10s%-10s\n", "Device", "Size", "Used");
						for (i=0; i<=NUM_SWAPS; i++)
							printw ("\t%s\n", *SWAPS[i]);
					}
				break;
			case PAGE_NETWORK:
				// Network
				headattr ();
				printw ("Network Information:\n");
				// hostname and domainname
					dataattr();
					printw ("  Host Name:\t%s\n", PROCINFO[PROC_HOSTNAME]);
					printw ("  Domain Name: \t%s\n", PROCINFO[PROC_DOMAINNAME]);
				break;
			case PAGE_PROCESS:
				// Processes
				headattr ();
				printw ("Process Information:\n");
				// processes
					subattr ();
					printw ("  Number of Processes Run:\n");
					dataattr ();
					printw ("\t%s\n", PROCINFO[PROC_PROCESS]);
				// number of currently running processes
					subattr ();
					printw ("  Number of Currently Running Processes:\n");
					dataattr ();
					printw ("\t%d\n", NUM_PROC + 1);
				// process information
					subattr ();
					printw ("  Currently Running Processes:\n");
					dataattr ();
					for (i=0; i<=(NUM_PROC/3); i++) {
						if (i<=NUM_PROC)
							sprintf (col1, "    %s (%ld)", PROC[i]->NAME, PROC[i]->PID);
						else
							sprintf (col1, " ");
						if (i+(NUM_PROC/3)+1 <= NUM_PROC)
							sprintf (col2, "    %s (%ld)", PROC[i+(NUM_PROC/3)+1]->NAME, PROC[i+(NUM_PROC/3)+1]->PID);
						else
							sprintf (col2, " ");
						if (i+(2*NUM_PROC/3)+2 <= NUM_PROC)
							sprintf (col3, "    %s (%ld)", PROC[i+(2*NUM_PROC/3)+2]->NAME, PROC[i+(2*NUM_PROC/3)+2]->PID);
						else
							sprintf (col3, " ");
						printw ("%20s%20s%20s\n", col1, col2, col3);
/*						printw ("    %s (%ld)  -  %s\n", PROC[i]->NAME, PROC[i]->PID, PROC[i]->STATE);
						printw ("        Command Line:\t\t%s\n", PROC[i]->CMDLINE);
						printw ("        Working Directory:\t%s\n", PROC[i]->CWD);
						printw ("        Executable File:\t%s\n", PROC[i]->EXE);
						printw ("        Files in Use (%d):\n", PROC[i]->NUM_FILES+1);
						if (PROC[i]->NUM_FILES>=0) {
							for (j=0; j<=PROC[i]->NUM_FILES; j++)
								printw ("           %s\n", PROC[i]->FILES[j]);
						}
						// Find Parent Process
						tmpstring[0]=0;
						for (j=0; j<=NUM_PROC; j++) {
							if (PROC[j]->PID==PROC[i]->PPID)
								strcpy (tmpstring, PROC[j]->NAME);
						}
						if (strlen(tmpstring)==0) strcpy (tmpstring, "Unknown");
						printw ("        Parent Process:\t%s (%d)\n", tmpstring, PROC[i]->PPID);
						printw ("        Group ID:\t\t%d\n", PROC[i]->PGRP);
						printw ("        Session ID:\t\t%d\n", PROC[i]->SESSION);
						printw ("        TTY:\t\t\t%s\n", PROC[i]->TTY);
						printw ("        TTY Group ID:\t\t%d\n", PROC[i]->TPGID);
						printw ("        User Time:\t\t%d Jiffies\n", PROC[i]->UTIME);
						printw ("        System Time:\t\t%d Jiffies\n", PROC[i]->STIME);
						printw ("        Priority Level:\t\t%d\n", PROC[i]->PRIORITY);
						printw ("        Start Time:\t\t%s\n", PROC[i]->STARTTIME);
						printw ("        Total Time:\t\t%s\n", PROC[i]->TOTALTIME);
						printw ("        Virtual Memory Size:\t%d bytes\n", PROC[i]->VSIZE);
						printw ("        Start Code:\t\t%d\n", PROC[i]->STARTCODE);
						printw ("        End Code:\t\t%d\n", PROC[i]->ENDCODE);
*/					}
				break;
		}
		dataattr ();
		attron (WA_BOLD);
//		printw ("\n\nPress A Key To Continue...");
		key=getch();
		switch (key) {
			case ' ':
			case KEY_NPAGE:
				if (pagenum!=MAX_PAGE) pagenum++;
				break;
			case '-':
			case KEY_PPAGE:
				if (pagenum!=0) pagenum--;
				break;
			case 'q':
				// Quit Program
				endwin ();
				return;
				break;
			case '1':
				pagenum=PAGE_SI;
				break;
			case 's':
			case 'S':
				pagenum=PAGE_SYS;
				break;
			case '2':
				pagenum=PAGE_SYSMISC;
				break;
			case 'h':
			case 'H':
				pagenum=PAGE_HARDWARE;
				break;
			case '3':
				pagenum=PAGE_IRQIO;
				break;
			case '4':
				pagenum=PAGE_TTY;
				break;
			case '5':
				pagenum=PAGE_IDE;
				break;
			case '6':
				pagenum=PAGE_SCSI;
				break;
			case '7':
				pagenum=PAGE_PARPORT;
				break;
			case '8':
				pagenum=PAGE_SOUND;
				break;
			case 'm':
			case 'M':
				pagenum=PAGE_MEMORY;
				break;
			case 'k':
			case 'K':
				pagenum=PAGE_KERNEL;
				break;
			case 'f':
			case 'F':
				pagenum=PAGE_FILESYS;
				break;
			case '9':
				pagenum=PAGE_DISKS;
				break;
			case 'n':
			case 'N':
				pagenum=PAGE_NETWORK;
				break;
			case 'p':
			case 'P':
				pagenum=PAGE_PROCESS;
				break;
		}
	} while (0==0);
	// Return
	endwin ();
	return;
}

// ncurses_init() Function
void ncurses_init () {
	int ret;

	// Initiate ncurses
	win=initscr();
	if (win==NULL) error_handler(ERROR_NCURSES);
	ret=start_color();
	if (ret==ERR) fprintf (stderr, "si:  ERROR:  start_color():  proceeding without color\n");
	noecho ();
	keypad (stdscr, TRUE);
	// Setup Color Tables
	init_pair (COLOR_HEAD,  COLOR_BLUE,    COLOR_BLACK);
	init_pair (COLOR_SUB,   COLOR_GREEN,   COLOR_BLACK);
	init_pair (COLOR_DATA,  COLOR_WHITE,   COLOR_BLACK);
	init_pair (COLOR_TOCH,  COLOR_WHITE,   COLOR_BLACK);
	init_pair (COLOR_TOCS,  COLOR_WHITE,   COLOR_BLACK);
	init_pair (COLOR_TITLE, COLOR_WHITE,   COLOR_BLACK);
	return;
}

// headattr() Function
void headattr () {
	color_set (COLOR_HEAD, NULL);
	attron (WA_BOLD);
	return;
}

// subattr() Function
void subattr () {
	color_set (COLOR_SUB, NULL);
	attroff (WA_BOLD);
	return;
}

// dataattr() Function
void dataattr () {
	color_set (COLOR_DATA, NULL);
	attroff (WA_BOLD);
	return;
}
#endif

