/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    stat.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlestat ()
//	determine the correct procedure to use
void handlestat () {
	//  kernel 2.4
	if (KERNEL==VER24) handlestatv24();
	//  kernel 2.2
	if (KERNEL==VER22) handlestatv22();
	//  kernel 2.0
	if (KERNEL==VER20) handlestatv20();
}

// handlestatv20() Function
// 	code specific to the Linux Kernel 2.0
void handlestatv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	char field [INPUT_STRING];
	char strsec [INPUT_STRING];
	long int totalsec;
	long int numsec;
	long int nummin;
	long int numhour;
	long int cpuuser, cpunice, cpusys, cpuidle;

	sprintf (filename, "%sstat", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		sscanf (tmpstring, "%s", field);
		if (strcmp(field, "cpu")==0) {
			sscanf (tmpstring, "%s %s %s %s %s", field, PROCINFO[PROC_CPUUSER], PROCINFO[PROC_CPUNICE], PROCINFO[PROC_CPUSYS], PROCINFO[PROC_CPUIDLE]);
			// PROC_CPUUSER
			strncpy (strsec, PROCINFO[PROC_CPUUSER], INPUT_STRING-1);
			PROCINFO[PROC_CPUUSER][INPUT_STRING-1]=0;
			cpuuser=atol(strsec);
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUUSER], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUNICE
			strncpy (strsec, PROCINFO[PROC_CPUNICE], INPUT_STRING-1);
			PROCINFO[PROC_CPUNICE][INPUT_STRING-1]=0;
			cpunice=atol(strsec);
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUNICE], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUSYS
			strncpy (strsec, PROCINFO[PROC_CPUSYS], INPUT_STRING-1);
			PROCINFO[PROC_CPUSYS][INPUT_STRING-1]=0;
			cpusys=atol(strsec);
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUSYS], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUIDLE
			cpuidle = (((UPTIME*100)*(NUM_CPU+1)) - (cpuuser + cpunice + cpusys));
			totalsec = cpuidle / 100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUIDLE], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
		}
		if (strcmp(field, "disk")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISK);
		}
		if (strcmp(field, "disk_rio")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKRIO);
		}
		if (strcmp(field, "disk_wio")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKWIO);
		}
		if (strcmp(field, "disk_rblk")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKRBLK);
		}
		if (strcmp(field, "disk_wblk")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKWBLK);
		}
		if (strcmp(field, "page")==0) {
			sscanf (tmpstring, "%s %s %s", field, PROCINFO[PROC_PAGE_IN], PROCINFO[PROC_PAGE_OUT]);
		}
		if (strcmp(field, "swap")==0) {
			sscanf (tmpstring, "%s %s %s", field, PROCINFO[PROC_SWAP_IN], PROCINFO[PROC_SWAP_OUT]);
		}
		if (strcmp(field, "intr")==0) {
		}
		if (strcmp(field, "ctxt")==0) {
			sscanf (tmpstring, "%s %s", field, PROCINFO[PROC_CTXT]);
		}
		if (strcmp(field, "btime")==0) {
			sscanf (tmpstring, "%s %ld", field, &BOOTTIME);
			strncpy (tmpstring, ctime(&BOOTTIME), INPUT_STRING-1);
			tmpstring[INPUT_STRING-1]=0;
			killcrlf (tmpstring, strlen(tmpstring));
			strncpy (PROCINFO[PROC_BTIME], tmpstring, STORAGE_STRING-1);
			PROCINFO[PROC_BTIME][STORAGE_STRING-1]=0;
		}
		if (strcmp(field, "processes")==0) {
			sscanf (tmpstring, "%s %s", field, PROCINFO[PROC_PROCESS]);
		}
	} while (0==0);
	// Cleanup
	fclose (filep);
	return;
}

// handlestatv22() Function
// 	code specific to the Linux Kernel 2.2
void handlestatv22 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	char field [INPUT_STRING];
	char strsec [INPUT_STRING];
	long int totalsec;
	long int numsec;
	long int nummin;
	long int numhour;
	int i=0;

	sprintf (filename, "%sstat", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		sscanf (tmpstring, "%s", field);
		if (strcmp(field, "cpu")==0) {
			sscanf (tmpstring, "%s %s %s %s %s", field, PROCINFO[PROC_CPUUSER], PROCINFO[PROC_CPUNICE], PROCINFO[PROC_CPUSYS], PROCINFO[PROC_CPUIDLE]);
			// PROC_CPUUSER
			strncpy (strsec, PROCINFO[PROC_CPUUSER], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUUSER], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUNICE
			strncpy (strsec, PROCINFO[PROC_CPUNICE], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUNICE], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUSYS
			strncpy (strsec, PROCINFO[PROC_CPUSYS], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUSYS], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUIDLE
			strncpy (strsec, PROCINFO[PROC_CPUIDLE], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUIDLE], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// Single-CPU Computers
			if (NUM_CPU==0) {
				strncpy (CPU[0]->USER, PROCINFO[PROC_CPUUSER], STORAGE_STRING-1);
				CPU[0]->USER[STORAGE_STRING-1]=0;
				strncpy (CPU[0]->NICE, PROCINFO[PROC_CPUNICE], STORAGE_STRING-1);
				CPU[0]->NICE[STORAGE_STRING-1]=0;
				strncpy (CPU[0]->SYS,  PROCINFO[PROC_CPUSYS],  STORAGE_STRING-1);
				CPU[0]->SYS[STORAGE_STRING-1]=0;
				strncpy (CPU[0]->IDLE, PROCINFO[PROC_CPUIDLE], STORAGE_STRING-1);
				CPU[0]->IDLE[STORAGE_STRING-1]=0;
			}
		}
		if ((strncmp(field, "cpu", 3)==0) & (isdigit(field[3])!=0)) {
			sscanf (field, "%*3s%d", &i);
			sscanf (tmpstring, "%s %s %s %s %s", field, CPU[i]->USER, CPU[i]->NICE, CPU[i]->SYS, CPU[i]->IDLE);
			// CPU.USER
			strncpy (strsec, CPU[i]->USER, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->USER, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// CPU.NICE
			strncpy (strsec, CPU[i]->NICE, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->NICE, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// CPU.SYS
			strncpy (strsec, CPU[i]->SYS, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->SYS, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// CPU.IDLE
			strncpy (strsec, CPU[i]->IDLE, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->IDLE, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
		}
		if (strcmp(field, "disk")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISK);
		}
		if (strcmp(field, "disk_rio")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKRIO);
		}
		if (strcmp(field, "disk_wio")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKWIO);
		}
		if (strcmp(field, "disk_rblk")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKRBLK);
		}
		if (strcmp(field, "disk_wblk")==0) {
			sscanf (tmpstring, "%s %d", field, &PROC_DISKWBLK);
		}
		if (strcmp(field, "page")==0) {
			sscanf (tmpstring, "%s %s %s", field, PROCINFO[PROC_PAGE_IN], PROCINFO[PROC_PAGE_OUT]);
		}
		if (strcmp(field, "swap")==0) {
			sscanf (tmpstring, "%s %s %s", field, PROCINFO[PROC_SWAP_IN], PROCINFO[PROC_SWAP_OUT]);
		}
		if (strcmp(field, "intr")==0) {
		}
		if (strcmp(field, "ctxt")==0) {
			sscanf (tmpstring, "%s %s", field, PROCINFO[PROC_CTXT]);
		}
		if (strcmp(field, "btime")==0) {
			sscanf (tmpstring, "%s %ld", field, &BOOTTIME);
			strncpy (tmpstring, ctime(&BOOTTIME), INPUT_STRING-1);
			tmpstring[INPUT_STRING-1]=0;
			killcrlf (tmpstring, strlen(tmpstring));
			strncpy (PROCINFO[PROC_BTIME], tmpstring, STORAGE_STRING-1);
			PROCINFO[PROC_BTIME][STORAGE_STRING-1]=0;
		}
		if (strcmp(field, "processes")==0) {
			sscanf (tmpstring, "%s %s", field, PROCINFO[PROC_PROCESS]);
		}
	} while (0==0);
	// Cleanup
	fclose (filep);
	return;
}

// handlestatv24() Function
// 	code specific to the Linux Kernel 2.4
void handlestatv24 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	char field [INPUT_STRING];
	char strsec [INPUT_STRING];
	long int totalsec;
	long int numsec;
	long int nummin;
	long int numhour;
	char diskstat [INPUT_STRING];
	int i=0;

	sprintf (filename, "%sstat", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgetstr (filep, tmpstring, INPUT_STRING);
		if (feof(filep)!=0) break;
		sscanf (tmpstring, "%s", field);
		if (strcmp(field, "cpu")==0) {
			sscanf (tmpstring, "%s %s %s %s %s", field, PROCINFO[PROC_CPUUSER], PROCINFO[PROC_CPUNICE], PROCINFO[PROC_CPUSYS], PROCINFO[PROC_CPUIDLE]);
			// PROC_CPUUSER
			strncpy (strsec, PROCINFO[PROC_CPUUSER], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUUSER], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUNICE
			strncpy (strsec, PROCINFO[PROC_CPUNICE], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUNICE], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUSYS
			strncpy (strsec, PROCINFO[PROC_CPUSYS], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUSYS], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// PROC_CPUIDLE
			strncpy (strsec, PROCINFO[PROC_CPUIDLE], INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (PROCINFO[PROC_CPUIDLE], "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// Single-CPU Computers
			if (NUM_CPU==0) {
				strncpy (CPU[0]->USER, PROCINFO[PROC_CPUUSER], STORAGE_STRING-1);
				CPU[0]->USER[STORAGE_STRING-1]=0;
				strncpy (CPU[0]->NICE, PROCINFO[PROC_CPUNICE], STORAGE_STRING-1);
				CPU[0]->NICE[STORAGE_STRING-1]=0;
				strncpy (CPU[0]->SYS,  PROCINFO[PROC_CPUSYS],  STORAGE_STRING-1);
				CPU[0]->SYS[STORAGE_STRING-1]=0;
				strncpy (CPU[0]->IDLE, PROCINFO[PROC_CPUIDLE], STORAGE_STRING-1);
				CPU[0]->IDLE[STORAGE_STRING-1]=0;
			}
		}
		if ((strncmp(field, "cpu", 3)==0) & (isdigit(field[3])!=0)) {
			sscanf (field, "%*3s%d", &i);
			sscanf (tmpstring, "%s %s %s %s %s", field, CPU[i]->USER, CPU[i]->NICE, CPU[i]->SYS, CPU[i]->IDLE);
			// CPU.USER
			strncpy (strsec, CPU[i]->USER, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->USER, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// CPU.NICE
			strncpy (strsec, CPU[i]->NICE, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->NICE, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// CPU.SYS
			strncpy (strsec, CPU[i]->SYS, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->SYS, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
			// CPU.IDLE
			strncpy (strsec, CPU[i]->IDLE, INPUT_STRING-1);
			strsec[INPUT_STRING-1]=0;
			totalsec=atol(strsec)/100;
			numhour=totalsec/3600;
			nummin=(totalsec-(numhour*3600))/60;
			numsec=(totalsec-(numhour*3600)-(nummin*60));
			sprintf (CPU[i]->IDLE, "%7ld Seconds (%3ld:%.2ld:%.2ld)", totalsec, numhour, nummin, numsec);
		}
		if (strcmp(field, "disk_io:")==0) {
			// remove "disk_io: (x,x,x):(" from string
			strncpy (diskstat, tmpstring+16, INPUT_STRING);
			sscanf (diskstat, "%d,%d,%d,%d,%d", &PROC_DISK, &PROC_DISKRIO, &PROC_DISKWIO, &PROC_DISKRBLK, &PROC_DISKWBLK);
		}
		if (strcmp(field, "page")==0) {
			sscanf (tmpstring, "%s %s %s", field, PROCINFO[PROC_PAGE_IN], PROCINFO[PROC_PAGE_OUT]);
		}
		if (strcmp(field, "swap")==0) {
			sscanf (tmpstring, "%s %s %s", field, PROCINFO[PROC_SWAP_IN], PROCINFO[PROC_SWAP_OUT]);
		}
		if (strcmp(field, "ctxt")==0) {
			sscanf (tmpstring, "%s %s", field, PROCINFO[PROC_CTXT]);
		}
		if (strcmp(field, "btime")==0) {
			sscanf (tmpstring, "%s %ld", field, &BOOTTIME);
			strncpy (tmpstring, ctime(&BOOTTIME), INPUT_STRING-1);
			tmpstring[INPUT_STRING-1]=0;
			killcrlf (tmpstring, strlen(tmpstring));
			strncpy (PROCINFO[PROC_BTIME], tmpstring, STORAGE_STRING-1);
			PROCINFO[PROC_BTIME][STORAGE_STRING-1]=0;
		}
		if (strcmp(field, "processes")==0) {
			sscanf (tmpstring, "%s %s", field, PROCINFO[PROC_PROCESS]);
		}
	} while (0==0);
	// Cleanup
	fclose (filep);
	return;
}

