/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* imageliste.h */


#ifndef _IMAGELISTE_H_
#define _IMAGELISTE_H_

#include <qiconview.h>

#include <qevent.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qdragobject.h>

#include <kprocess.h>
#include <kiconview.h>
#include <kfileiconview.h>
#include <kaccel.h>
#include <kaction.h>

#include "imageloader.h"
#include "fileitem.h"

class FileItem;

class MainWindow;   

class ImageListeView:public KFileIconView
{
	Q_OBJECT;
  
public:
	ImageListeView (QWidget * parent, const char *name, MainWindow * mw);

	void initMenu(KActionCollection *actionCollection);

	void keyPressEvent (QKeyEvent * e); 
	void mousePress (QMouseEvent * e);
	void contentsMousePressEvent (QMouseEvent * e);
	void contentsMouseReleaseEvent ( QMouseEvent * e );
	void contentsMouseMoveEvent ( QMouseEvent * e );

	virtual void setItemTextPos ( ItemTextPos pos );

	bool doPreload();
	void setPreload(bool p);

	bool doLoop();
	void setLoop(bool loop);

	bool doRandom();
	void setRandom(bool ran);

	bool checkTrash();
	void setCheckTrash(bool trash);
	bool checkDelete();
	void setCheckDelete(bool del);
	bool checkShred();
	void setCheckShred(bool shred);

	FileItem* firstItem ();
	FileItem* currentItem();
	FileItem* lastItem();

	void refresh ();
	void stopLoading ();
	void setThumbnailSize(QSize newSize);

	void sort();

	FileItem* findItem (const QString & text) const;
	QString currentItemName();
	void setCurrentItemName(QString itemName, bool select=true);
	bool hasImages();
	bool hasImageSelected();

	bool inFullScreen;
	bool preview;

signals:
	void loadFinish();

protected:
	QDragObject* dragObject();
	void focusInEvent ( QFocusEvent * );
	void showEvent ( QShowEvent * );
	void highlight(const KFileViewItem *item);
	int sortMode;
     
protected slots:
	void selectionChanged();
	void deletionDone( KIO::Job *);

public slots:
	void slotByName();
	void slotByExtension();
	void slotBySize();
	void slotByDate();

	void slotWallpaper ();
	void slotGimp ();
	void slotEndGimp (KProcess *proc);

	void slotSupprimmer ();  
	void slotMoveToTrash();
	void slotShred();  
	
	void slotFilesMoveTo();
	void slotFilesCopyTo();  

	void slotFileProperty();
	void slotImageProperty();
	void slotImageInfo();

	void endRenamed(QIconViewItem*);

	void next ();
	void previous ();
	void first ();
	void last ();

	void slotOpenWith();
	void slotRename();

	void slotSetPixmap (const QPixmap * pm);

	void slotLoadFirst ();
	void slotLoadFirst(FileItem *item);
	void slotLoadNext ();
	void slotResetThumbnail();

	void slotInvertSelection();
	void slotUnselectAll();
	void slotSelectAll();
	virtual void slotUpdate ();
  
private:
	bool trash, del, shred;

	bool loop; //loop icons
	bool p; //preload
	bool random; //random

	MainWindow *mw;
	ImageLoader * il;
	FileItem *imageLoading;

	KPopupMenu *popup;
	KActionCollection *actionCollection;
};


#endif
